/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ndk.NativeWorkspaceService;
import com.android.tools.idea.run.AndroidNativeDebugProcess;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.ndk.DeviceHelper;
import com.android.tools.ndk.MemoryRegionMap;
import com.android.tools.ndk.run.LaunchNativeDebuggerNotifier;
import com.android.tools.ndk.run.NativeDebuggerAppContext;
import com.android.tools.ndk.run.OptimizedFileNotificationProvider;
import com.android.tools.ndk.run.SymbolDir;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.utils.FileUtils;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNativeAppDebugProcess
extends CidrDebugProcess
implements AndroidNativeDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidNativeAppDebugProcess.class);
    private static final String LIBART_SO = "libart.so";
    private static final String LIBARTD_SO = "libartd.so";
    private static final String ART_SIGSEGV_FAULT = "art_sigsegv_fault";
    private static final String ART_SIGBUS_FAULT = "art_sigbus_fault";
    private static final List<String> SKIPPABLE_UNITY_SIGNALS = ImmutableList.of((Object)"SIGPWR", (Object)"SIGXCPU");
    private static final List<String> UNITY_IDENTIFYING_LIBRARIES = ImmutableList.of((Object)"libil2cpp.so", (Object)"libmono.so");
    private static final CidrSymbolicBreakpointType SYMBOLIC_BREAKPOINT_TYPE = (CidrSymbolicBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class);
    private final SessionStarter mySessionStarter;
    private final String mySessionId;
    private long myStops = 0L;
    private long myErrors = 0L;
    private boolean myReportedSessionEnd = false;
    private final boolean mySigSegvFaultReliable;
    private static final Map<String, String> DANGEROUS_COMPILER_FLAGS = ImmutableMap.of((Object)"-flto", (Object)"Combining -flto with -g is currently experimental and expected to produce unexpected results", (Object)"-Wl,--gc-sections", (Object)"can remove unused functions, breaking expression evaluation");
    private final XDebugSession myXDebugSession;
    private final Project myProject;
    private final Client myClient;
    private XBreakpoint<CidrSymbolicBreakpointType.Properties> myArtSigSegvFaultBp;
    private XBreakpoint<CidrSymbolicBreakpointType.Properties> myArtSigBusFaultBp;
    private boolean myIsArtVm = false;
    private final MemoryRegionMap myArtMemRegionMap = new MemoryRegionMap(Arrays.asList(".*\\.dex", ".*\\.odex", ".*\\.oat"));
    private final boolean myDetachOnStop;
    private final Abi myLldbServerAbi;
    private final Set<LLModule> myLoadedModules = Sets.newHashSet();
    private final Map<File, File> myModuleToSymbols;
    private final JdwpConnector myJdwpConnector;

    public AndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder2, @NotNull SessionStarter sessionStarter, @Nullable JdwpConnector jdwpConnector, @NotNull Client client, boolean detachOnStop, @NotNull Abi lldbServerAbi) throws ExecutionException {
        super(parameters, session, consoleBuilder2);
        this.myXDebugSession = session;
        this.mySessionId = sessionId;
        this.mySessionStarter = sessionStarter;
        session.addSessionListener((XDebugSessionListener)new WarnIfOptimizedListener());
        AndroidLLDBDriverConfiguration configuration = (AndroidLLDBDriverConfiguration)this.myRunParameters.getDebuggerDriverConfiguration();
        if (!configuration.getClientABIs().isEmpty()) {
            Abi abi = configuration.getClientABIs().get(0);
            this.myModuleToSymbols = configuration.getExplicitModuleSymbolMap(abi);
        } else {
            this.myModuleToSymbols = Collections.emptyMap();
        }
        this.myProject = session.getProject();
        this.myClient = client;
        this.myDetachOnStop = detachOnStop;
        this.myLldbServerAbi = lldbServerAbi;
        this.myJdwpConnector = jdwpConnector;
        AndroidVersion ver = this.mySessionStarter.getDevice().getVersion();
        LOG.info("Running on Android API level " + ver.getApiLevel());
        this.mySigSegvFaultReliable = ver.getApiLevel() > 27 || "P".equals(ver.getCodename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        TaskInfo taskInfo = new TaskInfo(this){

            @NotNull
            public String getTitle() {
                return "Start Native debug process";
            }

            public String getCancelText() {
                return "Stop Native Debug Session";
            }

            public String getCancelTooltipText() {
                return null;
            }

            public boolean isCancellable() {
                return true;
            }
        };
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(this.myProject, taskInfo);
        indicator.start();
        try {
            this.mySessionStarter.pushFilesToDevice((ProgressIndicator)indicator);
            AndroidLLDBDriver androidDriver = (AndroidLLDBDriver)driver;
            ClientData clientData = this.myClient.getClientData();
            indicator.checkCanceled();
            indicator.setText("Loading debugger driver");
            DebuggerDriver.Inferior inferior = androidDriver.loadForAttach(clientData.getPid(), (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
                LOG.info(String.format("Attaching to inferior: pid=%d, ABI=%s", clientData.getPid(), clientData.getAbi()));
                indicator.setText("Attaching to the app");
            }), (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
                boolean bl = this.myIsArtVm = DeviceHelper.getRuntime(this.mySessionStarter.getDevice()) == DeviceHelper.RuntimeVersion.ART;
                if (this.myIsArtVm) {
                    LOG.info("Running in ART VM");
                    boolean isDebugLibArtSo = DeviceHelper.isDebugLibArtSo(this.mySessionStarter.getDevice());
                    if (isDebugLibArtSo) {
                        LOG.info("Using debug libart.so");
                    }
                    this.initArtSigSegvFaultBreakpoint(driver, isDebugLibArtSo);
                    this.initArtSigBusFaultBreakpoint(driver, isDebugLibArtSo);
                } else {
                    LOG.info("Running in Dalvik VM");
                }
                this.loadExplicitSymbols();
            }));
            return inferior;
        }
        finally {
            indicator.finish(taskInfo);
        }
    }

    @NotNull
    public Client getClient() {
        return this.myClient;
    }

    public boolean isDetachDefault() {
        if (this.myDetachOnStop) {
            return true;
        }
        int apiLevel = this.mySessionStarter.getDevice().getVersion().getApiLevel();
        if (29 <= apiLevel && apiLevel <= 33) {
            LOG.warn("Detaching instead of killing app");
            return true;
        }
        return false;
    }

    @NotNull
    protected XBreakpointManager getBreakpointManager() {
        return XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    @NotNull
    protected static Application getApp() {
        return ApplicationManager.getApplication();
    }

    private void initArtSigSegvFaultBreakpoint(@NotNull DebuggerDriver driver, boolean isDebugLibArtSo) throws ExecutionException {
        String libartSo = isDebugLibArtSo ? LIBARTD_SO : LIBART_SO;
        AndroidNativeAppDebugProcess.getApp().runReadAction(() -> {
            for (XBreakpoint bp : this.getBreakpointManager().getBreakpoints((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE)) {
                CidrSymbolicBreakpointType.Properties bpProps = (CidrSymbolicBreakpointType.Properties)bp.getProperties();
                if (!libartSo.equals(bpProps.getModuleName()) || !ART_SIGSEGV_FAULT.equals(bpProps.getSymbolPattern())) continue;
                this.myArtSigSegvFaultBp = bp;
                break;
            }
        });
        if (this.myArtSigSegvFaultBp == null) {
            AndroidNativeAppDebugProcess.getApp().invokeLater(() -> AndroidNativeAppDebugProcess.getApp().runWriteAction(() -> {
                CidrSymbolicBreakpointType.Properties props = new CidrSymbolicBreakpointType.Properties(ART_SIGSEGV_FAULT, libartSo);
                this.myArtSigSegvFaultBp = this.getBreakpointManager().addBreakpoint((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE, (XBreakpointProperties)props);
            }));
        }
        try {
            if (this.mySigSegvFaultReliable) {
                if (this.myLldbServerAbi == Abi.ARMEABI_V7A || this.myLldbServerAbi == Abi.ARMEABI || this.myLldbServerAbi == Abi.X86) {
                    LOG.info("32-bit system detected, executing a simple LLDB print command to avoid future segfaults during JIT expression evaluation");
                    driver.executeInterpreterCommand("print 1");
                }
                LOG.info("Changing SIGSEGV handling to pass-through.");
                driver.handleSignal("SIGSEGV", false, true, false);
            } else {
                LOG.info("SIGSEGV handling is unreliable on this ART version. Changing SIGSEGV handling to stop.");
                driver.handleSignal("SIGSEGV", true, true, true);
            }
        }
        catch (DebuggerCommandException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private void initArtSigBusFaultBreakpoint(@NotNull DebuggerDriver driver, boolean isDebugLibArtSo) throws ExecutionException {
        String libartSo = isDebugLibArtSo ? LIBARTD_SO : LIBART_SO;
        AndroidNativeAppDebugProcess.getApp().runReadAction(() -> {
            for (XBreakpoint bp : this.getBreakpointManager().getBreakpoints((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE)) {
                CidrSymbolicBreakpointType.Properties bpProps = (CidrSymbolicBreakpointType.Properties)bp.getProperties();
                if (!libartSo.equals(bpProps.getModuleName()) || !ART_SIGBUS_FAULT.equals(bpProps.getSymbolPattern())) continue;
                this.myArtSigBusFaultBp = bp;
                break;
            }
        });
        if (this.myArtSigBusFaultBp == null) {
            AndroidNativeAppDebugProcess.getApp().invokeLater(() -> AndroidNativeAppDebugProcess.getApp().runWriteAction(() -> {
                CidrSymbolicBreakpointType.Properties props = new CidrSymbolicBreakpointType.Properties(ART_SIGBUS_FAULT, libartSo);
                this.myArtSigBusFaultBp = this.getBreakpointManager().addBreakpoint((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE, (XBreakpointProperties)props);
            }));
        }
        try {
            LOG.info("Changing SIGBUS handling to pass-through.");
            driver.handleSignal("SIGBUS", false, true, false);
        }
        catch (DebuggerCommandException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private void loadExplicitSymbols() {
        for (Map.Entry<File, File> entry : this.myModuleToSymbols.entrySet()) {
            String cmd = String.format("target modules add -s \"%s\" \"%s\"", entry.getValue().getAbsolutePath(), entry.getKey().getAbsolutePath());
            this.executeConsoleCommand(cmd);
        }
    }

    public void stop() {
        super.stop();
        if (this.myJdwpConnector != null) {
            this.myJdwpConnector.dispose();
        }
        AndroidNativeAppDebugProcess.getApp().invokeLater(() -> AndroidNativeAppDebugProcess.getApp().runWriteAction(() -> {
            if (this.myArtSigSegvFaultBp != null && !this.myProject.isDisposed()) {
                XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager().removeBreakpoint(this.myArtSigSegvFaultBp);
                this.myArtSigSegvFaultBp = null;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUnityApp() {
        Set<LLModule> set = this.myLoadedModules;
        synchronized (set) {
            for (String unityLibrary : UNITY_IDENTIFYING_LIBRARIES) {
                if (!this.myLoadedModules.stream().anyMatch(module -> module.getName().equals(unityLibrary))) continue;
                return true;
            }
        }
        return false;
    }

    public void handleSignal(final @NotNull DebuggerDriver.StopPlace stopPlace, final @NotNull String signal, final @NotNull String meaning) {
        if (SKIPPABLE_UNITY_SIGNALS.contains(signal)) {
            this.postCommand(new CidrDebugProcess.VoidDebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (AndroidNativeAppDebugProcess.this.isUnityApp()) {
                        for (String skippableUnixSignal : SKIPPABLE_UNITY_SIGNALS) {
                            try {
                                driver.handleSignal(skippableUnixSignal, false, true, false);
                            }
                            catch (DebuggerCommandException e) {
                                throw new ExecutionException((Throwable)e);
                            }
                        }
                        driver.resume();
                    } else {
                        AndroidNativeAppDebugProcess.super.handleSignal(stopPlace, signal, meaning);
                    }
                }
            });
            return;
        }
        if (this.myIsArtVm && signal.equals("SIGSEGV")) {
            this.postCommand(new CidrDebugProcess.VoidDebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (!AndroidNativeAppDebugProcess.this.handleArtSigSegv(driver, stopPlace.thread)) {
                        AndroidNativeAppDebugProcess.super.handleSignal(stopPlace, signal, meaning);
                    }
                }
            });
            return;
        }
        super.handleSignal(stopPlace, signal, meaning);
    }

    private boolean handleArtSigSegv(@NotNull DebuggerDriver driver, @NotNull LLThread thread) {
        try {
            List frames = driver.getFrames((LLThread)thread, (int)0, (int)1).list;
            if (frames.isEmpty()) {
                return false;
            }
            LLFrame firstFrame = (LLFrame)frames.get(0);
            LOG.info("Got SIGSEGV signal, PC address: " + String.valueOf(firstFrame.getProgramCounter()));
            MemoryRegionMap.Region region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter().unsignedLongValue());
            if (region == null || !region.isExecutable()) {
                this.myArtMemRegionMap.clear();
                String procMapsContent = this.readProcMapsFile(driver);
                this.myArtMemRegionMap.addMapEntries(StringUtil.splitByLines((String)procMapsContent));
            }
            if ((region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter().unsignedLongValue())) != null && region.isExecutable()) {
                LOG.info(String.format("SIGSEGV came from ART module '%s' - resuming the inferior", region.getFileName()));
                driver.resume();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    @NotNull
    private String readProcMapsFile(@NotNull DebuggerDriver driver) throws ExecutionException {
        return driver.executeShellCommand("cat", (List)Lists.newArrayList((Object[])new String[]{String.format("/proc/%d/maps", this.myClient.getClientData().getPid())}), null, 0).getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleModulesLoaded(@NotNull List<LLModule> modules) {
        TaskInfo taskInfo = new TaskInfo(this){

            @NotNull
            public String getTitle() {
                return "Load modules";
            }

            public String getCancelText() {
                return "Stop Native Debug Session";
            }

            public String getCancelTooltipText() {
                return null;
            }

            public boolean isCancellable() {
                return false;
            }
        };
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(this.myProject, taskInfo);
        indicator.start();
        for (LLModule m : modules) {
            indicator.setText("Loaded module: " + String.valueOf(m));
        }
        super.handleModulesLoaded(modules);
        Set<LLModule> set = this.myLoadedModules;
        synchronized (set) {
            this.myLoadedModules.addAll(modules);
        }
        indicator.finish(taskInfo);
    }

    protected long doStartTarget(@NotNull DebuggerDriver.Inferior inferior) throws ExecutionException {
        long ret = super.doStartTarget(inferior);
        try {
            this.mySessionStarter.sessionStarted(this.myXDebugSession);
        }
        catch (ExecutionException launchException) {
            if (launchException.getCause() instanceof TimeoutException && this.myXDebugSession.isPaused()) {
                throw new ExecutionException("Timed out waiting for java debugger to attach because the native debugger paused the app. Disable all native breakpoints and try attaching again.");
            }
            throw launchException;
        }
        LOG.info("Launch has been completed");
        return ret;
    }

    @NotNull
    public static Set<String> getAbiNameSet(@NotNull List<Abi> abis) {
        HashSet abiNames = Sets.newHashSetWithExpectedSize((int)abis.size());
        for (Abi abi : abis) {
            abiNames.add(abi.toString());
        }
        return abiNames;
    }

    @NotNull
    public static Collection<File> getSymbolsDir(@NotNull NativeDebuggerAppContext appContext, @Nullable NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        ArrayList<SymbolDir> symDirs = new ArrayList<SymbolDir>();
        if (debuggerState != null) {
            debuggerState.getSymbolDirs().stream().map(it -> new SymbolDir.WithSubdirectories(new File(FileUtils.toSystemDependentPath((String)it)))).forEach(symDirs::add);
        }
        symDirs.addAll(appContext.getSymDirs(abis));
        ImmutableList<File> symbolDirectories = AndroidNativeAppDebugProcess.expandSymbolDirectories(symDirs);
        return symbolDirectories.stream().filter(File::isDirectory).toList();
    }

    @NotNull
    private static ImmutableList<File> expandSymbolDirectories(@NotNull Iterable<SymbolDir> dirs) {
        @NotNull LinkedHashSet<File> symDirs = new LinkedHashSet<File>();
        FileFilter symbolFileFilter = f -> {
            @NotNull String extension = Files.getFileExtension((String)f.getName()).toLowerCase();
            return extension.equals("so") || extension.equals("dwo");
        };
        for (SymbolDir symDir : dirs) {
            symDirs.add(symDir.getDir());
            if (!(symDir instanceof SymbolDir.WithSubdirectories)) continue;
            SymbolDir.WithSubdirectories withSubdirectoriesSymDir = (SymbolDir.WithSubdirectories)symDir;
            FluentIterable.from((Iterable)Files.fileTraverser().depthFirstPreOrder((Object)withSubdirectoriesSymDir.getDir())).filter(subdir -> {
                if (subdir == null) {
                    return false;
                }
                if (!subdir.isDirectory()) {
                    return false;
                }
                File[] files = subdir.listFiles(symbolFileFilter);
                return files != null && files.length != 0;
            }).copyInto(symDirs);
        }
        return ImmutableList.copyOf(symDirs);
    }

    public static void verifyNativeModel(@NotNull NativeDebuggerAppContext appContext, @NotNull List<Abi> abis) {
        Project project = appContext.getProject();
        Set depModuleNames = appContext.getModulesToVerify().stream().map(Module::getName).collect(Collectors.toSet());
        NativeWorkspaceService nativeWorkspaceService = NativeWorkspaceService.Companion.getInstance(project);
        Set<String> abiNames = AndroidNativeAppDebugProcess.getAbiNameSet(abis);
        HashMap badFlagsBySourceFiles = new HashMap();
        HashMap fileToModuleName = new HashMap();
        nativeWorkspaceService.getCompilerSettings(moduleVariantAbi -> depModuleNames.contains(moduleVariantAbi.getModuleName()) && abiNames.contains(moduleVariantAbi.getAbiName())).forEach(settings -> {
            ArrayList<String> badFlags = new ArrayList<String>(DANGEROUS_COMPILER_FLAGS.keySet());
            badFlags.retainAll(settings.getCompilerFlags());
            if (!badFlags.isEmpty()) {
                badFlagsBySourceFiles.put(settings.getSource().getPath(), badFlags);
                fileToModuleName.put(settings.getSource().getPath(), settings.getModuleVariantAbi().getModuleName());
            }
        });
        SetMultimap sourceFilesByBadFlags = (SetMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap(badFlagsBySourceFiles), (Multimap)HashMultimap.create());
        for (List badFlags : sourceFilesByBadFlags.keySet()) {
            Set sourceFiles = sourceFilesByBadFlags.get((Object)badFlags);
            if (sourceFiles.isEmpty()) continue;
            String anySourceFile = (String)Iterables.getFirst((Iterable)sourceFiles, null);
            String mainWarning = sourceFiles.size() == 1 ? String.format("Source file %s in module %s is using compiler flags which may be debug incompatible:", anySourceFile, fileToModuleName.get(anySourceFile)) : String.format("Source file %s (and %s others) in module %s are using compiler flags which may be debug incompatible:", anySourceFile, sourceFiles.size() - 1, fileToModuleName.get(anySourceFile));
            LaunchNativeDebuggerNotifier.INSTANCE.notifyWarning(project, mainWarning);
            LOG.warn(mainWarning);
            for (String badFlag : badFlags) {
                String flagWarning = String.format("    %s: %s", badFlag, DANGEROUS_COMPILER_FLAGS.get(badFlag));
                LaunchNativeDebuggerNotifier.INSTANCE.notifyWarning(project, flagWarning);
                LOG.warn(flagWarning);
            }
        }
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull CidrDebugProcess.DebuggerCommand command, @NotNull ExecutionException exception) {
        super.handleCommandException(driver, command, exception);
        ++this.myErrors;
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class) && !ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class) && this.reportSessionEnd()) {
            this.reportSessionFailed(exception);
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DebuggerFatalException.class);
        if ((command instanceof CidrDebugProcess.DebuggerStartupCommand || isFatalError) && this.reportSessionEnd()) {
            this.reportSessionFailed(exception);
        }
    }

    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        ++this.myStops;
        LLFrame frame = stopPlace.frame;
        if (frame.getFile() == null && frame.getLine() == -1 && frame.getProgramCounter().getUnsignedLongValue() == -1L) {
            return;
        }
        super.handleInterrupted(stopPlace);
    }

    private void reportSessionFailed(@NotNull Throwable e) {
        LOG.warn(e);
        LLDBUsageTracker.sessionFailed(e, this.mySessionId, this.myStops, this.myErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean reportSessionEnd() {
        AndroidNativeAppDebugProcess androidNativeAppDebugProcess = this;
        synchronized (androidNativeAppDebugProcess) {
            if (this.myReportedSessionEnd) {
                return false;
            }
            this.myReportedSessionEnd = true;
            return true;
        }
    }

    public void handleTargetTerminated(@NotNull DebuggerDriver.ExitStatus exitStatus) {
        super.handleTargetTerminated(exitStatus);
        if (this.reportSessionEnd()) {
            LLDBUsageTracker.sessionStopped(this.mySessionId, this.myStops, this.myErrors);
        }
    }

    public void handleExited(int code) {
        LOG.info("LLDBFrontend exited with code " + code);
        super.handleExited(code);
        if (this.reportSessionEnd()) {
            if (code == 0) {
                LLDBUsageTracker.sessionStopped(this.mySessionId, this.myStops, this.myErrors);
            } else {
                ++this.myErrors;
                this.reportSessionFailed(new ExecutionException("LLDBFrontend exited with code " + code));
            }
        }
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        if (this.getSession().getRunProfile() instanceof AndroidRunConfiguration) {
            ActionManager manager = ActionManager.getInstance();
            leftToolbar.remove(manager.getAction("Rerun"));
            AnAction[] actions = leftToolbar.getChildActionsOrStubs();
            String expectedString = ExecutionBundle.message((String)"create.run.configuration.action.name", (Object[])new Object[0]);
            if (actions.length > 0 && actions[0].getTemplatePresentation().getText().equals(expectedString)) {
                leftToolbar.remove(actions[0]);
            }
        }
    }

    public boolean checkCanInitBreakpoints() {
        return !this.myDetachOnStop;
    }

    public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
        if (Boolean.getBoolean("studio.run.under.integration.test")) {
            LOG.info("Native breakpoint hit");
        }
        super.handleBreakpoint(stopPlace, breakpointNumber);
    }

    private class WarnIfOptimizedListener
    implements XDebugSessionListener {
        private Data myData = null;

        private WarnIfOptimizedListener() {
        }

        public void sessionPaused() {
            this.update();
        }

        public void sessionResumed() {
        }

        public void sessionStopped() {
            this.updateData(this.myData, null);
            this.myData = null;
        }

        public void stackFrameChanged() {
            this.update();
        }

        private void updateData(@Nullable Data data, @Nullable AndroidLLDBDriverConfiguration o) {
            if (data == null) {
                return;
            }
            for (FileEditor editor : data.editors) {
                editor.putUserData(OptimizedFileNotificationProvider.WARNING_KEY, (Object)o);
            }
            EditorNotifications.getInstance((Project)AndroidNativeAppDebugProcess.this.getProject()).updateNotifications(data.file);
        }

        private Data getData() {
            AndroidLLDBDriverConfiguration configuration = (AndroidLLDBDriverConfiguration)AndroidNativeAppDebugProcess.this.myRunParameters.getDebuggerDriverConfiguration();
            if (!configuration.isOptimizedWarningEnabled()) {
                return null;
            }
            XStackFrame frame = AndroidNativeAppDebugProcess.this.getSession().getCurrentStackFrame();
            if (frame == null) {
                return null;
            }
            XSourcePosition position = frame.getSourcePosition();
            if (position == null) {
                return null;
            }
            if (!((CidrStackFrame)frame).getFrame().getOptimized()) {
                return null;
            }
            return new Data(this, position.getFile(), FileEditorManager.getInstance((Project)AndroidNativeAppDebugProcess.this.getProject()).getAllEditors(position.getFile()));
        }

        private void update() {
            Data newData = this.getData();
            if (Objects.equals(this.myData, newData)) {
                return;
            }
            this.updateData(this.myData, null);
            this.updateData(newData, (AndroidLLDBDriverConfiguration)AndroidNativeAppDebugProcess.this.myRunParameters.getDebuggerDriverConfiguration());
            this.myData = newData;
        }

        private class Data {
            @NotNull
            public final VirtualFile file;
            @NotNull
            public final FileEditor[] editors;

            public Data(@NotNull WarnIfOptimizedListener warnIfOptimizedListener, @NotNull VirtualFile file, FileEditor[] editors) {
                this.file = file;
                this.editors = editors;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Data)) {
                    return false;
                }
                Data other = (Data)obj;
                return Objects.equals(this.file, other.file) && Arrays.equals(this.editors, other.editors);
            }

            public int hashCode() {
                int result = this.file.hashCode();
                result = 31 * result + Arrays.hashCode(this.editors);
                return result;
            }
        }
    }
}

