/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.FindClassCall;
import com.android.tools.ndk.jni.model.GetFieldIdCall;
import com.android.tools.ndk.jni.model.GetMethodIdCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.reference.JniReferenceContributorKt;
import com.android.tools.ndk.jni.reference.JvmMethodReference;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.service.RegisteredNativesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/ndk/jni/reference/JvmClassReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JvmClassReferenceProvider\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n66#2,2:229\n295#3,2:231\n*S KotlinDebug\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JvmClassReferenceProvider\n*L\n84#1:229,2\n91#1:231,2\n*E\n"})
public final class JvmClassReferenceProvider
extends PsiReferenceProvider {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        JniCall jniCall;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OCLiteralExpression oCLiteralExpression = element instanceof OCLiteralExpression ? (OCLiteralExpression)element : null;
        if (oCLiteralExpression == null) {
            return new PsiReference[0];
        }
        OCLiteralExpression literal = oCLiteralExpression;
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)literal;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType = false;
        OCCallExpression oCCallExpression = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, OCCallExpression.class, (boolean)true);
        JniCall jniCall2 = jniCall = oCCallExpression != null ? JniCallKt.toJniCall(oCCallExpression) : null;
        if (jniCall instanceof FindClassCall) {
            psiReferenceArray = JniReferenceContributorKt.buildReferencesFromFindClassCall((FindClassCall)jniCall, literal);
        } else if (jniCall instanceof GetMethodIdCall) {
            psiReferenceArray = JniReferenceContributorKt.buildReferencesFromGetMethodIdCall((GetMethodIdCall)jniCall, literal);
        } else if (jniCall instanceof GetFieldIdCall) {
            psiReferenceArray = JniReferenceContributorKt.buildReferencesFromGetFieldIdCall((GetFieldIdCall)jniCall, literal);
        } else {
            Object v7;
            block9: {
                void $this$firstOrNull$iv;
                Project project = literal.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Iterable withSelf$iv2 = JniMethodResolver.Companion.getInstance(project).processAllRegisterNatives();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RegisteredNativesBundle it = (RegisteredNativesBundle)element$iv;
                    boolean bl = false;
                    Collection collection = it.getMethodNameStringLiteralToBindingInitializer().get((Object)literal);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                    boolean bl2 = !collection.isEmpty();
                    if (!bl2) continue;
                    v7 = element$iv;
                    break block9;
                }
                v7 = null;
            }
            RegisteredNativesBundle registeredNativesBundle = v7;
            if (registeredNativesBundle == null) {
                return new PsiReference[0];
            }
            RegisteredNativesBundle matchedBundle = registeredNativesBundle;
            BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer> bidirectionalMultiMap = matchedBundle.getBindingToInitializer();
            Collection collection = matchedBundle.getMethodNameStringLiteralToBindingInitializer().get((Object)literal);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Set set = bidirectionalMultiMap.getKeys(CollectionsKt.first((Iterable)collection));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getKeys(...)");
            JvmMethodId jvmMethodId = (JvmMethodId)((Pair)CollectionsKt.first((Iterable)set)).component1();
            PsiReference[] psiReferenceArray2 = new PsiReference[]{new JvmMethodReference(jvmMethodId, literal)};
            psiReferenceArray = psiReferenceArray2;
        }
        return psiReferenceArray;
    }
}

