/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.reference.JvmReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/ndk/jni/reference/JvmClassReference;", "Lcom/android/tools/ndk/jni/reference/JvmReference;", "className", "Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "element", "Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;Lcom/intellij/openapi/util/TextRange;)V", "getClassName", "()Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "resolve", "Lcom/intellij/psi/PsiElement;", "isReferenceTo", "", "android-ndk"})
public final class JvmClassReference
extends JvmReference {
    @NotNull
    private final FullyQualifiedClassName className;

    public JvmClassReference(@NotNull FullyQualifiedClassName className, @NotNull OCLiteralExpression element, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        super(element, textRange, null);
        this.className = className;
    }

    @NotNull
    public final FullyQualifiedClassName getClassName() {
        return this.className;
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)JavaPsiFacade.getInstance((Project)((OCLiteralExpression)this.getElement()).getProject()).findClass(this.className.getJava(), GlobalSearchScope.allScope((Project)((OCLiteralExpression)this.getElement()).getProject()));
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiClass psiClass = element instanceof PsiClass ? (PsiClass)element : null;
        if (psiClass == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)FullyQualifiedClassName.Companion.fromJavaClass(psiClass), (Object)this.className);
    }
}

