/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.refactor;

import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u001cj\b\u0012\u0004\u0012\u00020\u0016`\u001dH\u0014J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u0016*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/ndk/jni/refactor/JniInplaceCxxFunctionRenamer;", "Lcom/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenamer;", "nativeMethodInfo", "Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "symbol", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "<init>", "(Lcom/android/tools/ndk/jni/model/NativeMethodInfo;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/cidr/lang/symbols/OCSymbol;)V", "getNativeMethodInfo", "()Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getSymbol", "()Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "myJvmMethodInfos", "", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "isIdentifier", "", "newName", "", "language", "Lcom/intellij/lang/Language;", "performOnInvalidIdentifier", "", "nameSuggestions", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "findIssueWhenRenamedFrom", "Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "oldNativeMethodId", "performRenameInner", "element", "Lcom/intellij/psi/PsiElement;", "JvmRenameContext", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniInplaceCxxFunctionRenamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniInplaceCxxFunctionRenamer.kt\ncom/android/tools/ndk/jni/refactor/JniInplaceCxxFunctionRenamer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1563#2:104\n1634#2,3:105\n1869#2,2:108\n*S KotlinDebug\n*F\n+ 1 JniInplaceCxxFunctionRenamer.kt\ncom/android/tools/ndk/jni/refactor/JniInplaceCxxFunctionRenamer\n*L\n86#1:104\n86#1:105,3\n94#1:108,2\n*E\n"})
public final class JniInplaceCxxFunctionRenamer
extends OCInplaceRenamer {
    @NotNull
    private final NativeMethodInfo nativeMethodInfo;
    @NotNull
    private final Editor editor;
    @NotNull
    private final OCSymbol symbol;
    @NotNull
    private final List<JvmMethodInfo> myJvmMethodInfos;

    public JniInplaceCxxFunctionRenamer(@NotNull NativeMethodInfo nativeMethodInfo, @NotNull Editor editor, @NotNull OCSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)nativeMethodInfo, (String)"nativeMethodInfo");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        OCDeclarator oCDeclarator = nativeMethodInfo.getPsiElement().getDeclarator();
        Intrinsics.checkNotNull((Object)oCDeclarator);
        super((PsiNamedElement)oCDeclarator, symbol, editor, false, nativeMethodInfo.getPsiElement().getName(), nativeMethodInfo.getPsiElement().getName());
        this.nativeMethodInfo = nativeMethodInfo;
        this.editor = editor;
        this.symbol = symbol;
        Project project = this.nativeMethodInfo.getPsiElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.myJvmMethodInfos = JniMethodResolver.Companion.getInstance(project).resolveNativeMethod(this.nativeMethodInfo);
    }

    @NotNull
    public final NativeMethodInfo getNativeMethodInfo() {
        return this.nativeMethodInfo;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final OCSymbol getSymbol() {
        return this.symbol;
    }

    protected boolean isIdentifier(@NotNull String newName, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!super.isIdentifier(newName, language)) {
            return false;
        }
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(newName);
        if (jniNativeMethodId == null) {
            return false;
        }
        JniNativeMethodId nativeMethodId = jniNativeMethodId;
        NativeMethodId nativeMethodId2 = this.nativeMethodInfo.getNativeMethodId();
        Intrinsics.checkNotNull((Object)nativeMethodId2, (String)"null cannot be cast to non-null type com.android.tools.ndk.jni.model.JniNativeMethodId");
        return this.findIssueWhenRenamedFrom(nativeMethodId, (JniNativeMethodId)nativeMethodId2) == null;
    }

    /*
     * Unable to fully structure code
     */
    protected void performOnInvalidIdentifier(@NotNull String newName, @NotNull LinkedHashSet<String> nameSuggestions) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(nameSuggestions, (String)"nameSuggestions");
        var4_3 = JniNativeMethodId.Companion.fromJniMethodName(newName);
        if (var4_3 == null) ** GOTO lbl-1000
        v0 = this.nativeMethodInfo.getNativeMethodId();
        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.android.tools.ndk.jni.model.JniNativeMethodId");
        var5_4 = this.findIssueWhenRenamedFrom(var4_3, (JniNativeMethodId)v0);
        if (var5_4 != null) {
            v1 = var5_4;
        } else lbl-1000:
        // 2 sources

        {
            v1 = "Invalid JNI-mangled function name.";
        }
        issue = v1;
        JBPopupFactory.getInstance().createMessage(issue).showInBestPositionFor(this.myEditor);
    }

    private final String findIssueWhenRenamedFrom(JniNativeMethodId $this$findIssueWhenRenamedFrom, JniNativeMethodId oldNativeMethodId) {
        if (!Intrinsics.areEqual((Object)$this$findIssueWhenRenamedFrom.getClassName(), (Object)oldNativeMethodId.getClassName())) {
            return "Cannot rename Java or Kotlin package and classes here. Please rename them in Java or Kotlin code instead.";
        }
        if (!Intrinsics.areEqual($this$findIssueWhenRenamedFrom.getArgTypes(), oldNativeMethodId.getArgTypes())) {
            return "Cannot change the mangled argument signature.";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void performRenameInner(@NotNull PsiElement element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(newName);
        Intrinsics.checkNotNull((Object)jniNativeMethodId);
        JniNativeMethodId newNativeMethodId = jniNativeMethodId;
        if (!((Collection)this.myJvmMethodInfos).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.myJvmMethodInfos;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Collection references;
                RenamePsiElementProcessor processor;
                void methodInfo;
                JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PsiElement psiElement = methodInfo.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)RenamePsiElementProcessor.forElement((PsiElement)psiElement), (String)"forElement(...)");
                Intrinsics.checkNotNullExpressionValue((Object)processor.findReferences(psiElement, (SearchScope)GlobalSearchScope.projectScope((Project)psiElement.getProject()), false), (String)"findReferences(...)");
                collection.add(new JvmRenameContext(psiElement, processor, references));
            }
            List contexts = (List)destination$iv$iv;
            ApplicationManager.getApplication().runWriteAction(() -> JniInplaceCxxFunctionRenamer.performRenameInner$lambda$1(contexts, newNativeMethodId));
        }
        super.performRenameInner(element, newName);
    }

    private static final void performRenameInner$lambda$1(List $contexts, JniNativeMethodId $newNativeMethodId) {
        for (JvmRenameContext ctx : $contexts) {
            Iterable $this$forEach$iv = ctx.getReferences();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiReference it = (PsiReference)element$iv;
                boolean bl = false;
                it.handleElementRename($newNativeMethodId.getMethodName());
            }
            ctx.getRenameProcessor().renameElement(ctx.getPsiElement(), $newNativeMethodId.getMethodName(), new UsageInfo[0], null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/ndk/jni/refactor/JniInplaceCxxFunctionRenamer$JvmRenameContext;", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "renameProcessor", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "references", "", "Lcom/intellij/psi/PsiReference;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;Ljava/util/Collection;)V", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "getRenameProcessor", "()Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "getReferences", "()Ljava/util/Collection;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-ndk"})
    private static final class JvmRenameContext {
        @NotNull
        private final PsiElement psiElement;
        @NotNull
        private final RenamePsiElementProcessor renameProcessor;
        @NotNull
        private final Collection<PsiReference> references;

        public JvmRenameContext(@NotNull PsiElement psiElement, @NotNull RenamePsiElementProcessor renameProcessor, @NotNull Collection<? extends PsiReference> references) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter((Object)renameProcessor, (String)"renameProcessor");
            Intrinsics.checkNotNullParameter(references, (String)"references");
            this.psiElement = psiElement;
            this.renameProcessor = renameProcessor;
            this.references = references;
        }

        @NotNull
        public final PsiElement getPsiElement() {
            return this.psiElement;
        }

        @NotNull
        public final RenamePsiElementProcessor getRenameProcessor() {
            return this.renameProcessor;
        }

        @NotNull
        public final Collection<PsiReference> getReferences() {
            return this.references;
        }

        @NotNull
        public final PsiElement component1() {
            return this.psiElement;
        }

        @NotNull
        public final RenamePsiElementProcessor component2() {
            return this.renameProcessor;
        }

        @NotNull
        public final Collection<PsiReference> component3() {
            return this.references;
        }

        @NotNull
        public final JvmRenameContext copy(@NotNull PsiElement psiElement, @NotNull RenamePsiElementProcessor renameProcessor, @NotNull Collection<? extends PsiReference> references) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter((Object)renameProcessor, (String)"renameProcessor");
            Intrinsics.checkNotNullParameter(references, (String)"references");
            return new JvmRenameContext(psiElement, renameProcessor, references);
        }

        public static /* synthetic */ JvmRenameContext copy$default(JvmRenameContext jvmRenameContext, PsiElement psiElement, RenamePsiElementProcessor renamePsiElementProcessor, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = jvmRenameContext.psiElement;
            }
            if ((n & 2) != 0) {
                renamePsiElementProcessor = jvmRenameContext.renameProcessor;
            }
            if ((n & 4) != 0) {
                collection = jvmRenameContext.references;
            }
            return jvmRenameContext.copy(psiElement, renamePsiElementProcessor, collection);
        }

        @NotNull
        public String toString() {
            return "JvmRenameContext(psiElement=" + this.psiElement + ", renameProcessor=" + this.renameProcessor + ", references=" + this.references + ")";
        }

        public int hashCode() {
            int result = this.psiElement.hashCode();
            result = result * 31 + this.renameProcessor.hashCode();
            result = result * 31 + ((Object)this.references).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JvmRenameContext)) {
                return false;
            }
            JvmRenameContext jvmRenameContext = (JvmRenameContext)other;
            if (!Intrinsics.areEqual((Object)this.psiElement, (Object)jvmRenameContext.psiElement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.renameProcessor, (Object)jvmRenameContext.renameProcessor)) {
                return false;
            }
            return Intrinsics.areEqual(this.references, jvmRenameContext.references);
        }
    }
}

