/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.GetFieldIdCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmArrayType;
import com.android.tools.ndk.jni.model.JvmFieldInfo;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniGetFieldIdInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspect", "", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "classType", "Lcom/android/tools/ndk/jni/model/JvmType;", "call", "Lcom/android/tools/ndk/jni/model/GetFieldIdCall;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniGetFieldIdInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniGetFieldIdInspection.kt\ncom/android/tools/ndk/jni/inspections/JniGetFieldIdInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n*L\n1#1,114:1\n51#2,9:115\n*S KotlinDebug\n*F\n+ 1 JniGetFieldIdInspection.kt\ncom/android/tools/ndk/jni/inspections/JniGetFieldIdInspection\n*L\n47#1:115,9\n*E\n"})
public final class JniGetFieldIdInspection
extends JniInspectionTool {
    public JniGetFieldIdInspection() {
        super(JniInspectionEvent.JniInspectionType.FIND_FIELD_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiElementVisitor(){};
        }
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return (PsiElementVisitor)new OCVisitor(this_$iv, holder, this){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            final /* synthetic */ JniGetFieldIdInspection this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$holder$inlined = problemsHolder;
                this.this$0 = jniGetFieldIdInspection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof GetFieldIdCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (GetFieldIdCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call = jniCall2;
                JniInspectionTool jniInspectionTool = this.this$0$inline_fun;
                PsiElement psiElement$iv = (PsiElement)expression;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = psiElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call2;
                    JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project project3 = expression.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    JniInfoInferencer inferencer = JniInfoInferencer.Companion.getInstance(project3);
                    GetFieldIdCall getFieldIdCall = (GetFieldIdCall)call;
                    JniInfoInferencer $this$buildVisitor_u24lambda_u240 = inferencer;
                    boolean bl3 = false;
                    if (call2.getFieldNameExpression() != null) {
                        if (call2.getFieldTypeExpression() == null) {
                        } else {
                            InspectionUtilsKt.inspectClass($this$buildVisitor_u24lambda_u240, this.$holder$inlined, call2.getClassExpression(), (Function2<? super JniInfoInferencer, ? super JvmType, Unit>)((Function2)new Function2<JniInfoInferencer, JvmType, Unit>(this.$holder$inlined, (GetFieldIdCall)call2, this.this$0){
                                final /* synthetic */ ProblemsHolder $holder;
                                final /* synthetic */ GetFieldIdCall $call;
                                final /* synthetic */ JniGetFieldIdInspection this$0;
                                {
                                    this.$holder = $holder;
                                    this.$call = $call;
                                    this.this$0 = $receiver;
                                }

                                public final void invoke(JniInfoInferencer $this$inspectClass, JvmType classType) {
                                    Intrinsics.checkNotNullParameter((Object)$this$inspectClass, (String)"$this$inspectClass");
                                    Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
                                    JvmType jvmType = classType;
                                    if (jvmType instanceof JvmPrimitiveType || jvmType instanceof JvmArrayType) {
                                        InspectionUtilsKt.registerOcProblem(this.$holder, (PsiElement)this.$call.getClassExpression(), "'" + classType.toShortJavaType() + "' does not have any member fields.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
                                    } else if (jvmType instanceof JvmObjectType) {
                                        JniGetFieldIdInspection.access$inspect(this.this$0, $this$inspectClass, classType, this.$call, this.$holder);
                                    } else {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                            }));
                        }
                    }
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspect(JniInfoInferencer $this$inspect, JvmType classType, GetFieldIdCall call, ProblemsHolder holder) {
        OCExpression oCExpression = call.getFieldNameExpression();
        if (oCExpression == null) {
            return;
        }
        OCExpression fieldNameExpression = oCExpression;
        OCExpression oCExpression2 = call.getFieldTypeExpression();
        if (oCExpression2 == null) {
            return;
        }
        OCExpression fieldTypeExpression = oCExpression2;
        PsiClass psiClass = JniInfoInferencer.findPsiClass$default($this$inspect, classType, false, 1, null);
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        DataSource dataSource = DataSourceKt.getDataSource((OCElement)fieldNameExpression);
        StringDataSource stringDataSource = dataSource instanceof StringDataSource ? (StringDataSource)dataSource : null;
        if (stringDataSource == null) {
            return;
        }
        StringDataSource fieldNameDataSource = stringDataSource;
        DataSource dataSource2 = DataSourceKt.getDataSource((OCElement)fieldTypeExpression);
        StringDataSource stringDataSource2 = dataSource2 instanceof StringDataSource ? (StringDataSource)dataSource2 : null;
        if (stringDataSource2 == null) {
            return;
        }
        StringDataSource fieldTypeDataSource = stringDataSource2;
        String fieldName = fieldNameDataSource.getString();
        PsiField matchedField = psiClass2.findFieldByName(fieldName, true);
        if (matchedField == null) {
            ProblemHighlightType problemType = Intrinsics.areEqual((Object)fieldNameDataSource.getSourceExpression(), (Object)call.getFieldNameExpression()) ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)fieldNameExpression, "Class '" + classType.toShortJavaType() + "' has no field named '" + fieldName + "'.", problemType, new JniLocalQuickFix[0]);
            return;
        }
        JvmFieldInfo jvmFieldInfo = JvmFieldInfo.Companion.fromPsiField(matchedField);
        if (jvmFieldInfo == null) {
            return;
        }
        JvmFieldInfo fieldInfo = jvmFieldInfo;
        if (!Intrinsics.areEqual((Object)fieldInfo.getFieldType().toJvmType(), (Object)fieldTypeDataSource.getString())) {
            JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{this.quickFix("Fix type specifier in GetFieldID call", "Fix type specifier of field '" + fieldName + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniGetFieldIdInspection.inspect$lambda$0(fieldInfo, arg_0, arg_1)))};
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)fieldTypeExpression, "Incorrect type specifier for field '" + fieldName + "'.", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
            return;
        }
        if (fieldInfo.isStatic() != call.isStatic()) {
            boolean shouldBeStatic = fieldInfo.isStatic();
            GetFieldIdCall correctCall = call.toggleStaticity();
            JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{this.quickFix("Fix JNI GetFieldID call", "Replace with '" + correctCall.getFunctionName() + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniGetFieldIdInspection.inspect$lambda$1(correctCall, arg_0, arg_1)))};
            InspectionUtilsKt.registerOcProblem(holder, call.getFunctionIdentifier(), "'" + fieldName + "' is " + (shouldBeStatic ? "a static" : "an instance") + " field and should be acquired by '" + correctCall.getFunctionName() + "'.", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
        }
    }

    private static final boolean inspect$lambda$0(JvmFieldInfo $fieldInfo, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniGetFieldIdInspection.inspect$lambda$0$0(descriptor, $fieldInfo));
    }

    private static final boolean inspect$lambda$0$0(ProblemDescriptor $descriptor, JvmFieldInfo $fieldInfo) {
        String[] stringArray = new String[]{JniUtilsKt.quoted($fieldInfo.getFieldType().toJvmType())};
        return InspectionUtilsKt.replaceAtHighlighted($descriptor, stringArray);
    }

    private static final boolean inspect$lambda$1(GetFieldIdCall $correctCall, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniGetFieldIdInspection.inspect$lambda$1$0(descriptor, $correctCall));
    }

    private static final boolean inspect$lambda$1$0(ProblemDescriptor $descriptor, GetFieldIdCall $correctCall) {
        String[] stringArray = new String[]{$correctCall.getFunctionName()};
        return InspectionUtilsKt.replaceAtHighlighted($descriptor, stringArray);
    }

    public static final /* synthetic */ void access$inspect(JniGetFieldIdInspection $this, JniInfoInferencer $receiver, JvmType classType, GetFieldIdCall call, ProblemsHolder holder) {
        $this.inspect($receiver, classType, call, holder);
    }
}

