/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.eclipse.cdt.utils.elf.Elf;
import org.jetbrains.annotations.NotNull;

public class BuildIdReader {
    @VisibleForTesting
    static final String LINKER_BUILD_ID_SECTION_NAME = ".note.gnu.build-id";
    @VisibleForTesting
    static final int BUILD_ID_OFFSET = 16;
    @VisibleForTesting
    static final int MD5_BUILD_ID_SIZE = 16;
    @VisibleForTesting
    static final int SHA1_BUILD_ID_SIZE = 20;
    @VisibleForTesting
    static final int MD5_SECTION_SIZE = 32;
    @VisibleForTesting
    static final int SHA1_SECTION_SIZE = 36;

    @NotNull
    public byte[] readBuildId(@NotNull VirtualFile file) {
        return this.readBuildId(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] readBuildId(@NotNull String path) {
        try {
            Elf elf = this.getElf(path);
            try {
                Elf.Section section = elf.getSectionByName(LINKER_BUILD_ID_SECTION_NAME);
                if (section == null) {
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                if (section.sh_size != 32L && section.sh_size != 36L) {
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                byte[] sectionData = section.loadSectionData();
                assert ((long)sectionData.length == section.sh_size);
                int buildIdSize = (int)section.sh_size - 16;
                byte[] data = new byte[buildIdSize];
                System.arraycopy(sectionData, 16, data, 0, buildIdSize);
                byte[] byArray = data;
                return byArray;
            }
            finally {
                elf.dispose();
            }
        }
        catch (IOException e) {
            BuildIdReader.getLog().info("Failed to read build ID from file.", (Throwable)e);
            return new byte[0];
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(BuildIdReader.class);
    }

    @VisibleForTesting
    @NotNull
    Elf getElf(String path) throws IOException {
        return new Elf(path);
    }
}

