/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.downloads;

import com.android.tools.idea.downloads.RemoteFileCache;
import com.android.tools.idea.downloads.UrlFileCacheKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001a\u001bB)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\rJ,\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/downloads/UrlFileCache;", "Lcom/android/tools/idea/downloads/RemoteFileCache;", "Lcom/android/tools/idea/downloads/UrlFileCache$UrlWithHeaders;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "timeSource", "Lkotlin/time/TimeSource;", "clock", "Lkotlinx/datetime/Clock;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlin/time/TimeSource;Lkotlinx/datetime/Clock;)V", "(Lkotlinx/coroutines/CoroutineScope;)V", "lastModified", "", "", "eTags", "fetchAndFilterLocked", "Ljava/nio/file/Path;", "existing", "identifier", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "start", "Lkotlin/time/TimeMark;", "UrlWithHeaders", "Companion", "intellij.android.common"})
@SourceDebugExtension(value={"SMAP\nUrlFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlFileCache.kt\ncom/android/tools/idea/downloads/UrlFileCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class UrlFileCache
extends RemoteFileCache<UrlWithHeaders> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UrlWithHeaders, String> lastModified;
    @NotNull
    private final Map<UrlWithHeaders, String> eTags;

    @TestOnly
    public UrlFileCache(@NotNull CoroutineScope coroutineScope, @NotNull CoroutineDispatcher ioDispatcher, @NotNull TimeSource timeSource, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(coroutineScope, ioDispatcher, timeSource, clock);
        this.lastModified = new LinkedHashMap();
        this.eTags = new LinkedHashMap();
    }

    public UrlFileCache(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this(coroutineScope, Dispatchers.getIO(), (TimeSource)TimeSource.Monotonic.INSTANCE, (Clock)Clock.System.INSTANCE);
    }

    @Override
    @NotNull
    protected Path fetchAndFilterLocked(@Nullable Path existing, @NotNull UrlWithHeaders identifier, @Nullable ProgressIndicator indicator, @NotNull TimeMark start) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        URL url = new URL(identifier.getUrl());
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText("Downloading from " + url.getHost());
        }
        Object object = HttpRequests.request((String)identifier.getUrl()).connectTimeout((int)Duration.getInWholeMilliseconds-impl((long)UrlFileCacheKt.access$getCONNECT_TIMEOUT$p())).readTimeout((int)Duration.getInWholeMilliseconds-impl((long)UrlFileCacheKt.access$getREAD_TIMEOUT$p())).tuner(arg_0 -> UrlFileCache.fetchAndFilterLocked$lambda$0(identifier, this, arg_0)).connect(arg_0 -> UrlFileCache.fetchAndFilterLocked$lambda$1(existing, start, identifier, this, indicator, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (Path)object;
    }

    private static final void fetchAndFilterLocked$lambda$0(UrlWithHeaders $identifier, UrlFileCache this$0, URLConnection connection) {
        block2: {
            String it;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            for (Map.Entry<String, String> entry : $identifier.getHeaders().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                connection.setRequestProperty(key, value);
            }
            String string = this$0.lastModified.get($identifier);
            if (string != null) {
                it = string;
                boolean bl = false;
                connection.setRequestProperty("If-Modified-Since", it);
            }
            String string2 = this$0.eTags.get($identifier);
            if (string2 == null) break block2;
            it = string2;
            boolean bl = false;
            connection.setRequestProperty("If-None-Match", it);
        }
    }

    private static final Path fetchAndFilterLocked$lambda$1(Path $existing, TimeMark $start, UrlWithHeaders $identifier, UrlFileCache this$0, ProgressIndicator $indicator, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URLConnection uRLConnection = request.getConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        int responseCode = ((HttpURLConnection)uRLConnection).getResponseCode();
        if (responseCode == 304) {
            if ($existing != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists($existing, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return $existing;
                }
            }
            throw new RemoteFileCache.RemoteFileCacheException(new RemoteFileCache.FetchStats($start.elapsedNow-UwyO8pc(), false, false, true, 0L, 0L, 52, null), (Exception)new HttpRequests.HttpStatusException("Received NOT_MODIFIED (304) but nothing in the cache.", 304, $identifier.getUrl()));
        }
        Path newFile = this$0.getNewWritablePath();
        try {
            request.saveToFile(newFile, $indicator);
        }
        catch (IOException e) {
            Files.deleteIfExists(newFile);
            throw new RemoteFileCache.RemoteFileCacheException(new RemoteFileCache.FetchStats($start.elapsedNow-UwyO8pc(), false, false, false, 0L, 0L, 60, null), e);
        }
        String it = request.getConnection().getHeaderField("Last-Modified");
        boolean bl = false;
        if (it != null) {
            this$0.lastModified.put($identifier, it);
        } else {
            this$0.lastModified.remove($identifier);
        }
        it = request.getConnection().getHeaderField("ETag");
        boolean bl2 = false;
        if (it != null) {
            this$0.eTags.put($identifier, it);
        } else {
            this$0.eTags.remove($identifier);
        }
        return newFile;
    }

    @JvmStatic
    @NotNull
    public static final UrlFileCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/downloads/UrlFileCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/downloads/UrlFileCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.common"})
    @SourceDebugExtension(value={"SMAP\nUrlFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlFileCache.kt\ncom/android/tools/idea/downloads/UrlFileCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,118:1\n30#2,2:119\n*S KotlinDebug\n*F\n+ 1 UrlFileCache.kt\ncom/android/tools/idea/downloads/UrlFileCache$Companion\n*L\n115#1:119,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UrlFileCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UrlFileCache> serviceClass$iv = UrlFileCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UrlFileCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/downloads/UrlFileCache$UrlWithHeaders;", "", "url", "", "headers", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getUrl", "()Ljava/lang/String;", "getHeaders", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.common"})
    public static final class UrlWithHeaders {
        @NotNull
        private final String url;
        @NotNull
        private final Map<String, String> headers;

        public UrlWithHeaders(@NotNull String url, @NotNull Map<String, String> headers) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            this.url = url;
            this.headers = headers;
        }

        public /* synthetic */ UrlWithHeaders(String string, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map2 = MapsKt.emptyMap();
            }
            this(string, map2);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.headers;
        }

        @NotNull
        public final UrlWithHeaders copy(@NotNull String url, @NotNull Map<String, String> headers) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            return new UrlWithHeaders(url, headers);
        }

        public static /* synthetic */ UrlWithHeaders copy$default(UrlWithHeaders urlWithHeaders, String string, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                string = urlWithHeaders.url;
            }
            if ((n & 2) != 0) {
                map2 = urlWithHeaders.headers;
            }
            return urlWithHeaders.copy(string, map2);
        }

        @NotNull
        public String toString() {
            return "UrlWithHeaders(url=" + this.url + ", headers=" + this.headers + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + ((Object)this.headers).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlWithHeaders)) {
                return false;
            }
            UrlWithHeaders urlWithHeaders = (UrlWithHeaders)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)urlWithHeaders.url)) {
                return false;
            }
            return Intrinsics.areEqual(this.headers, urlWithHeaders.headers);
        }
    }
}

