/*
 * Decompiled with CFR 0.152.
 */
package com.google.play.policy.insights;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0016H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/google/play/policy/insights/RequestInstallPackagesPolicyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "getApplicableMethodNames", "", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getApplicableConstructorTypes", "visitConstructor", "constructor", "Companion", "policyinsights"})
public final class RequestInstallPackagesPolicyDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> PERMISSIONS = CollectionsKt.listOf((Object)"android.permission.REQUEST_INSTALL_PACKAGES");
    @NotNull
    public static final String COMMIT = "commit";
    @NotNull
    public static final String PACKAGE_INSTALLER_SESSION = "android.content.pm.PackageInstaller.Session";
    @NotNull
    public static final String INTENT = "android.content.Intent";
    @NotNull
    public static final String STRING = "java.lang.String";
    @NotNull
    public static final String ACTION_INSTALL_PACKAGE = "android.intent.action.INSTALL_PACKAGE";
    @NotNull
    public static final String ID = "RequestInstallPackagesPolicy";
    @NotNull
    public static final String DESCRIPTION = "Request Install Packages Insights";
    @NotNull
    private static final String EXPLANATION = "`REQUEST_INSTALL_PACKAGES` permission allows apps to request the installation of other app \\\npackages. This permission is restricted to the app's core functionality, specifically when \\\nthe primary purpose directly involves sending, receiving, or enabling user-initiated \\\ninstallation of app packages. Using this permission to update your app, change its \\\nfunctionality or bundle other APKs for silent or unauthorized installation (except \\\nenterprise management) is prohibited. All installations must be a direct, active choice by \\\nthe user. Apps targeting Android 8+ must hold this permission in order to use \\\n`Intent.ACTION_INSTALL_PACKAGE.`\n\n**Dos:**\n\n- Clearly and prominently document the core functionality requiring this permission in your \\\napp\u2019s Play Store description and when you submit a declaration form in your Play Console.\n- Adhere strictly to the permitted functionalities including web browsing/search, file \\\nsharing/transfer/management, enterprise device management, backup/restore, device \\\nmigration/phone transfer, companion app to sync phone to wearable or IoT device.\n- Ensure your app prevents background or unintended installations. All app package \\\ninstallations must be explicitly initiated by the user.\n\n**Don'ts:**\n\n- Request this permission for a functionality that is not directly related to the primary \\\npurpose of your app. This includes Peer-to-Peer (P2P) sharing. P2P must be the primary \\\npurpose of the app in order to qualify as a permitted use.\n- Request this permission when the required task can be done with a less intrusive method.\n- Change how your app uses this permission without first revising your Play Console \\\ndeclaration with updated and accurate information. Deceptive and undeclared uses of this \\\npermission are prohibited.\n\n**Helpful Links:**\n\nSee Policy page: https://goo.gle/play-policy-request-install-packages\nSee developer guidance: https://goo.gle/dac-request-install-packages\nSee Declaration form:  https://goo.gle/play-permission-decl-form\n\nAlways review the full policy in the Policy Center to ensure compliance.";
    @NotNull
    public static final String URL = "https://support.google.com/googleplay/android-developer/answer/9888170?hl=en#:~:text=request%20install%20packages";
    @NotNull
    private static final String MESSAGE = "`REQUEST_INSTALL_PACKAGES` is restricted to specific core functionalities and must be \\\nuser-initiated. No self-updates, unauthorized installs, or APK bundling.";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        Attr attr = nameNode;
        if (CollectionsKt.contains((Iterable)PERMISSIONS, (Object)(attr != null ? attr.getValue() : null))) {
            Node node = element;
            Intrinsics.checkNotNull((Object)nameNode);
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getLocation((Node)nameNode), (String)MESSAGE, null, (int)16, null);
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)COMMIT);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, PACKAGE_INSTALLER_SESSION, false)) {
            return;
        }
        Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((UElement)node), (String)MESSAGE, null, (int)8, null);
    }

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)INTENT);
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        PsiParameter[] psiParameterArray = constructor.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] parameters = psiParameterArray;
        if (parameters.length == 0) {
            return;
        }
        if (!Intrinsics.areEqual((Object)parameters[0].getType().getCanonicalText(), (Object)STRING)) {
            return;
        }
        List args = node.getValueArguments();
        if (args.isEmpty()) {
            return;
        }
        if (Intrinsics.areEqual((Object)String.valueOf(ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)args.get(0)))), (Object)ACTION_INSTALL_PACKAGE)) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)args.get(0)), (Location)context.getLocation((UElement)args.get(0)), (String)MESSAGE, null, (int)16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        String string = EXPLANATION;
        Category category = Category.Companion.create("Play Policy", 84);
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        Implementation implementation = new Implementation(RequestInstallPackagesPolicyDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)ID, (String)DESCRIPTION, (String)string, (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/google/play/policy/insights/RequestInstallPackagesPolicyDetector$Companion;", "", "<init>", "()V", "PERMISSIONS", "", "", "getPERMISSIONS", "()Ljava/util/List;", "COMMIT", "PACKAGE_INSTALLER_SESSION", "INTENT", "STRING", "ACTION_INSTALL_PACKAGE", "ID", "DESCRIPTION", "EXPLANATION", "getEXPLANATION", "()Ljava/lang/String;", "URL", "MESSAGE", "getMESSAGE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "policyinsights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPERMISSIONS() {
            return PERMISSIONS;
        }

        @NotNull
        public final String getEXPLANATION() {
            return EXPLANATION;
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

