/*
 * Decompiled with CFR 0.152.
 */
package com.google.ux.material.libmonet.dynamiccolor;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.ux.material.libmonet.contrast.Contrast;
import com.google.ux.material.libmonet.dynamiccolor.ColorSpec;
import com.google.ux.material.libmonet.dynamiccolor.ColorSpecs;
import com.google.ux.material.libmonet.dynamiccolor.ContrastCurve;
import com.google.ux.material.libmonet.dynamiccolor.DynamicScheme;
import com.google.ux.material.libmonet.dynamiccolor.ToneDeltaPair;
import com.google.ux.material.libmonet.hct.Hct;
import com.google.ux.material.libmonet.palettes.TonalPalette;
import com.google.ux.material.libmonet.utils.MathUtils;
import java.util.HashMap;
import java.util.function.Function;

public class DynamicColor {
    public final String name;
    public final Function<DynamicScheme, TonalPalette> palette;
    public final Function<DynamicScheme, Double> tone;
    public final boolean isBackground;
    public final Function<DynamicScheme, Double> chromaMultiplier;
    public final Function<DynamicScheme, DynamicColor> background;
    public final Function<DynamicScheme, DynamicColor> secondBackground;
    public final Function<DynamicScheme, ContrastCurve> contrastCurve;
    public final Function<DynamicScheme, ToneDeltaPair> toneDeltaPair;
    public final Function<DynamicScheme, Double> opacity;
    private final HashMap<DynamicScheme, Hct> hctCache = new HashMap();

    public DynamicColor(@NonNull String name, @NonNull Function<DynamicScheme, TonalPalette> palette, @NonNull Function<DynamicScheme, Double> tone, boolean isBackground, @Nullable Function<DynamicScheme, DynamicColor> background, @Nullable Function<DynamicScheme, DynamicColor> secondBackground, @Nullable ContrastCurve contrastCurve, @Nullable Function<DynamicScheme, ToneDeltaPair> toneDeltaPair) {
        this(name, palette, tone, isBackground, background, secondBackground, contrastCurve, toneDeltaPair, null);
    }

    public DynamicColor(@NonNull String name, @NonNull Function<DynamicScheme, TonalPalette> palette, @NonNull Function<DynamicScheme, Double> tone, boolean isBackground, @Nullable Function<DynamicScheme, DynamicColor> background, @Nullable Function<DynamicScheme, DynamicColor> secondBackground, @Nullable ContrastCurve contrastCurve, @Nullable Function<DynamicScheme, ToneDeltaPair> toneDeltaPair, @Nullable Function<DynamicScheme, Double> opacity) {
        this(name, palette, tone, isBackground, null, background, secondBackground, s -> contrastCurve, toneDeltaPair, opacity);
    }

    public DynamicColor(@NonNull String name, @NonNull Function<DynamicScheme, TonalPalette> palette, @NonNull Function<DynamicScheme, Double> tone, boolean isBackground, @Nullable Function<DynamicScheme, Double> chromaMultiplier, @Nullable Function<DynamicScheme, DynamicColor> background, @Nullable Function<DynamicScheme, DynamicColor> secondBackground, @Nullable Function<DynamicScheme, ContrastCurve> contrastCurve, @Nullable Function<DynamicScheme, ToneDeltaPair> toneDeltaPair, @Nullable Function<DynamicScheme, Double> opacity) {
        this.name = name;
        this.palette = palette;
        this.tone = tone;
        this.isBackground = isBackground;
        this.chromaMultiplier = chromaMultiplier;
        this.background = background;
        this.secondBackground = secondBackground;
        this.contrastCurve = contrastCurve;
        this.toneDeltaPair = toneDeltaPair;
        this.opacity = opacity;
    }

    @NonNull
    public static DynamicColor fromPalette(@NonNull String name, @NonNull Function<DynamicScheme, TonalPalette> palette, @NonNull Function<DynamicScheme, Double> tone) {
        return new DynamicColor(name, palette, tone, false, null, null, null, null);
    }

    @NonNull
    public static DynamicColor fromPalette(@NonNull String name, @NonNull Function<DynamicScheme, TonalPalette> palette, @NonNull Function<DynamicScheme, Double> tone, boolean isBackground) {
        return new DynamicColor(name, palette, tone, isBackground, null, null, null, null);
    }

    @NonNull
    public static DynamicColor fromArgb(@NonNull String name, int argb) {
        Hct hct = Hct.fromInt(argb);
        TonalPalette palette = TonalPalette.fromInt(argb);
        return DynamicColor.fromPalette(name, s -> palette, s -> hct.getTone());
    }

    public int getArgb(@NonNull DynamicScheme scheme) {
        int argb = this.getHct(scheme).toInt();
        if (this.opacity == null || this.opacity.apply(scheme) == null) {
            return argb;
        }
        double percentage = this.opacity.apply(scheme);
        int alpha = MathUtils.clampInt(0, 255, (int)Math.round(percentage * 255.0));
        return argb & 0xFFFFFF | alpha << 24;
    }

    @NonNull
    public Hct getHct(@NonNull DynamicScheme scheme) {
        Hct cachedAnswer = this.hctCache.get(scheme);
        if (cachedAnswer != null) {
            return cachedAnswer;
        }
        Hct answer = ColorSpecs.get(scheme.specVersion).getHct(scheme, this);
        if (this.hctCache.size() > 4) {
            this.hctCache.clear();
        }
        this.hctCache.put(scheme, answer);
        return answer;
    }

    public double getTone(@NonNull DynamicScheme scheme) {
        return ColorSpecs.get(scheme.specVersion).getTone(scheme, this);
    }

    public static double foregroundTone(double bgTone, double ratio) {
        double lighterTone = Contrast.lighterUnsafe(bgTone, ratio);
        double darkerTone = Contrast.darkerUnsafe(bgTone, ratio);
        double lighterRatio = Contrast.ratioOfTones(lighterTone, bgTone);
        double darkerRatio = Contrast.ratioOfTones(darkerTone, bgTone);
        boolean preferLighter = DynamicColor.tonePrefersLightForeground(bgTone);
        if (preferLighter) {
            boolean negligibleDifference;
            boolean bl = negligibleDifference = Math.abs(lighterRatio - darkerRatio) < 0.1 && lighterRatio < ratio && darkerRatio < ratio;
            if (lighterRatio >= ratio || lighterRatio >= darkerRatio || negligibleDifference) {
                return lighterTone;
            }
            return darkerTone;
        }
        return darkerRatio >= ratio || darkerRatio >= lighterRatio ? darkerTone : lighterTone;
    }

    public static double enableLightForeground(double tone) {
        if (DynamicColor.tonePrefersLightForeground(tone) && !DynamicColor.toneAllowsLightForeground(tone)) {
            return 49.0;
        }
        return tone;
    }

    public static boolean tonePrefersLightForeground(double tone) {
        return Math.round(tone) < 60L;
    }

    public static boolean toneAllowsLightForeground(double tone) {
        return Math.round(tone) <= 49L;
    }

    public static Function<DynamicScheme, Double> getInitialToneFromBackground(@Nullable Function<DynamicScheme, DynamicColor> background) {
        if (background == null) {
            return s -> 50.0;
        }
        return s -> background.apply((DynamicScheme)s) != null ? ((DynamicColor)background.apply((DynamicScheme)s)).getTone((DynamicScheme)s) : 50.0;
    }

    public Builder toBuilder() {
        return new Builder().setName(this.name).setPalette(this.palette).setTone(this.tone).setIsBackground(this.isBackground).setChromaMultiplier(this.chromaMultiplier).setBackground(this.background).setSecondBackground(this.secondBackground).setContrastCurve(this.contrastCurve).setToneDeltaPair(this.toneDeltaPair).setOpacity(this.opacity);
    }

    public static class Builder {
        private String name;
        private Function<DynamicScheme, TonalPalette> palette;
        private Function<DynamicScheme, Double> tone;
        private boolean isBackground;
        private Function<DynamicScheme, Double> chromaMultiplier;
        private Function<DynamicScheme, DynamicColor> background;
        private Function<DynamicScheme, DynamicColor> secondBackground;
        private Function<DynamicScheme, ContrastCurve> contrastCurve;
        private Function<DynamicScheme, ToneDeltaPair> toneDeltaPair;
        private Function<DynamicScheme, Double> opacity;

        @CanIgnoreReturnValue
        public Builder setName(@NonNull String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPalette(@NonNull Function<DynamicScheme, TonalPalette> palette) {
            this.palette = palette;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTone(@NonNull Function<DynamicScheme, Double> tone) {
            this.tone = tone;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsBackground(boolean isBackground) {
            this.isBackground = isBackground;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setChromaMultiplier(@NonNull Function<DynamicScheme, Double> chromaMultiplier) {
            this.chromaMultiplier = chromaMultiplier;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBackground(@NonNull Function<DynamicScheme, DynamicColor> background) {
            this.background = background;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSecondBackground(@NonNull Function<DynamicScheme, DynamicColor> secondBackground) {
            this.secondBackground = secondBackground;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setContrastCurve(@NonNull Function<DynamicScheme, ContrastCurve> contrastCurve) {
            this.contrastCurve = contrastCurve;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setToneDeltaPair(@NonNull Function<DynamicScheme, ToneDeltaPair> toneDeltaPair) {
            this.toneDeltaPair = toneDeltaPair;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOpacity(@NonNull Function<DynamicScheme, Double> opacity) {
            this.opacity = opacity;
            return this;
        }

        @CanIgnoreReturnValue
        Builder extendSpecVersion(ColorSpec.SpecVersion specVersion, DynamicColor extendedColor) {
            this.validateExtendedColor(specVersion, extendedColor);
            return new Builder().setName(this.name).setIsBackground(this.isBackground).setPalette(s -> {
                Function<DynamicScheme, TonalPalette> palette = s.specVersion == specVersion ? extendedColor.palette : this.palette;
                return palette != null ? palette.apply((DynamicScheme)s) : null;
            }).setTone(s -> {
                Function<DynamicScheme, Double> tone = s.specVersion == specVersion ? extendedColor.tone : this.tone;
                return tone != null ? tone.apply((DynamicScheme)s) : null;
            }).setChromaMultiplier(s -> {
                Function<DynamicScheme, Double> chromaMultiplier = s.specVersion == specVersion ? extendedColor.chromaMultiplier : this.chromaMultiplier;
                return chromaMultiplier != null ? chromaMultiplier.apply((DynamicScheme)s) : 1.0;
            }).setBackground(s -> {
                Function<DynamicScheme, DynamicColor> background = s.specVersion == specVersion ? extendedColor.background : this.background;
                return background != null ? background.apply((DynamicScheme)s) : null;
            }).setSecondBackground(s -> {
                Function<DynamicScheme, DynamicColor> secondBackground = s.specVersion == specVersion ? extendedColor.secondBackground : this.secondBackground;
                return secondBackground != null ? secondBackground.apply((DynamicScheme)s) : null;
            }).setContrastCurve(s -> {
                Function<DynamicScheme, ContrastCurve> contrastCurve = s.specVersion == specVersion ? extendedColor.contrastCurve : this.contrastCurve;
                return contrastCurve != null ? contrastCurve.apply((DynamicScheme)s) : null;
            }).setToneDeltaPair(s -> {
                Function<DynamicScheme, ToneDeltaPair> toneDeltaPair = s.specVersion == specVersion ? extendedColor.toneDeltaPair : this.toneDeltaPair;
                return toneDeltaPair != null ? toneDeltaPair.apply((DynamicScheme)s) : null;
            }).setOpacity(s -> {
                Function<DynamicScheme, Double> opacity = s.specVersion == specVersion ? extendedColor.opacity : this.opacity;
                return opacity != null ? opacity.apply((DynamicScheme)s) : null;
            });
        }

        public DynamicColor build() {
            if (this.background == null && this.secondBackground != null) {
                throw new IllegalArgumentException("Color " + this.name + " has secondBackground defined, but background is not defined.");
            }
            if (this.background == null && this.contrastCurve != null) {
                throw new IllegalArgumentException("Color " + this.name + " has contrastCurve defined, but background is not defined.");
            }
            if (this.background != null && this.contrastCurve == null) {
                throw new IllegalArgumentException("Color " + this.name + " has background defined, but contrastCurve is not defined.");
            }
            return new DynamicColor(this.name, this.palette, this.tone == null ? DynamicColor.getInitialToneFromBackground(this.background) : this.tone, this.isBackground, this.chromaMultiplier, this.background, this.secondBackground, this.contrastCurve, this.toneDeltaPair, this.opacity);
        }

        private void validateExtendedColor(ColorSpec.SpecVersion specVersion, DynamicColor extendedColor) {
            if (!this.name.equals(extendedColor.name)) {
                throw new IllegalArgumentException("Attempting to extend color " + this.name + " with color " + extendedColor.name + " of different name for spec version " + (Object)((Object)specVersion) + ".");
            }
            if (this.isBackground != extendedColor.isBackground) {
                throw new IllegalArgumentException("Attempting to extend color " + this.name + " as a " + (this.isBackground ? "background" : "foreground") + " with color " + extendedColor.name + " as a " + (extendedColor.isBackground ? "background" : "foreground") + " for spec version " + (Object)((Object)specVersion) + ".");
            }
        }
    }
}

