/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import com.google.android.apps.common.testing.accessibility.framework.replacements.LayoutParams;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyAction;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementOrigin;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class ViewHierarchyElement {
    private static final String VIEW_FACTORY_HOLDER_CLASS_NAME = "com.android.layoutlib.androidx.compose.ui.viewinterop.ViewFactoryHolder";
    protected final int id;
    protected final @Nullable Integer parentId;
    protected @MonotonicNonNull List<Integer> childIds;
    private @MonotonicNonNull WindowHierarchyElement windowElement;
    protected final @Nullable CharSequence packageName;
    protected final @Nullable CharSequence className;
    protected final @Nullable CharSequence accessibilityClassName;
    private ViewHierarchyElementOrigin origin;
    protected final @Nullable String resourceName;
    protected final @Nullable CharSequence testTag;
    protected final @Nullable SpannableString contentDescription;
    protected final @Nullable SpannableString text;
    protected final @Nullable SpannableString stateDescription;
    protected final boolean importantForAccessibility;
    protected final @Nullable Boolean visibleToUser;
    protected final boolean clickable;
    protected final boolean longClickable;
    protected final boolean focusable;
    protected final @Nullable Boolean editable;
    protected final @Nullable Boolean scrollable;
    protected final @Nullable Boolean canScrollForward;
    protected final @Nullable Boolean canScrollBackward;
    protected final @Nullable Boolean checkable;
    protected final @Nullable Boolean checked;
    protected final @Nullable Boolean hasTouchDelegate;
    protected final boolean isScreenReaderFocusable;
    protected final @Nullable Rect boundsInScreen;
    protected final @Nullable Integer nonclippedHeight;
    protected final @Nullable Integer nonclippedWidth;
    protected final @Nullable Float textSize;
    protected final @Nullable Integer textSizeUnit;
    protected final @Nullable Integer textColor;
    protected final @Nullable Integer backgroundDrawableColor;
    protected final @Nullable Integer typefaceStyle;
    protected final boolean enabled;
    protected final @Nullable Integer drawingOrder;
    protected final ImmutableList<ViewHierarchyAction> actionList;
    protected final @Nullable LayoutParams layoutParams;
    protected final @Nullable SpannableString hintText;
    protected final @Nullable Integer hintTextColor;
    protected final ImmutableList<Rect> textCharacterLocations;
    protected @Nullable Long labeledById;
    protected @Nullable Long accessibilityTraversalBeforeId;
    protected @Nullable Long accessibilityTraversalAfterId;
    protected List<Rect> touchDelegateBounds;
    protected final List<Integer> superclassViews;

    protected ViewHierarchyElement(int id2, @Nullable Integer parentId, List<Integer> childIds, @Nullable CharSequence packageName, @Nullable CharSequence className, @Nullable CharSequence accessibilityClassName, ViewHierarchyElementOrigin origin, @Nullable String resourceName, @Nullable CharSequence testTag, @Nullable SpannableString contentDescription, @Nullable SpannableString text, @Nullable SpannableString stateDescription, boolean importantForAccessibility, @Nullable Boolean visibleToUser, boolean clickable, boolean longClickable, boolean focusable, @Nullable Boolean editable, @Nullable Boolean scrollable, @Nullable Boolean canScrollForward, @Nullable Boolean canScrollBackward, @Nullable Boolean checkable, @Nullable Boolean checked, @Nullable Boolean hasTouchDelegate, boolean isScreenReaderFocusable, List<Rect> touchDelegateBounds, @Nullable Rect boundsInScreen, @Nullable Integer nonclippedHeight, @Nullable Integer nonclippedWidth, @Nullable Float textSize, @Nullable Integer textSizeUnit, @Nullable Integer textColor, @Nullable Integer backgroundDrawableColor, @Nullable Integer typefaceStyle, boolean enabled, @Nullable Long labeledById, @Nullable Long accessibilityTraversalBeforeId, @Nullable Long accessibilityTraversalAfterId, @Nullable Integer drawingOrder, List<Integer> superclassViews, List<? extends ViewHierarchyAction> actionList, @Nullable LayoutParams layoutParams, @Nullable SpannableString hintText, @Nullable Integer hintTextColor, List<Rect> textCharacterLocations) {
        this.id = id2;
        this.parentId = parentId;
        if (!childIds.isEmpty()) {
            this.childIds = new ArrayList<Integer>(childIds.size());
            this.childIds.addAll(childIds);
        }
        this.packageName = packageName;
        this.className = className;
        this.accessibilityClassName = accessibilityClassName;
        this.origin = origin;
        this.resourceName = resourceName;
        this.testTag = testTag;
        this.contentDescription = contentDescription;
        this.text = text;
        this.stateDescription = stateDescription;
        this.importantForAccessibility = importantForAccessibility;
        this.visibleToUser = visibleToUser;
        this.clickable = clickable;
        this.longClickable = longClickable;
        this.focusable = focusable;
        this.editable = editable;
        this.scrollable = scrollable;
        this.canScrollForward = canScrollForward;
        this.canScrollBackward = canScrollBackward;
        this.checkable = checkable;
        this.checked = checked;
        this.hasTouchDelegate = hasTouchDelegate;
        this.isScreenReaderFocusable = isScreenReaderFocusable;
        this.touchDelegateBounds = touchDelegateBounds;
        this.boundsInScreen = boundsInScreen;
        this.nonclippedHeight = nonclippedHeight;
        this.nonclippedWidth = nonclippedWidth;
        this.textSize = textSize;
        this.textSizeUnit = textSizeUnit;
        this.textColor = textColor;
        this.backgroundDrawableColor = backgroundDrawableColor;
        this.typefaceStyle = typefaceStyle;
        this.enabled = enabled;
        this.labeledById = labeledById;
        this.accessibilityTraversalBeforeId = accessibilityTraversalBeforeId;
        this.accessibilityTraversalAfterId = accessibilityTraversalAfterId;
        this.drawingOrder = drawingOrder;
        this.superclassViews = superclassViews;
        this.actionList = actionList != null && !actionList.isEmpty() ? ImmutableList.copyOf(actionList) : ImmutableList.of();
        this.layoutParams = layoutParams;
        this.hintText = hintText;
        this.hintTextColor = hintTextColor;
        this.textCharacterLocations = ImmutableList.copyOf(textCharacterLocations);
    }

    ViewHierarchyElement(AccessibilityHierarchyProtos.ViewHierarchyElementProto proto) {
        Preconditions.checkNotNull((Object)proto);
        this.id = proto.getId();
        Integer n = this.parentId = proto.getParentId() != -1 ? Integer.valueOf(proto.getParentId()) : null;
        if (proto.getChildIdsCount() > 0) {
            this.childIds = new ArrayList<Integer>(proto.getChildIdsCount());
            this.childIds.addAll(proto.getChildIdsList());
        }
        this.packageName = proto.hasPackageName() ? proto.getPackageName() : null;
        this.className = proto.hasClassName() ? proto.getClassName() : null;
        this.accessibilityClassName = proto.hasAccessibilityClassName() ? proto.getAccessibilityClassName() : null;
        this.resourceName = proto.hasResourceName() ? proto.getResourceName() : null;
        this.testTag = proto.hasTestTag() ? proto.getTestTag() : null;
        this.contentDescription = proto.hasContentDescription() ? new SpannableString(proto.getContentDescription()) : null;
        this.text = proto.hasText() ? new SpannableString(proto.getText()) : null;
        this.stateDescription = proto.hasStateDescription() ? new SpannableString(proto.getStateDescription()) : null;
        this.importantForAccessibility = proto.getImportantForAccessibility();
        this.visibleToUser = proto.hasVisibleToUser() ? Boolean.valueOf(proto.getVisibleToUser()) : null;
        this.clickable = proto.getClickable();
        this.longClickable = proto.getLongClickable();
        this.focusable = proto.getFocusable();
        this.editable = proto.hasEditable() ? Boolean.valueOf(proto.getEditable()) : null;
        this.scrollable = proto.hasScrollable() ? Boolean.valueOf(proto.getScrollable()) : null;
        this.canScrollForward = proto.hasCanScrollForward() ? Boolean.valueOf(proto.getCanScrollForward()) : null;
        this.canScrollBackward = proto.hasCanScrollBackward() ? Boolean.valueOf(proto.getCanScrollBackward()) : null;
        this.checkable = proto.hasCheckable() ? Boolean.valueOf(proto.getCheckable()) : null;
        this.checked = proto.hasChecked() ? Boolean.valueOf(proto.getChecked()) : null;
        this.hasTouchDelegate = proto.hasHasTouchDelegate() ? Boolean.valueOf(proto.getHasTouchDelegate()) : null;
        this.isScreenReaderFocusable = proto.getScreenReaderFocusable();
        if (proto.getTouchDelegateBoundsCount() > 0) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < proto.getTouchDelegateBoundsCount(); ++i) {
                builder.add((Object)new Rect(proto.getTouchDelegateBounds(i)));
            }
            this.touchDelegateBounds = builder.build();
        } else {
            this.touchDelegateBounds = ImmutableList.of();
        }
        this.boundsInScreen = proto.hasBoundsInScreen() ? new Rect(proto.getBoundsInScreen()) : null;
        this.nonclippedHeight = proto.hasNonclippedHeight() ? Integer.valueOf(proto.getNonclippedHeight()) : null;
        this.nonclippedWidth = proto.hasNonclippedWidth() ? Integer.valueOf(proto.getNonclippedWidth()) : null;
        this.textSize = proto.hasTextSize() ? Float.valueOf(proto.getTextSize()) : null;
        this.textSizeUnit = proto.hasTextSizeUnit() ? Integer.valueOf(proto.getTextSizeUnit()) : null;
        this.textColor = proto.hasTextColor() ? Integer.valueOf(proto.getTextColor()) : null;
        this.backgroundDrawableColor = proto.hasBackgroundDrawableColor() ? Integer.valueOf(proto.getBackgroundDrawableColor()) : null;
        this.typefaceStyle = proto.hasTypefaceStyle() ? Integer.valueOf(proto.getTypefaceStyle()) : null;
        this.enabled = proto.getEnabled();
        this.labeledById = proto.hasLabeledById() ? Long.valueOf(proto.getLabeledById()) : null;
        this.accessibilityTraversalBeforeId = proto.hasAccessibilityTraversalBeforeId() ? Long.valueOf(proto.getAccessibilityTraversalBeforeId()) : null;
        this.accessibilityTraversalAfterId = proto.hasAccessibilityTraversalAfterId() ? Long.valueOf(proto.getAccessibilityTraversalAfterId()) : null;
        this.superclassViews = proto.getSuperclassesList();
        this.drawingOrder = proto.hasDrawingOrder() ? Integer.valueOf(proto.getDrawingOrder()) : null;
        ImmutableList.Builder actionBuilder = new ImmutableList.Builder();
        for (AccessibilityHierarchyProtos.ViewHierarchyActionProto actionProto : proto.getActionsList()) {
            actionBuilder.add((Object)new ViewHierarchyAction(actionProto));
        }
        this.actionList = actionBuilder.build();
        this.layoutParams = proto.hasLayoutParams() ? new LayoutParams(proto.getLayoutParams()) : null;
        this.hintText = proto.hasHintText() ? new SpannableString(proto.getHintText()) : null;
        this.hintTextColor = proto.hasHintTextColor() ? Integer.valueOf(proto.getHintTextColor()) : null;
        ImmutableList.Builder characterLocations = ImmutableList.builder();
        if (proto.getTextCharacterLocationsCount() > 0) {
            for (int i = 0; i < proto.getTextCharacterLocationsCount(); ++i) {
                characterLocations.add((Object)new Rect(proto.getTextCharacterLocations(i)));
            }
        }
        this.textCharacterLocations = characterLocations.build();
        this.origin = ViewHierarchyElementOrigin.UNKNOWN;
    }

    @Pure
    public int getId() {
        return this.id;
    }

    public long getCondensedUniqueId() {
        return (long)this.getWindow().getId() << 32 | (long)this.getId();
    }

    @Pure
    public @Nullable ViewHierarchyElement getParentView() {
        Integer parentIdtmp = this.parentId;
        return parentIdtmp != null ? this.getWindow().getViewById(parentIdtmp) : null;
    }

    public int getChildViewCount() {
        return this.childIds == null ? 0 : this.childIds.size();
    }

    public ViewHierarchyElement getChildView(int atIndex) {
        if (atIndex < 0 || this.childIds == null || atIndex >= this.childIds.size()) {
            throw new NoSuchElementException();
        }
        return this.getWindow().getViewById(this.childIds.get(atIndex));
    }

    public List<? extends ViewHierarchyElement> getSelfAndAllDescendants() {
        ArrayList<? extends ViewHierarchyElement> listToPopulate = new ArrayList<ViewHierarchyElement>();
        listToPopulate.add(this);
        for (int i = 0; i < this.getChildViewCount(); ++i) {
            listToPopulate.addAll(this.getChildView(i).getSelfAndAllDescendants());
        }
        return Collections.unmodifiableList(listToPopulate);
    }

    public WindowHierarchyElement getWindow() {
        return (WindowHierarchyElement)Preconditions.checkNotNull((Object)this.windowElement);
    }

    public @Nullable CharSequence getPackageName() {
        return this.packageName;
    }

    public @Nullable CharSequence getClassName() {
        return this.className;
    }

    @Pure
    public @Nullable String getResourceName() {
        return this.resourceName;
    }

    @Pure
    public @Nullable CharSequence getTestTag() {
        return this.testTag;
    }

    public boolean checkInstanceOf(String referenceClassName) {
        AccessibilityHierarchy hierarchy = this.getWindow().getAccessibilityHierarchy();
        Integer id2 = hierarchy.getViewElementClassNames().getIdentifierForClassName(referenceClassName);
        if (id2 == null) {
            return false;
        }
        return this.superclassViews.contains(id2);
    }

    public boolean checkInstanceOfAny(List<String> referenceClassNameList) {
        for (String referenceClassName : referenceClassNameList) {
            if (!this.checkInstanceOf(referenceClassName)) continue;
            return true;
        }
        return false;
    }

    public @Nullable SpannableString getContentDescription() {
        return this.contentDescription;
    }

    @Pure
    public boolean isImportantForAccessibility() {
        return this.importantForAccessibility;
    }

    public @Nullable SpannableString getText() {
        return this.text;
    }

    @Pure
    public @Nullable SpannableString getStateDescription() {
        return this.stateDescription;
    }

    @Pure
    public @Nullable Boolean isVisibleToUser() {
        return this.visibleToUser;
    }

    @Pure
    public boolean isClickable() {
        return this.clickable;
    }

    @Pure
    public boolean isLongClickable() {
        return this.longClickable;
    }

    @Pure
    public boolean isFocusable() {
        return this.focusable;
    }

    @Pure
    public @Nullable Boolean isEditable() {
        return this.editable;
    }

    @Pure
    public @Nullable Boolean isScrollable() {
        return this.scrollable;
    }

    @Pure
    public @Nullable Boolean canScrollForward() {
        return this.canScrollForward;
    }

    @Pure
    public @Nullable Boolean canScrollBackward() {
        return this.canScrollBackward;
    }

    @Pure
    public @Nullable Boolean isCheckable() {
        return this.checkable;
    }

    @Pure
    public @Nullable Boolean isChecked() {
        return this.checked;
    }

    @Pure
    public @Nullable Boolean hasTouchDelegate() {
        return this.hasTouchDelegate;
    }

    @Pure
    public boolean isScreenReaderFocusable() {
        return this.isScreenReaderFocusable;
    }

    public List<Rect> getTouchDelegateBounds() {
        return this.touchDelegateBounds;
    }

    @Pure
    public List<Rect> getTextCharacterLocations() {
        return this.textCharacterLocations;
    }

    @Pure
    public Rect getBoundsInScreen() {
        return this.boundsInScreen != null ? this.boundsInScreen : Rect.EMPTY;
    }

    @Pure
    public @Nullable Integer getNonclippedHeight() {
        return this.nonclippedHeight;
    }

    @Pure
    public @Nullable Integer getNonclippedWidth() {
        return this.nonclippedWidth;
    }

    @Pure
    public @Nullable Float getTextSize() {
        return this.textSize;
    }

    @Pure
    public @Nullable Integer getTextSizeUnit() {
        return this.textSizeUnit;
    }

    @Pure
    public @Nullable Integer getTextColor() {
        return this.textColor;
    }

    @Pure
    public @Nullable Integer getBackgroundDrawableColor() {
        return this.backgroundDrawableColor;
    }

    @Pure
    public @Nullable Integer getTypefaceStyle() {
        return this.typefaceStyle;
    }

    @Pure
    public boolean isEnabled() {
        return this.enabled;
    }

    @Pure
    public @Nullable CharSequence getAccessibilityClassName() {
        return this.accessibilityClassName;
    }

    public ViewHierarchyElementOrigin getOrigin() {
        return this.origin;
    }

    void computeAndSetOrigin() {
        this.origin = ViewHierarchyElement.computeOrigin(this.getClassName(), this.getParentView());
    }

    public @Nullable ViewHierarchyElement getLabeledBy() {
        return this.getViewHierarchyElementById(this.labeledById);
    }

    public @Nullable ViewHierarchyElement getAccessibilityTraversalBefore() {
        return this.getViewHierarchyElementById(this.accessibilityTraversalBeforeId);
    }

    public @Nullable ViewHierarchyElement getAccessibilityTraversalAfter() {
        return this.getViewHierarchyElementById(this.accessibilityTraversalAfterId);
    }

    @Pure
    public @Nullable Integer getDrawingOrder() {
        return this.drawingOrder;
    }

    @Pure
    public @Nullable LayoutParams getLayoutParams() {
        return this.layoutParams;
    }

    @Pure
    public @Nullable SpannableString getHintText() {
        return this.hintText;
    }

    @Pure
    public @Nullable Integer getHintTextColor() {
        return this.hintTextColor;
    }

    public boolean isAgainstScrollableEdge() {
        return Boolean.TRUE.equals(this.isVisibleToUser()) && this.isAgaistScrollableEdgeOfAncestor(this);
    }

    private boolean isAgaistScrollableEdgeOfAncestor(ViewHierarchyElement view) {
        Rect descendantBounds;
        Rect scrollableBounds;
        ViewHierarchyElement ancestor = view.getParentView();
        if (ancestor == null) {
            return false;
        }
        if (Boolean.TRUE.equals(ancestor.canScrollBackward())) {
            scrollableBounds = ancestor.getBoundsInScreen();
            descendantBounds = this.getBoundsInScreen();
            if (descendantBounds.getTop() <= scrollableBounds.getTop() || descendantBounds.getLeft() <= scrollableBounds.getLeft()) {
                return true;
            }
        }
        if (Boolean.TRUE.equals(ancestor.canScrollForward())) {
            scrollableBounds = ancestor.getBoundsInScreen();
            descendantBounds = this.getBoundsInScreen();
            if (descendantBounds.getBottom() >= scrollableBounds.getBottom() || descendantBounds.getRight() >= scrollableBounds.getRight()) {
                return true;
            }
        }
        return this.isAgaistScrollableEdgeOfAncestor(ancestor);
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ViewHierarchyElement)) {
            return false;
        }
        ViewHierarchyElement element = (ViewHierarchyElement)object;
        if (!this.propertiesEquals((ViewHierarchyElement)object)) {
            return false;
        }
        for (int i = 0; i < this.getChildViewCount(); ++i) {
            if (this.getChildView(i).equals(element.getChildView(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ViewHierarchyElement");
        if (!TextUtils.isEmpty(this.className)) {
            sb.append(" class=").append(this.className);
        }
        if (!TextUtils.isEmpty(this.resourceName)) {
            sb.append(" resource=").append(this.resourceName);
        }
        if (!TextUtils.isEmpty(this.testTag)) {
            sb.append(" testTag=").append(this.testTag);
        }
        if (!TextUtils.isEmpty(this.text)) {
            sb.append(" text=").append(this.text);
        }
        if (this.boundsInScreen != null) {
            sb.append(" bounds=").append(this.boundsInScreen);
        }
        return sb.append("]").toString();
    }

    List<Integer> getSuperclassList() {
        return this.superclassViews;
    }

    void addIdToSuperclassViewList(int id2) {
        this.superclassViews.add(id2);
    }

    @Pure
    ImmutableList<ViewHierarchyAction> getActionList() {
        return this.actionList;
    }

    AccessibilityHierarchyProtos.ViewHierarchyElementProto toProto() {
        AccessibilityHierarchyProtos.ViewHierarchyElementProto.Builder builder = AccessibilityHierarchyProtos.ViewHierarchyElementProto.newBuilder();
        builder.setId(this.id);
        if (this.parentId != null) {
            builder.setParentId(this.parentId);
        }
        if (this.childIds != null && !this.childIds.isEmpty()) {
            builder.addAllChildIds(this.childIds);
        }
        if (!TextUtils.isEmpty(this.packageName)) {
            builder.setPackageName(this.packageName.toString());
        }
        if (!TextUtils.isEmpty(this.className)) {
            builder.setClassName(this.className.toString());
        }
        if (!TextUtils.isEmpty(this.resourceName)) {
            builder.setResourceName(this.resourceName);
        }
        if (!TextUtils.isEmpty(this.testTag)) {
            builder.setTestTag(this.testTag.toString());
        }
        if (!TextUtils.isEmpty(this.contentDescription)) {
            builder.setContentDescription(this.contentDescription.toProto());
        }
        if (!TextUtils.isEmpty(this.text)) {
            builder.setText(this.text.toProto());
        }
        if (!TextUtils.isEmpty(this.stateDescription)) {
            builder.setStateDescription(this.stateDescription.toProto());
        }
        builder.setImportantForAccessibility(this.importantForAccessibility);
        if (this.visibleToUser != null) {
            builder.setVisibleToUser(this.visibleToUser);
        }
        builder.setClickable(this.clickable).setLongClickable(this.longClickable).setFocusable(this.focusable);
        if (this.editable != null) {
            builder.setEditable(this.editable);
        }
        if (this.scrollable != null) {
            builder.setScrollable(this.scrollable);
        }
        if (this.canScrollForward != null) {
            builder.setCanScrollForward(this.canScrollForward);
        }
        if (this.canScrollBackward != null) {
            builder.setCanScrollBackward(this.canScrollBackward);
        }
        if (this.checkable != null) {
            builder.setCheckable(this.checkable);
        }
        if (this.checked != null) {
            builder.setChecked(this.checked);
        }
        if (this.hasTouchDelegate != null) {
            builder.setHasTouchDelegate(this.hasTouchDelegate);
        }
        builder.setScreenReaderFocusable(this.isScreenReaderFocusable);
        for (Rect bounds : this.touchDelegateBounds) {
            builder.addTouchDelegateBounds(bounds.toProto());
        }
        if (this.boundsInScreen != null) {
            builder.setBoundsInScreen(this.boundsInScreen.toProto());
        }
        if (this.nonclippedHeight != null) {
            builder.setNonclippedHeight(this.nonclippedHeight);
        }
        if (this.nonclippedWidth != null) {
            builder.setNonclippedWidth(this.nonclippedWidth);
        }
        if (this.textSize != null) {
            builder.setTextSize(this.textSize.floatValue());
        }
        if (this.textSizeUnit != null) {
            builder.setTextSizeUnit(this.textSizeUnit);
        }
        if (this.textColor != null) {
            builder.setTextColor(this.textColor);
        }
        if (this.backgroundDrawableColor != null) {
            builder.setBackgroundDrawableColor(this.backgroundDrawableColor);
        }
        if (this.typefaceStyle != null) {
            builder.setTypefaceStyle(this.typefaceStyle);
        }
        builder.setEnabled(this.enabled);
        if (this.labeledById != null) {
            builder.setLabeledById(this.labeledById);
        }
        if (this.accessibilityClassName != null) {
            builder.setAccessibilityClassName(this.accessibilityClassName.toString());
        }
        if (this.accessibilityTraversalBeforeId != null) {
            builder.setAccessibilityTraversalBeforeId(this.accessibilityTraversalBeforeId);
        }
        if (this.accessibilityTraversalAfterId != null) {
            builder.setAccessibilityTraversalAfterId(this.accessibilityTraversalAfterId);
        }
        if (this.drawingOrder != null) {
            builder.setDrawingOrder(this.drawingOrder);
        }
        if (this.layoutParams != null) {
            builder.setLayoutParams(this.layoutParams.toProto());
        }
        if (!TextUtils.isEmpty(this.hintText)) {
            builder.setHintText(this.hintText.toProto());
        }
        if (this.hintTextColor != null) {
            builder.setHintTextColor(this.hintTextColor);
        }
        builder.addAllSuperclasses(this.superclassViews);
        for (ViewHierarchyAction action : this.actionList) {
            builder.addActions(action.toProto());
        }
        for (Rect rect : this.textCharacterLocations) {
            builder.addTextCharacterLocations(rect.toProto());
        }
        return (AccessibilityHierarchyProtos.ViewHierarchyElementProto)builder.build();
    }

    void setWindow(WindowHierarchyElement window) {
        this.windowElement = window;
    }

    void addChild(ViewHierarchyElement child) {
        if (this.childIds == null) {
            this.childIds = new ArrayList<Integer>();
        }
        this.childIds.add(child.id);
    }

    void setLabeledBy(ViewHierarchyElement labelingElement) {
        this.labeledById = labelingElement != null ? Long.valueOf(labelingElement.getCondensedUniqueId()) : null;
    }

    void setAccessibilityTraversalBefore(ViewHierarchyElement element) {
        this.accessibilityTraversalBeforeId = element.getCondensedUniqueId();
    }

    void setAccessibilityTraversalAfter(ViewHierarchyElement element) {
        this.accessibilityTraversalAfterId = element.getCondensedUniqueId();
    }

    void addTouchDelegateBounds(Rect bounds) {
        this.touchDelegateBounds.add(bounds);
    }

    private @Nullable ViewHierarchyElement getViewHierarchyElementById(@Nullable Long id2) {
        return id2 != null ? this.getWindow().getAccessibilityHierarchy().getViewById(id2) : null;
    }

    protected static ViewHierarchyElementOrigin computeOrigin(@Nullable CharSequence className, @Nullable ViewHierarchyElement parent) {
        if (parent == null || TextUtils.equals(className, VIEW_FACTORY_HOLDER_CLASS_NAME)) {
            return ViewHierarchyElementOrigin.VIEW;
        }
        CharSequence parentClassName = parent.getClassName();
        if (TextUtils.equals(parentClassName, "com.android.layoutlib.androidx.compose.ui.platform.AndroidComposeView")) {
            return ViewHierarchyElementOrigin.COMPOSE;
        }
        if (TextUtils.equals(parentClassName, "io.flutter.embedding.android.FlutterView")) {
            return ViewHierarchyElementOrigin.FLUTTER;
        }
        if (TextUtils.equals(parentClassName, "android.webkit.WebView")) {
            return ViewHierarchyElementOrigin.WEB;
        }
        return parent.getOrigin();
    }

    private boolean propertiesEquals(ViewHierarchyElement element) {
        return this.getCondensedUniqueId() == element.getCondensedUniqueId() && this.getChildViewCount() == element.getChildViewCount() && TextUtils.equals(this.getPackageName(), element.getPackageName()) && TextUtils.equals(this.getClassName(), element.getClassName()) && TextUtils.equals(this.getResourceName(), element.getResourceName()) && TextUtils.equals(this.getTestTag(), element.getTestTag()) && this.isImportantForAccessibility() == element.isImportantForAccessibility() && TextUtils.equals(this.getContentDescription(), element.getContentDescription()) && TextUtils.equals(this.getText(), element.getText()) && TextUtils.equals(this.getStateDescription(), element.getStateDescription()) && Objects.equals(this.getTextColor(), element.getTextColor()) && Objects.equals(this.getBackgroundDrawableColor(), element.getBackgroundDrawableColor()) && Objects.equals(this.isVisibleToUser(), element.isVisibleToUser()) && this.isClickable() == element.isClickable() && this.isLongClickable() == element.isLongClickable() && this.isFocusable() == element.isFocusable() && Objects.equals(this.isEditable(), element.isEditable()) && Objects.equals(this.isScrollable(), element.isScrollable()) && Objects.equals(this.canScrollForward(), element.canScrollForward()) && Objects.equals(this.canScrollBackward(), element.canScrollBackward()) && Objects.equals(this.isCheckable(), element.isCheckable()) && Objects.equals(this.isChecked(), element.isChecked()) && Objects.equals(this.hasTouchDelegate(), element.hasTouchDelegate()) && this.isScreenReaderFocusable() == element.isScreenReaderFocusable() && Objects.equals(this.getTouchDelegateBounds(), element.getTouchDelegateBounds()) && Objects.equals(this.getBoundsInScreen(), element.getBoundsInScreen()) && Objects.equals(this.getNonclippedWidth(), element.getNonclippedWidth()) && Objects.equals(this.getNonclippedHeight(), element.getNonclippedHeight()) && Objects.equals(this.getTextSize(), element.getTextSize()) && Objects.equals(this.getTextSizeUnit(), element.getTextSizeUnit()) && Objects.equals(this.getTypefaceStyle(), element.getTypefaceStyle()) && this.isEnabled() == element.isEnabled() && ViewHierarchyElement.condensedUniqueIdEquals(this.getLabeledBy(), element.getLabeledBy()) && TextUtils.equals(this.getAccessibilityClassName(), element.getAccessibilityClassName()) && ViewHierarchyElement.condensedUniqueIdEquals(this.getAccessibilityTraversalAfter(), element.getAccessibilityTraversalAfter()) && ViewHierarchyElement.condensedUniqueIdEquals(this.getAccessibilityTraversalBefore(), element.getAccessibilityTraversalBefore()) && Objects.equals(this.getDrawingOrder(), element.getDrawingOrder()) && Objects.equals(this.getLayoutParams(), element.getLayoutParams()) && TextUtils.equals(this.getHintText(), element.getHintText()) && Objects.equals(this.getHintTextColor(), element.getHintTextColor()) && Objects.equals(this.getTextCharacterLocations(), element.getTextCharacterLocations());
    }

    private static boolean condensedUniqueIdEquals(@Nullable ViewHierarchyElement ve1, @Nullable ViewHierarchyElement ve2) {
        return ve1 == null ? ve2 == null : ve2 != null && ve1.getCondensedUniqueId() == ve2.getCondensedUniqueId();
    }
}

