/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.os._Original_Build;
import android.util.DisplayMetrics;
import android.view.Display;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DisplayInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.errorprone.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public class DisplayInfoAndroid
extends DisplayInfo {
    private final MetricsAndroid metricsWithoutDecoration;
    private final @Nullable MetricsAndroid realMetrics;

    public DisplayInfoAndroid(Display display) {
        DisplayMetrics tempMetrics = new DisplayMetrics();
        display.getMetrics(tempMetrics);
        this.metricsWithoutDecoration = new MetricsAndroid(tempMetrics);
        tempMetrics.setToDefaults();
        if (_Original_Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(tempMetrics);
            this.realMetrics = new MetricsAndroid(tempMetrics);
        } else {
            this.realMetrics = null;
        }
    }

    DisplayInfoAndroid(AccessibilityHierarchyProtos.DisplayInfoProto fromProto) {
        this.metricsWithoutDecoration = new MetricsAndroid(fromProto.getMetricsWithoutDecoration());
        this.realMetrics = fromProto.hasRealMetrics() ? new MetricsAndroid(fromProto.getRealMetrics()) : null;
    }

    @Override
    public MetricsAndroid getMetricsWithoutDecoration() {
        return this.metricsWithoutDecoration;
    }

    @Override
    public @Nullable MetricsAndroid getRealMetrics() {
        return this.realMetrics;
    }

    @Override
    AccessibilityHierarchyProtos.DisplayInfoProto toProto() {
        AccessibilityHierarchyProtos.DisplayInfoProto.Builder builder = AccessibilityHierarchyProtos.DisplayInfoProto.newBuilder();
        builder.setMetricsWithoutDecoration(this.metricsWithoutDecoration.toProto());
        if (this.realMetrics != null) {
            builder.setRealMetrics(this.realMetrics.toProto());
        }
        return (AccessibilityHierarchyProtos.DisplayInfoProto)builder.build();
    }

    @Immutable
    public static class MetricsAndroid
    extends DisplayInfo.Metrics {
        public MetricsAndroid(DisplayMetrics metrics) {
            super(metrics.density, metrics.scaledDensity, metrics.xdpi, metrics.ydpi, metrics.densityDpi, metrics.heightPixels, metrics.widthPixels);
        }

        MetricsAndroid(AccessibilityHierarchyProtos.DisplayInfoMetricsProto fromProto) {
            super(fromProto);
        }
    }
}

