/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.android.layoutlib.hamcrest.Description;
import com.android.layoutlib.hamcrest.Matcher;
import com.android.layoutlib.hamcrest.TypeSafeMatcher;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessibilityCheckResultBaseUtils {
    private AccessibilityCheckResultBaseUtils() {
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForCheck(Iterable<T> results, Class<? extends AccessibilityCheck> checkClass) {
        ArrayList<AccessibilityCheckResult> resultsForCheck = new ArrayList<AccessibilityCheckResult>();
        for (AccessibilityCheckResult result : results) {
            Class<? extends AccessibilityCheck> resultCheckClass = result.getSourceCheckClass();
            if (!checkClass.equals(resultCheckClass)) continue;
            resultsForCheck.add(result);
        }
        return resultsForCheck;
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForType(Iterable<T> results, AccessibilityCheckResult.AccessibilityCheckResultType type) {
        ArrayList<AccessibilityCheckResult> resultsForType = new ArrayList<AccessibilityCheckResult>();
        for (AccessibilityCheckResult result : results) {
            if (result.getType() != type) continue;
            resultsForType.add(result);
        }
        return resultsForType;
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForTypes(Iterable<T> results, Set<AccessibilityCheckResult.AccessibilityCheckResultType> types) {
        ArrayList<AccessibilityCheckResult> resultsForTypes = new ArrayList<AccessibilityCheckResult>();
        for (AccessibilityCheckResult result : results) {
            if (!types.contains((Object)result.getType())) continue;
            resultsForTypes.add(result);
        }
        return resultsForTypes;
    }

    public static Matcher<AccessibilityCheckResult> matchesTypes(final Matcher<? super AccessibilityCheckResult.AccessibilityCheckResultType> typeMatcher) {
        return new TypeSafeMemberMatcher<AccessibilityCheckResult>("result type", typeMatcher){

            @Override
            public boolean matchesSafely(AccessibilityCheckResult result) {
                return typeMatcher.matches((Object)result.getType());
            }
        };
    }

    public static Matcher<AccessibilityCheckResult> matchesChecks(final Matcher<?> classMatcher) {
        return new TypeSafeMemberMatcher<AccessibilityCheckResult>("source check", classMatcher){

            @Override
            public boolean matchesSafely(AccessibilityCheckResult result) {
                return classMatcher.matches(result.getSourceCheckClass());
            }
        };
    }

    public static Matcher<AccessibilityCheckResult> matchesCheckNames(Matcher<? super String> classNameMatcher) {
        return AccessibilityCheckResultBaseUtils.matchesCheckNames(classNameMatcher, null);
    }

    static Matcher<AccessibilityCheckResult> matchesCheckNames(final Matcher<? super String> classNameMatcher, final @Nullable ImmutableBiMap<String, Class<?>> aliases) {
        return new TypeSafeMemberMatcher<AccessibilityCheckResult>("source check name", classNameMatcher){

            @Override
            public boolean matchesSafely(AccessibilityCheckResult result) {
                Class<? extends AccessibilityCheck> checkClass = result.getSourceCheckClass();
                if (classNameMatcher.matches(checkClass.getSimpleName())) {
                    return true;
                }
                String obsoleteName = AccessibilityCheckResultBaseUtils.getObsoleteName(checkClass, aliases);
                return obsoleteName != null && classNameMatcher.matches(obsoleteName);
            }
        };
    }

    private static @Nullable String getObsoleteName(Class<?> checkClass, @Nullable ImmutableBiMap<String, Class<?>> aliases) {
        return aliases != null ? (String)aliases.inverse().get(checkClass) : null;
    }

    static abstract class TypeSafeMemberMatcher<T>
    extends TypeSafeMatcher<T> {
        private final String memberDescription;
        private final Matcher<?> matcher;

        public TypeSafeMemberMatcher(String member, Matcher<?> matcher) {
            this.memberDescription = String.format("with %s: ", member);
            this.matcher = matcher;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText(this.memberDescription);
            this.matcher.describeTo(description);
        }
    }
}

