/*
 * Decompiled with CFR 0.152.
 */
package com.android.ondevicepersonalization.internal.util.build;

import android.os._Original_Build;
import com.android.layoutlib.androidx.annotation.ChecksSdkIntAtLeast;
import com.android.layoutlib.androidx.annotation.NonNull;

public class SdkLevel {
    private SdkLevel() {
    }

    @ChecksSdkIntAtLeast(api=30)
    public static boolean isAtLeastR() {
        return _Original_Build.VERSION.SDK_INT >= 30;
    }

    @ChecksSdkIntAtLeast(api=31)
    public static boolean isAtLeastS() {
        return _Original_Build.VERSION.SDK_INT >= 31;
    }

    @ChecksSdkIntAtLeast(api=32)
    public static boolean isAtLeastSv2() {
        return _Original_Build.VERSION.SDK_INT >= 32;
    }

    @ChecksSdkIntAtLeast(api=33)
    public static boolean isAtLeastT() {
        return _Original_Build.VERSION.SDK_INT >= 33;
    }

    @ChecksSdkIntAtLeast(api=34, codename="UpsideDownCake")
    public static boolean isAtLeastU() {
        return _Original_Build.VERSION.SDK_INT >= 34 || _Original_Build.VERSION.SDK_INT == 33 && SdkLevel.isAtLeastPreReleaseCodename("UpsideDownCake");
    }

    @ChecksSdkIntAtLeast(api=35)
    public static boolean isAtLeastV() {
        return _Original_Build.VERSION.SDK_INT >= 35 || _Original_Build.VERSION.SDK_INT == 34 && SdkLevel.isAtLeastPreReleaseCodename("VanillaIceCream");
    }

    @ChecksSdkIntAtLeast(api=36)
    public static boolean isAtLeastB() {
        return _Original_Build.VERSION.SDK_INT >= 36;
    }

    private static boolean isAtLeastPreReleaseCodename(@NonNull String codename) {
        if ("REL".equals(_Original_Build.VERSION.CODENAME)) {
            return false;
        }
        return _Original_Build.VERSION.CODENAME.compareTo(codename) >= 0;
    }
}

