/*
 * Decompiled with CFR 0.152.
 */
package com.android.net.module.util;

import android.annotation.NonNull;
import android.os.Binder;

public class BinderUtils {
    public static <T extends Exception> void withCleanCallingIdentity(@NonNull ThrowingRunnable<T> action) throws T {
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            action.run();
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T withCleanCallingIdentity(@NonNull ThrowingSupplier<T, E> action) throws E {
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            T t = action.get();
            return t;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<T extends Exception> {
        public void run() throws T;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

