/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import android.app.ResourcesManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Insets;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.InsetsController;
import android.view.InsetsFrameProvider;
import android.view.InsetsSource;
import android.view.InsetsState;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowManager;
import com.android.layoutlib.bridge.bars.NavigationHandle;
import java.util.List;

public class InsetUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rect getCurrentBounds(Context context) {
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            return context.getResources().getConfiguration().windowConfiguration.getBounds();
        }
    }

    public static void setupSysUiInsets(Context context, InsetsController insetsController, List<InsetsFrameProvider> insetsFrameProviders) {
        Rect currentBounds = InsetUtil.getCurrentBounds(context);
        insetsController.onFrameChanged(currentBounds);
        InsetsState insetsState = insetsController.getState();
        Rect tmpRect = new Rect();
        for (InsetsFrameProvider provider : insetsFrameProviders) {
            InsetsSource source = insetsState.getOrCreateSource(provider.getId(), provider.getType());
            source.getFrame().set(currentBounds);
        }
        for (InsetsFrameProvider provider : insetsFrameProviders) {
            Insets insets = provider.getInsetsSize();
            InsetsSource source = insetsState.getOrCreateSource(provider.getId(), provider.getType());
            Rect sourceFrame = source.getFrame();
            if (provider.getMinimalInsetsSizeInDisplayCutoutSafe() != null) {
                tmpRect.set(sourceFrame);
            }
            InsetUtil.calculateInsetsFrame(sourceFrame, insets);
            source.updateSideHint(currentBounds);
            if (provider.getMinimalInsetsSizeInDisplayCutoutSafe() == null) continue;
            InsetUtil.calculateInsetsFrame(tmpRect, provider.getMinimalInsetsSizeInDisplayCutoutSafe());
            if (!tmpRect.contains(sourceFrame)) continue;
            sourceFrame.set(tmpRect);
        }
    }

    private static void calculateInsetsFrame(Rect inOutFrame, Insets insetsSize) {
        if (insetsSize == null) {
            inOutFrame.setEmpty();
            return;
        }
        if (insetsSize.left != 0) {
            inOutFrame.right = inOutFrame.left + insetsSize.left;
        } else if (insetsSize.top != 0) {
            inOutFrame.bottom = inOutFrame.top + insetsSize.top;
        } else if (insetsSize.right != 0) {
            inOutFrame.left = inOutFrame.right - insetsSize.right;
        } else if (insetsSize.bottom != 0) {
            inOutFrame.top = inOutFrame.bottom - insetsSize.bottom;
        } else {
            inOutFrame.setEmpty();
        }
    }

    public static WindowManager.LayoutParams getNavBarLayoutParamsForRotation(Context context, View navBar, int rotation) {
        int width = -1;
        int height = -1;
        int insetsHeight = -1;
        int gravity = 80;
        boolean navBarCanMove = true;
        WindowManager windowManager = context.getSystemService(WindowManager.class);
        if (windowManager != null) {
            Rect displaySize = windowManager.getCurrentWindowMetrics().getBounds();
            boolean bl = navBarCanMove = displaySize.width() != displaySize.height() && context.getResources().getBoolean(0x1110200);
        }
        if (!navBarCanMove) {
            height = context.getResources().getDimensionPixelSize(17105506);
            insetsHeight = context.getResources().getDimensionPixelSize(17105510);
        } else {
            switch (rotation) {
                case -1: 
                case 0: 
                case 2: {
                    height = context.getResources().getDimensionPixelSize(17105506);
                    insetsHeight = context.getResources().getDimensionPixelSize(17105510);
                    break;
                }
                case 1: {
                    gravity = 5;
                    width = context.getResources().getDimensionPixelSize(17105515);
                    break;
                }
                case 3: {
                    gravity = 3;
                    width = context.getResources().getDimensionPixelSize(17105515);
                }
            }
        }
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(width, height, 2019, 545521704, -3);
        lp.gravity = gravity;
        lp.providedInsets = InsetUtil.getInsetsFrameProvider(navBar, insetsHeight, width, context);
        lp.privateFlags |= 0x1001000;
        lp.layoutInDisplayCutoutMode = 3;
        return lp;
    }

    private static InsetsFrameProvider[] getInsetsFrameProvider(View navBar, int insetsHeight, int insetWidth, Context userContext) {
        InsetsFrameProvider navBarProvider = new InsetsFrameProvider(navBar, 0, WindowInsets.Type.navigationBars());
        if (insetsHeight != -1) {
            navBarProvider.setInsetsSize(Insets.of(0, 0, 0, insetsHeight));
        } else if (insetWidth != -1) {
            navBarProvider.setInsetsSize(Insets.of(0, 0, insetWidth, 0));
        }
        boolean needsScrim = userContext.getResources().getBoolean(0x1110202);
        navBarProvider.setFlags(needsScrim ? 0 : 1, 1);
        InsetsFrameProvider tappableElementProvider = new InsetsFrameProvider(navBar, 0, WindowInsets.Type.tappableElement());
        boolean tapThrough = userContext.getResources().getBoolean(17891843);
        if (tapThrough) {
            tappableElementProvider.setInsetsSize(Insets.NONE);
        }
        int gestureHeight = userContext.getResources().getDimensionPixelSize(17105508);
        boolean handlingGesture = navBar instanceof NavigationHandle;
        InsetsFrameProvider mandatoryGestureProvider = new InsetsFrameProvider(navBar, 0, WindowInsets.Type.mandatorySystemGestures());
        if (handlingGesture) {
            mandatoryGestureProvider.setInsetsSize(Insets.of(0, 0, 0, gestureHeight));
        }
        int gestureInset = handlingGesture ? InsetUtil.getUnscaledInset(userContext.getResources()) : 0;
        return new InsetsFrameProvider[]{navBarProvider, tappableElementProvider, mandatoryGestureProvider, new InsetsFrameProvider(navBar, 0, WindowInsets.Type.systemGestures()).setSource(0).setInsetsSize(Insets.of(gestureInset, 0, 0, 0)).setMinimalInsetsSizeInDisplayCutoutSafe(Insets.of(gestureInset, 0, 0, 0)), new InsetsFrameProvider(navBar, 1, WindowInsets.Type.systemGestures()).setSource(0).setInsetsSize(Insets.of(0, 0, gestureInset, 0)).setMinimalInsetsSizeInDisplayCutoutSafe(Insets.of(0, 0, gestureInset, 0))};
    }

    private static int getUnscaledInset(Resources userRes) {
        DisplayMetrics dm = userRes.getDisplayMetrics();
        float defaultInset = userRes.getDimension(17105115) / dm.density;
        float inset = TypedValue.applyDimension(1, defaultInset, dm);
        return (int)inset;
    }
}

