/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.resources;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.resources.IconLoader;
import com.android.resources.Density;
import com.android.resources.LayoutDirection;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SysUiResources {
    private static final ResourceNamespace PRIVATE_LAYOUTLIB_NAMESPACE = ResourceNamespace.fromPackageName((String)"com.android.layoutlib");

    public static BridgeXmlBlockParser loadXml(BridgeContext context, int apiLevel, String layoutName) {
        for (String resourceRepository : Config.getResourceDirs(apiLevel)) {
            String path = resourceRepository + layoutName;
            InputStream stream = SysUiResources.class.getResourceAsStream(path);
            if (stream == null) continue;
            try {
                XmlPullParser parser = ParserFactory.create(stream, layoutName);
                return new BridgeXmlBlockParser(parser, context, PRIVATE_LAYOUTLIB_NAMESPACE);
            }
            catch (XmlPullParserException e) {
                assert (false);
            }
        }
        assert (false);
        return null;
    }

    public static ImageView loadIcon(Context context, int api, ImageView imageView, String iconName, Density density, boolean isRtl, int color2) {
        LayoutDirection dir = isRtl ? LayoutDirection.RTL : null;
        Drawable drawable2 = null;
        if (iconName.endsWith("xml")) {
            IconLoader iconLoader = new IconLoader(iconName, Density.ANYDPI, api, dir);
            InputStream stream = iconLoader.getIcon();
            if (stream != null) {
                try {
                    BridgeXmlBlockParser parser = new BridgeXmlBlockParser(ParserFactory.create(stream, iconName), (BridgeContext)context, ResourceNamespace.ANDROID);
                    drawable2 = Drawable.createFromXml(context.getResources(), parser);
                }
                catch (IOException | XmlPullParserException e) {
                    Bridge.getLog().error("broken", "Unable to load icon " + iconName, e, null, null);
                }
            }
        } else {
            IconLoader iconLoader = new IconLoader(iconName, density, api, dir);
            InputStream stream = iconLoader.getIcon();
            if (stream != null) {
                density = iconLoader.getDensity();
                String path = iconLoader.getPath();
                Bitmap bitmap = Bridge.getCachedBitmap(path, null);
                if (bitmap == null) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inDensity = density.getDpiValue();
                    bitmap = BitmapFactory.decodeStream(stream, null, options);
                    Bridge.setCachedBitmap(path, bitmap, null);
                }
                if (bitmap != null) {
                    drawable2 = new BitmapDrawable(context.getResources(), bitmap);
                }
            }
        }
        if (drawable2 != null) {
            drawable2.setTint(color2);
            imageView.setImageDrawable(drawable2);
        }
        return imageView;
    }
}

