/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.List;

class DisplayCutoutView
extends View {
    private final DisplayInfo mInfo = new DisplayInfo();
    private final Paint mPaint = new Paint();
    private final List<Rect> mBounds = new ArrayList<Rect>();
    private final Rect mBoundingRect = new Rect();
    private final Path cutoutPath = new Path();
    private final int[] mLocation = new int[2];
    private final int mRotation;
    private int mColor = -16777216;
    private final int mInitialPosition;
    private int mPosition;

    public DisplayCutoutView(Context context, int pos) {
        super(context);
        this.mInitialPosition = pos;
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mRotation = this.mInfo.rotation;
    }

    public void setColor(int color2) {
        if (color2 == this.mColor) {
            return;
        }
        this.mColor = color2;
        this.mPaint.setColor(this.mColor);
        this.invalidate();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateCutout();
    }

    private void updateCutout() {
        int newVisible;
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.mPosition = DisplayCutoutView.getBoundPositionFromRotation(this.mInitialPosition, this.mRotation);
        this.requestLayout();
        this.getDisplay().getDisplayInfo(this.mInfo);
        this.mBounds.clear();
        this.mBoundingRect.setEmpty();
        this.cutoutPath.reset();
        if (this.hasCutout()) {
            this.mBounds.addAll(this.mInfo.displayCutout.getBoundingRects());
            this.localBounds(this.mBoundingRect);
            this.updateGravity();
            this.updateBoundingPath();
            this.invalidate();
            newVisible = 0;
        } else {
            newVisible = 8;
        }
        if (newVisible != this.getVisibility()) {
            this.setVisibility(newVisible);
        }
    }

    private static int getBoundPositionFromRotation(int pos, int rotation) {
        return pos - rotation < 0 ? pos - rotation + 4 : pos - rotation;
    }

    private void updateBoundingPath() {
        Path path = this.mInfo.displayCutout.getCutoutPath();
        if (path != null) {
            this.cutoutPath.set(path);
        } else {
            this.cutoutPath.reset();
        }
    }

    private void updateGravity() {
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (lp instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams flp = (FrameLayout.LayoutParams)lp;
            int newGravity = this.getGravity(this.mInfo.displayCutout);
            if (flp.gravity != newGravity) {
                flp.gravity = newGravity;
                this.setLayoutParams(flp);
            }
        }
    }

    private boolean hasCutout() {
        DisplayCutout displayCutout = this.mInfo.displayCutout;
        if (displayCutout == null) {
            return false;
        }
        if (this.mPosition == 0) {
            return !displayCutout.getBoundingRectLeft().isEmpty();
        }
        if (this.mPosition == 1) {
            return !displayCutout.getBoundingRectTop().isEmpty();
        }
        if (this.mPosition == 3) {
            return !displayCutout.getBoundingRectBottom().isEmpty();
        }
        if (this.mPosition == 2) {
            return !displayCutout.getBoundingRectRight().isEmpty();
        }
        return false;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mBounds.isEmpty()) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        this.setMeasuredDimension(DisplayCutoutView.resolveSizeAndState(this.mBoundingRect.width(), widthMeasureSpec, 0), DisplayCutoutView.resolveSizeAndState(this.mBoundingRect.height(), heightMeasureSpec, 0));
    }

    private static void boundsFromDirection(DisplayCutout displayCutout, int gravity, Rect out) {
        switch (gravity) {
            case 48: {
                out.set(displayCutout.getBoundingRectTop());
                break;
            }
            case 3: {
                out.set(displayCutout.getBoundingRectLeft());
                break;
            }
            case 80: {
                out.set(displayCutout.getBoundingRectBottom());
                break;
            }
            case 5: {
                out.set(displayCutout.getBoundingRectRight());
                break;
            }
            default: {
                out.setEmpty();
            }
        }
    }

    private void localBounds(Rect out) {
        DisplayCutout displayCutout = this.mInfo.displayCutout;
        DisplayCutoutView.boundsFromDirection(displayCutout, this.getGravity(displayCutout), out);
    }

    private int getGravity(DisplayCutout displayCutout) {
        if (this.mPosition == 0) {
            if (!displayCutout.getBoundingRectLeft().isEmpty()) {
                return 3;
            }
        } else if (this.mPosition == 1) {
            if (!displayCutout.getBoundingRectTop().isEmpty()) {
                return 48;
            }
        } else if (this.mPosition == 3) {
            if (!displayCutout.getBoundingRectBottom().isEmpty()) {
                return 80;
            }
        } else if (this.mPosition == 2 && !displayCutout.getBoundingRectRight().isEmpty()) {
            return 5;
        }
        return 0;
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        this.getLocationOnScreen(this.mLocation);
        canvas.translate(-this.mLocation[0], -this.mLocation[1]);
        canvas.drawPath(this.cutoutPath, this.mPaint);
        canvas.restore();
    }
}

