/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.player;

import android.app.Application;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.widget.remotecompose.accessibility.RemoteComposeTouchHelper;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.RemoteContextAware;
import com.android.internal.widget.remotecompose.player.RemoteComposeDocument;
import com.android.internal.widget.remotecompose.player.platform.AndroidRemoteContext;
import com.android.internal.widget.remotecompose.player.platform.RemoteComposeCanvas;

public class RemoteComposePlayer
extends FrameLayout
implements RemoteContextAware {
    private RemoteComposeCanvas mInner;
    private static final int MAX_SUPPORTED_MAJOR_VERSION = 1;
    private static final int MAX_SUPPORTED_MINOR_VERSION = 0;
    private static final int[] sHapticTable = new int[]{-1, 0, 1, 3, 4, 6, 3, 7, 8, 9, 12, 13, 16, 17, 21, 22, 23, 24, 25, 26, 27};
    SensorManager mSensorManager;
    Sensor mAcc = null;
    Sensor mGyro = null;
    Sensor mMag = null;
    Sensor mLight = null;
    SensorEventListener mListener;
    private CoreDocument.ShaderControl mShaderControl = shader -> false;

    public RemoteComposePlayer(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public RemoteComposePlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public RemoteComposePlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @Override
    public RemoteContext getRemoteContext() {
        return this.mInner.getRemoteContext();
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
        if (this.mInner != null) {
            this.mInner.requestLayout();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.mInner != null) {
            this.mInner.invalidate();
        }
    }

    public boolean isDraggable() {
        return this.mInner.isDraggable();
    }

    public void setDebug(int debugFlags) {
        this.mInner.setDebug(debugFlags);
    }

    public RemoteComposeDocument getDocument() {
        return this.mInner.getDocument();
    }

    public void updateDocument(RemoteComposeDocument value) {
        RemoteComposeDocument document = value;
        AndroidRemoteContext tmpContext = new AndroidRemoteContext();
        document.initializeContext(tmpContext);
        float density = this.getContext().getResources().getDisplayMetrics().density;
        tmpContext.setAnimationEnabled(true);
        tmpContext.setDensity(density);
        tmpContext.setUseChoreographer(false);
        this.mInner.getDocument().mDocument.applyUpdate(document.mDocument);
        this.mInner.invalidate();
    }

    public void setDocument(RemoteComposeDocument value) {
        if (value != null) {
            if (value.canBeDisplayed(1, 0, 0L)) {
                if (value.isUpdateDoc()) {
                    this.updateDocument(value);
                    return;
                }
                this.mInner.setDocument(value);
                int contentBehavior = value.getDocument().getContentScroll();
                this.applyContentBehavior(contentBehavior);
            } else {
                Log.e("RemoteComposePlayer", "Unsupported document ");
            }
            RemoteComposeTouchHelper.REGISTRAR.setAccessibilityDelegate(this, value.getDocument());
        } else {
            this.mInner.setDocument(null);
            RemoteComposeTouchHelper.REGISTRAR.clearAccessibilityDelegate(this);
        }
        this.mapColors();
        this.setupSensors();
        this.mInner.setHapticEngine(new CoreDocument.HapticEngine(){

            @Override
            public void haptic(int type) {
                RemoteComposePlayer.this.provideHapticFeedback(type);
            }
        });
        this.mInner.checkShaders(this.mShaderControl);
    }

    private void applyContentBehavior(int contentBehavior) {
        switch (contentBehavior) {
            case 1: {
                if (this.mInner.getParent() instanceof HorizontalScrollView) break;
                ((ViewGroup)this.mInner.getParent()).removeView(this.mInner);
                this.removeAllViews();
                FrameLayout.LayoutParams layoutParamsInner = new FrameLayout.LayoutParams(-2, -1);
                HorizontalScrollView horizontalScrollView = new HorizontalScrollView(this.getContext());
                horizontalScrollView.setBackgroundColor(0);
                horizontalScrollView.setFillViewport(true);
                horizontalScrollView.addView((View)this.mInner, layoutParamsInner);
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                this.addView((View)horizontalScrollView, layoutParams);
                break;
            }
            case 2: {
                if (this.mInner.getParent() instanceof ScrollView) break;
                ((ViewGroup)this.mInner.getParent()).removeView(this.mInner);
                this.removeAllViews();
                FrameLayout.LayoutParams layoutParamsInner = new FrameLayout.LayoutParams(-1, -2);
                ScrollView scrollView = new ScrollView(this.getContext());
                scrollView.setBackgroundColor(0);
                scrollView.setFillViewport(true);
                scrollView.addView((View)this.mInner, layoutParamsInner);
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                this.addView((View)scrollView, layoutParams);
                break;
            }
            default: {
                if (this.mInner.getParent() == this) break;
                ((ViewGroup)this.mInner.getParent()).removeView(this.mInner);
                this.removeAllViews();
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                this.addView((View)this.mInner, layoutParams);
            }
        }
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.setBackgroundColor(0);
        this.mInner = new RemoteComposeCanvas(context, attrs, defStyleAttr);
        this.mInner.setBackgroundColor(0);
        this.addView((View)this.mInner, layoutParams);
    }

    public void setLocalString(String domain, String name, String content) {
        this.mInner.setLocalString(domain + ":" + name, content);
    }

    public void clearLocalString(String domain, String name) {
        this.mInner.clearLocalString(domain + ":" + name);
    }

    public void setUserLocalString(String name, String content) {
        this.mInner.setLocalString("USER:" + name, content);
    }

    public void setUserLocalInt(String name, int value) {
        this.mInner.setLocalInt("USER:" + name, value);
    }

    public void setUserLocalColor(String name, int value) {
        this.mInner.setLocalColor("USER:" + name, value);
    }

    public void setUserLocalFloat(String name, float value) {
        this.mInner.setLocalFloat("USER:" + name, Float.valueOf(value));
    }

    public void setUserLocalBitmap(String name, Bitmap value) {
        this.mInner.setLocalBitmap("USER:" + name, value);
    }

    public void clearUserLocalBitmap(String name) {
        this.mInner.clearLocalBitmap("USER:" + name);
    }

    public void clearUserLocalString(String name) {
        this.mInner.clearLocalString("USER:" + name);
    }

    public void clearUserLocalInt(String name) {
        this.mInner.clearLocalInt("USER:" + name);
    }

    public void clearUserLocalColor(String name) {
        this.mInner.clearLocalColor("USER:" + name);
    }

    public void clearUserLocalFloat(String name) {
        this.mInner.clearLocalFloat("USER:" + name);
    }

    public void setSystemLocalString(String name, String content) {
        this.mInner.setLocalString("SYSTEM:" + name, content);
    }

    public void clearSystemLocalString(String name) {
        this.mInner.clearLocalString("SYSTEM:" + name);
    }

    public int getOpsPerFrame() {
        return this.mInner.getDocument().mDocument.getOpsPerFrame();
    }

    @VisibleForTesting
    public void setUseChoreographer(boolean value) {
        this.mInner.setUseChoreographer(value);
    }

    public void addIdActionListener(IdActionCallbacks callback) {
        this.mInner.addIdActionListener((int id2, String metadata) -> callback.onAction(id2, metadata));
    }

    public void setTheme(int theme) {
        if (this.mInner.getTheme() != theme) {
            this.mInner.setTheme(theme);
            this.mInner.invalidate();
        }
    }

    public String[] getNamedColors() {
        return this.mInner.getNamedColors();
    }

    public String[] getNamedFloats() {
        return this.mInner.getNamedVariables(1);
    }

    public String[] getNamedStrings() {
        return this.mInner.getNamedVariables(0);
    }

    public String[] getNamedImages() {
        return this.mInner.getNamedVariables(3);
    }

    public void setColor(String colorName, int colorValue) {
        this.mInner.setColor(colorName, colorValue);
    }

    public void setLong(String name, long value) {
        this.mInner.setLong(name, value);
    }

    private void mapColors() {
        int i;
        String[] name = this.getNamedColors();
        if (name == null) {
            return;
        }
        boolean found = false;
        for (i = 0; i < name.length; ++i) {
            if (!name[i].startsWith("android.")) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        block103: for (i = 0; i < name.length; ++i) {
            String sub;
            String s = name[i];
            if (!s.startsWith("android.")) continue;
            switch (sub = s.substring("android.".length())) {
                case "actionBarItemBackground": {
                    this.setRColor(s, 16843676);
                    continue block103;
                }
                case "actionModeBackground": {
                    this.setRColor(s, 16843483);
                    continue block103;
                }
                case "actionModeSplitBackground": {
                    this.setRColor(s, 16843677);
                    continue block103;
                }
                case "activatedBackgroundIndicator": {
                    this.setRColor(s, 16843517);
                    continue block103;
                }
                case "colorAccent": {
                    this.setRColor(s, 16843829);
                    continue block103;
                }
                case "colorActivatedHighlight": {
                    this.setRColor(s, 16843664);
                    continue block103;
                }
                case "colorBackground": {
                    this.setRColor(s, 0x1010031);
                    continue block103;
                }
                case "colorBackgroundCacheHint": {
                    this.setRColor(s, 16843435);
                    continue block103;
                }
                case "colorBackgroundFloating": {
                    this.setRColor(s, 16844002);
                    continue block103;
                }
                case "colorButtonNormal": {
                    this.setRColor(s, 16843819);
                    continue block103;
                }
                case "colorControlActivated": {
                    this.setRColor(s, 16843818);
                    continue block103;
                }
                case "colorControlHighlight": {
                    this.setRColor(s, 16843820);
                    continue block103;
                }
                case "colorControlNormal": {
                    this.setRColor(s, 16843817);
                    continue block103;
                }
                case "colorEdgeEffect": {
                    this.setRColor(s, 16843982);
                    continue block103;
                }
                case "colorError": {
                    this.setRColor(s, 16844099);
                    continue block103;
                }
                case "colorFocusedHighlight": {
                    this.setRColor(s, 16843663);
                    continue block103;
                }
                case "colorForeground": {
                    this.setRColor(s, 0x1010030);
                    continue block103;
                }
                case "colorForegroundInverse": {
                    this.setRColor(s, 16843270);
                    continue block103;
                }
                case "colorLongPressedHighlight": {
                    this.setRColor(s, 16843662);
                    continue block103;
                }
                case "colorMultiSelectHighlight": {
                    this.setRColor(s, 16843665);
                    continue block103;
                }
                case "colorPressedHighlight": {
                    this.setRColor(s, 16843661);
                    continue block103;
                }
                case "colorPrimary": {
                    this.setRColor(s, 16843827);
                    continue block103;
                }
                case "colorPrimaryDark": {
                    this.setRColor(s, 16843828);
                    continue block103;
                }
                case "colorSecondary": {
                    this.setRColor(s, 16844080);
                    continue block103;
                }
                case "detailsElementBackground": {
                    this.setRColor(s, 16843598);
                    continue block103;
                }
                case "editTextBackground": {
                    this.setRColor(s, 16843602);
                    continue block103;
                }
                case "galleryItemBackground": {
                    this.setRColor(s, 16842828);
                    continue block103;
                }
                case "headerBackground": {
                    this.setRColor(s, 16843055);
                    continue block103;
                }
                case "itemBackground": {
                    this.setRColor(s, 0x1010130);
                    continue block103;
                }
                case "numbersBackgroundColor": {
                    this.setRColor(s, 16843938);
                    continue block103;
                }
                case "panelBackground": {
                    this.setRColor(s, 16842846);
                    continue block103;
                }
                case "panelColorBackground": {
                    this.setRColor(s, 0x1010061);
                    continue block103;
                }
                case "panelFullBackground": {
                    this.setRColor(s, 16842847);
                    continue block103;
                }
                case "popupBackground": {
                    this.setRColor(s, 16843126);
                    continue block103;
                }
                case "queryBackground": {
                    this.setRColor(s, 16843911);
                    continue block103;
                }
                case "selectableItemBackground": {
                    this.setRColor(s, 16843534);
                    continue block103;
                }
                case "submitBackground": {
                    this.setRColor(s, 16843912);
                    continue block103;
                }
                case "textColor": {
                    this.setRColor(s, 16842904);
                    continue block103;
                }
                case "windowBackground": {
                    this.setRColor(s, 16842836);
                    continue block103;
                }
                case "windowBackgroundFallback": {
                    this.setRColor(s, 16844035);
                    continue block103;
                }
                case "textColorPrimaryInverse": {
                    this.setRColor(s, 16842809);
                    continue block103;
                }
                case "textColorSecondaryInverse": {
                    this.setRColor(s, 16842810);
                    continue block103;
                }
                case "textColorTertiary": {
                    this.setRColor(s, 0x1010212);
                    continue block103;
                }
                case "textColorTertiaryInverse": {
                    this.setRColor(s, 16843283);
                    continue block103;
                }
                case "textColorHighlight": {
                    this.setRColor(s, 0x1010099);
                    continue block103;
                }
                case "textColorLink": {
                    this.setRColor(s, 16842907);
                    continue block103;
                }
                case "textColorHint": {
                    this.setRColor(s, 16842906);
                    continue block103;
                }
                case "textColorHintInverse": {
                    this.setRColor(s, 16842815);
                    continue block103;
                }
                case "colorSwitchThumbNormal": {
                    this.setRColor(s, 16843817);
                }
            }
        }
    }

    private void setRColor(String name, int id2) {
        int color2 = this.getColorFromResource(id2);
        this.setColor(name, color2);
    }

    private int getColorFromResource(int id2) {
        TypedValue typedValue = new TypedValue();
        try (TypedArray arr = this.getContext().getApplicationContext().obtainStyledAttributes(typedValue.data, new int[]{id2});){
            int color2;
            int n = color2 = arr.getColor(0, -1);
            return n;
        }
    }

    private void provideHapticFeedback(int type) {
        this.performHapticFeedback(sHapticTable[type % sHapticTable.length]);
    }

    private void setupSensors() {
        int minId = 17;
        int maxId = 26;
        int[] ids = new int[1 + maxId - minId];
        int count = this.mInner.hasSensorListeners(ids);
        this.mAcc = null;
        this.mGyro = null;
        this.mMag = null;
        this.mLight = null;
        if (count > 0) {
            Application app = (Application)this.getContext().getApplicationContext();
            this.mSensorManager = (SensorManager)app.getSystemService("sensor");
            block6: for (int i = 0; i < count; ++i) {
                switch (ids[i]) {
                    case 17: 
                    case 18: 
                    case 19: {
                        if (this.mAcc != null) continue block6;
                        this.mAcc = this.mSensorManager.getDefaultSensor(1);
                        continue block6;
                    }
                    case 20: 
                    case 21: 
                    case 22: {
                        if (this.mGyro != null) continue block6;
                        this.mGyro = this.mSensorManager.getDefaultSensor(4);
                        continue block6;
                    }
                    case 23: 
                    case 24: 
                    case 25: {
                        if (this.mMag != null) continue block6;
                        this.mMag = this.mSensorManager.getDefaultSensor(2);
                        continue block6;
                    }
                    case 26: {
                        if (this.mLight != null) continue block6;
                        this.mLight = this.mSensorManager.getDefaultSensor(5);
                    }
                }
            }
        }
        this.registerListener();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unregisterListener();
    }

    public void registerListener() {
        Sensor[] s = new Sensor[]{this.mAcc, this.mGyro, this.mMag, this.mLight};
        if (this.mListener != null) {
            this.unregisterListener();
        }
        SensorEventListener listener = new SensorEventListener(){

            @Override
            public void onSensorChanged(SensorEvent event) {
                if (event.sensor == RemoteComposePlayer.this.mAcc) {
                    RemoteComposePlayer.this.mInner.setExternalFloat(17, event.values[0]);
                    RemoteComposePlayer.this.mInner.setExternalFloat(18, event.values[1]);
                    RemoteComposePlayer.this.mInner.setExternalFloat(19, event.values[2]);
                } else if (event.sensor == RemoteComposePlayer.this.mGyro) {
                    RemoteComposePlayer.this.mInner.setExternalFloat(20, event.values[0]);
                    RemoteComposePlayer.this.mInner.setExternalFloat(21, event.values[1]);
                    RemoteComposePlayer.this.mInner.setExternalFloat(22, event.values[2]);
                } else if (event.sensor == RemoteComposePlayer.this.mMag) {
                    RemoteComposePlayer.this.mInner.setExternalFloat(23, event.values[0]);
                    RemoteComposePlayer.this.mInner.setExternalFloat(24, event.values[1]);
                    RemoteComposePlayer.this.mInner.setExternalFloat(25, event.values[2]);
                } else if (event.sensor == RemoteComposePlayer.this.mLight) {
                    RemoteComposePlayer.this.mInner.setExternalFloat(26, event.values[0]);
                }
            }

            @Override
            public void onAccuracyChanged(Sensor sensor, int accuracy) {
            }
        };
        Sensor[] sensors = new Sensor[]{this.mAcc, this.mGyro, this.mMag, this.mLight};
        for (int i = 0; i < sensors.length; ++i) {
            Sensor sensor = sensors[i];
            if (sensor == null) continue;
            this.mListener = listener;
            this.mSensorManager.registerListener(this.mListener, sensor, 3);
        }
    }

    public void unregisterListener() {
        if (this.mListener != null && this.mSensorManager != null) {
            this.mSensorManager.unregisterListener(this.mListener);
        }
        this.mListener = null;
    }

    public float getEvalTime() {
        return this.mInner.getEvalTime();
    }

    public void setShaderControl(CoreDocument.ShaderControl ctl) {
        this.mShaderControl = ctl;
    }

    public static interface IdActionCallbacks {
        public void onAction(int var1, String var2);
    }
}

