/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.semantics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.semantics.AccessibilityModifier;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class CoreSemantics
extends Operation
implements AccessibilityModifier {
    public int mContentDescriptionId = 0;
    @Nullable
    public AccessibleComponent.Role mRole = null;
    public int mTextId = 0;
    public int mStateDescriptionId = 0;
    public boolean mEnabled = true;
    public AccessibleComponent.Mode mMode = AccessibleComponent.Mode.SET;
    public boolean mClickable = false;

    @Override
    public int getOpCode() {
        return 250;
    }

    @Override
    @Nullable
    public AccessibleComponent.Role getRole() {
        return this.mRole;
    }

    @Override
    public AccessibleComponent.Mode getMode() {
        return this.mMode;
    }

    @Override
    public void write(WireBuffer buffer) {
        buffer.writeInt(this.mContentDescriptionId);
        buffer.writeByte(this.mRole != null ? this.mRole.ordinal() : -1);
        buffer.writeInt(this.mTextId);
        buffer.writeInt(this.mStateDescriptionId);
        buffer.writeByte(this.mMode.ordinal());
        buffer.writeBoolean(this.mEnabled);
        buffer.writeBoolean(this.mClickable);
    }

    private void read(WireBuffer buffer) {
        this.mContentDescriptionId = buffer.readInt();
        this.mRole = AccessibleComponent.Role.fromInt(buffer.readByte());
        this.mTextId = buffer.readInt();
        this.mStateDescriptionId = buffer.readInt();
        this.mMode = AccessibleComponent.Mode.values()[buffer.readByte()];
        this.mEnabled = buffer.readBoolean();
        this.mClickable = buffer.readBoolean();
    }

    @Override
    public void apply(RemoteContext context) {
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SEMANTICS");
        if (this.mMode != AccessibleComponent.Mode.SET) {
            builder.append(" ");
            builder.append((Object)this.mMode);
        }
        if (this.mRole != null) {
            builder.append(" ");
            builder.append((Object)this.mRole);
        }
        if (this.mContentDescriptionId > 0) {
            builder.append(" contentDescription=");
            builder.append(this.mContentDescriptionId);
        }
        if (this.mTextId > 0) {
            builder.append(" text=");
            builder.append(this.mTextId);
        }
        if (this.mStateDescriptionId > 0) {
            builder.append(" stateDescription=");
            builder.append(this.mStateDescriptionId);
        }
        if (!this.mEnabled) {
            builder.append(" disabled");
        }
        if (this.mClickable) {
            builder.append(" clickable");
        }
        return builder.toString();
    }

    @Override
    @Nullable
    public String deepToString(String indent) {
        return indent + this;
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "SEMANTICS = " + this);
    }

    public static void read(WireBuffer buffer, List<Operation> operations) {
        CoreSemantics semantics = new CoreSemantics();
        semantics.read(buffer);
        operations.add(semantics);
    }

    @Override
    public Integer getContentDescriptionId() {
        return this.mContentDescriptionId != 0 ? Integer.valueOf(this.mContentDescriptionId) : null;
    }

    @Nullable
    public Integer getStateDescriptionId() {
        return this.mStateDescriptionId != 0 ? Integer.valueOf(this.mStateDescriptionId) : null;
    }

    @Override
    @Nullable
    public Integer getTextId() {
        return this.mTextId != 0 ? Integer.valueOf(this.mTextId) : null;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER, SerializeTags.A11Y).addType("CoreSemantics").add("contentDescriptionId", this.mContentDescriptionId).add("role", this.mRole).add("textId", this.mTextId).add("stateDescriptionId", this.mStateDescriptionId).add("enabled", this.mEnabled).add("mode", this.mMode).add("clickable", this.mClickable);
    }
}

