/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities.easing;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.BounceCurve;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.CubicEasing;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.Easing;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.ElasticOutCurve;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.StepCurve;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;

public class FloatAnimation
extends Easing
implements Serializable {
    float[] mSpec;
    Easing mEasingCurve;
    private float mDuration = 1.0f;
    private float mWrap = Float.NaN;
    private float mInitialValue = Float.NaN;
    private float mTargetValue = Float.NaN;
    private int mDirectionalSnap = 0;
    float mOffset = 0.0f;
    private boolean mPropagate = false;

    @NonNull
    public String toString() {
        String str = "type " + this.mType;
        if (!Float.isNaN(this.mInitialValue)) {
            str = str + " " + this.mInitialValue;
        }
        if (!Float.isNaN(this.mTargetValue)) {
            str = str + " -> " + this.mTargetValue;
        }
        if (!Float.isNaN(this.mWrap)) {
            str = str + "  % " + this.mWrap;
        }
        return str;
    }

    public FloatAnimation(float ... description) {
        this.mType = 1;
        this.setAnimationDescription(description);
    }

    public FloatAnimation(int type, float duration, @Nullable float[] description, float initialValue, float wrap) {
        this.mType = 1;
        this.setAnimationDescription(FloatAnimation.packToFloatArray(duration, type, description, initialValue, wrap));
    }

    @NonNull
    public static float[] packToFloatArray(float duration, int type, @Nullable float[] spec, float initialValue, float wrap) {
        int specLen;
        int count = 0;
        if (!Float.isNaN(initialValue)) {
            ++count;
        }
        if (spec != null) {
            ++count;
        }
        if (spec != null || type != 1) {
            ++count;
            count += spec == null ? 0 : spec.length;
        }
        if (!Float.isNaN(initialValue)) {
            ++count;
        }
        if (!Float.isNaN(wrap)) {
            ++count;
        }
        if (duration != 1.0f || count > 0) {
            ++count;
        }
        if (!Float.isNaN(wrap) || !Float.isNaN(initialValue)) {
            ++count;
        }
        float[] ret = new float[count];
        int pos = 0;
        int n = specLen = spec == null ? 0 : spec.length;
        if (ret.length > 0) {
            ret[pos++] = duration;
        }
        if (ret.length > 1) {
            int wrapBit = Float.isNaN(wrap) ? 0 : 1;
            int initBit = Float.isNaN(initialValue) ? 0 : 2;
            int bits = type | (wrapBit | initBit) << 8;
            ret[pos++] = Float.intBitsToFloat(specLen << 16 | bits);
        }
        if (specLen > 0) {
            System.arraycopy(spec, 0, ret, pos, spec.length);
            pos += spec.length;
        }
        if (!Float.isNaN(initialValue)) {
            ret[pos++] = initialValue;
        }
        if (!Float.isNaN(wrap)) {
            ret[pos] = wrap;
        }
        return ret;
    }

    public static String unpackAnimationToString(float[] description) {
        float[] mSpec = description;
        float mDuration = mSpec.length == 0 ? 1.0f : mSpec[0];
        int len = 0;
        int type = 0;
        float wrapValue = Float.NaN;
        float initialValue = Float.NaN;
        int directionalSnap = 0;
        boolean propagate = false;
        if (mSpec.length > 1) {
            int num_type = Float.floatToRawIntBits(mSpec[1]);
            type = num_type & 0xFF;
            boolean wrap = (num_type >> 8 & 1) > 0;
            boolean init = (num_type >> 8 & 2) > 0;
            directionalSnap = num_type >> 10 & 3;
            propagate = (num_type >> 12 & 1) > 0;
            len = num_type >> 16 & 0xFFFF;
            int off = 2 + len;
            if (init) {
                initialValue = mSpec[off++];
            }
            if (wrap) {
                wrapValue = mSpec[off];
            }
        }
        float[] params = description;
        int offset = 2;
        String typeStr = "";
        switch (type) {
            case 1: {
                typeStr = "CUBIC_STANDARD";
                break;
            }
            case 2: {
                typeStr = "CUBIC_ACCELERATE";
                break;
            }
            case 3: {
                typeStr = "CUBIC_DECELERATE";
                break;
            }
            case 4: {
                typeStr = "CUBIC_LINEAR";
                break;
            }
            case 5: {
                typeStr = "CUBIC_ANTICIPATE";
                break;
            }
            case 6: {
                typeStr = "CUBIC_OVERSHOOT";
                break;
            }
            case 11: {
                typeStr = "CUBIC_CUSTOM (";
                typeStr = typeStr + params[offset + 0] + " ";
                typeStr = typeStr + params[offset + 1] + " ";
                typeStr = typeStr + params[offset + 2] + " ";
                typeStr = typeStr + params[offset + 3] + " )";
                break;
            }
            case 13: {
                typeStr = "EASE_OUT_BOUNCE";
                break;
            }
            case 14: {
                typeStr = "EASE_OUT_ELASTIC";
                break;
            }
            case 12: {
                typeStr = "SPLINE_CUSTOM (";
                for (int i = offset; i < offset + len; ++i) {
                    typeStr = typeStr + params[i] + " ";
                }
                typeStr = typeStr + ")";
            }
        }
        String str = mDuration + " " + typeStr;
        if (!Float.isNaN(initialValue)) {
            str = str + " init =" + initialValue;
        }
        if (!Float.isNaN(wrapValue)) {
            str = str + " wrap =" + wrapValue;
        }
        if (directionalSnap != 0) {
            str = str + " directionalSnap=" + directionalSnap;
        }
        if (propagate) {
            str = str + " propagate";
        }
        return str;
    }

    public void setAnimationDescription(@NonNull float[] description) {
        this.mSpec = description;
        this.mDuration = this.mSpec.length == 0 ? 1.0f : this.mSpec[0];
        int len = 0;
        if (this.mSpec.length > 1) {
            int num_type = Float.floatToRawIntBits(this.mSpec[1]);
            this.mType = num_type & 0xFF;
            boolean wrap = (num_type >> 8 & 1) > 0;
            boolean init = (num_type >> 8 & 2) > 0;
            int directional = num_type >> 10 & 3;
            boolean propagate = (num_type >> 12 & 1) > 0;
            len = num_type >> 16 & 0xFFFF;
            int off = 2 + len;
            if (init) {
                this.mInitialValue = this.mSpec[off++];
            }
            if (wrap) {
                this.mWrap = this.mSpec[off];
            }
            this.mDirectionalSnap = directional;
            this.mPropagate = propagate;
        }
        this.create(this.mType, description, 2, len);
    }

    private void create(int type, @Nullable float[] params, int offset, int len) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.mEasingCurve = new CubicEasing(type);
                break;
            }
            case 11: {
                this.mEasingCurve = new CubicEasing(params[offset + 0], params[offset + 1], params[offset + 2], params[offset + 3]);
                break;
            }
            case 13: {
                this.mEasingCurve = new BounceCurve(type);
                break;
            }
            case 14: {
                this.mEasingCurve = new ElasticOutCurve();
                break;
            }
            case 12: {
                this.mEasingCurve = new StepCurve(params, offset, len);
            }
        }
    }

    public float getDuration() {
        return this.mDuration;
    }

    public void setInitialValue(float value) {
        this.mInitialValue = Float.isNaN(this.mWrap) ? value : value % this.mWrap;
        this.setScaleOffset();
    }

    private static float wrap(float wrap, float value) {
        if ((value %= wrap) < 0.0f) {
            value += wrap;
        }
        return value;
    }

    float wrapDistance(float wrap, float from, float to) {
        float delta = (to - from) % 360.0f;
        if (delta < -wrap / 2.0f) {
            delta += wrap;
        } else if (delta > wrap / 2.0f) {
            delta -= wrap;
        }
        return delta;
    }

    public void setTargetValue(float value) {
        this.mTargetValue = value;
        if (!Float.isNaN(this.mWrap)) {
            float dist;
            this.mInitialValue = FloatAnimation.wrap(this.mWrap, this.mInitialValue);
            this.mTargetValue = FloatAnimation.wrap(this.mWrap, this.mTargetValue);
            if (Float.isNaN(this.mInitialValue)) {
                this.mInitialValue = this.mTargetValue;
            }
            if ((dist = this.wrapDistance(this.mWrap, this.mInitialValue, this.mTargetValue)) > 0.0f && this.mTargetValue < this.mInitialValue) {
                this.mTargetValue += this.mWrap;
            } else if (dist < 0.0f && this.mDirectionalSnap != 0) {
                if (this.mDirectionalSnap == 1 && this.mTargetValue > this.mInitialValue) {
                    this.mInitialValue = this.mTargetValue;
                }
                if (this.mDirectionalSnap == 2 && this.mTargetValue < this.mInitialValue) {
                    this.mInitialValue = this.mTargetValue;
                }
                this.mTargetValue -= this.mWrap;
            }
        }
        this.setScaleOffset();
    }

    public float getTargetValue() {
        return this.mTargetValue;
    }

    private void setScaleOffset() {
        this.mOffset = !Float.isNaN(this.mInitialValue) && !Float.isNaN(this.mTargetValue) ? this.mInitialValue : 0.0f;
    }

    @Override
    public float get(float t) {
        if (this.mDirectionalSnap == 1 && this.mTargetValue < this.mInitialValue) {
            this.mInitialValue = this.mTargetValue;
            return this.mTargetValue;
        }
        if (this.mDirectionalSnap == 2 && this.mTargetValue > this.mInitialValue) {
            this.mInitialValue = this.mTargetValue;
            return this.mTargetValue;
        }
        return this.mEasingCurve.get(t / this.mDuration) * (this.mTargetValue - this.mInitialValue) + this.mInitialValue;
    }

    @Override
    public float getDiff(float t) {
        return this.mEasingCurve.getDiff(t / this.mDuration) * (this.mTargetValue - this.mInitialValue);
    }

    public boolean isPropagate() {
        return this.mPropagate;
    }

    public float getInitialValue() {
        return this.mInitialValue;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType("FloatAnimation").add("initialValue", Float.valueOf(this.mInitialValue)).add("targetValue", Float.valueOf(this.mTargetValue)).add("duration", Float.valueOf(this.mDuration)).add("easing", Easing.getString(this.mEasingCurve.getType()));
    }
}

