/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.operations.utilities.CollectionsAccess;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.NanMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.MonotonicSpline;
import java.util.Random;

public class AnimatedFloatExpression {
    @NonNull
    static IntMap<String> sNames = new IntMap();
    public static final int OFFSET = 0x310000;
    public static final float ADD = AnimatedFloatExpression.asNan(0x310001);
    public static final float SUB = AnimatedFloatExpression.asNan(3211266);
    public static final float MUL = AnimatedFloatExpression.asNan(0x310003);
    public static final float DIV = AnimatedFloatExpression.asNan(3211268);
    public static final float MOD = AnimatedFloatExpression.asNan(3211269);
    public static final float MIN = AnimatedFloatExpression.asNan(3211270);
    public static final float MAX = AnimatedFloatExpression.asNan(3211271);
    public static final float POW = AnimatedFloatExpression.asNan(3211272);
    public static final float SQRT = AnimatedFloatExpression.asNan(3211273);
    public static final float ABS = AnimatedFloatExpression.asNan(3211274);
    public static final float SIGN = AnimatedFloatExpression.asNan(3211275);
    public static final float COPY_SIGN = AnimatedFloatExpression.asNan(3211276);
    public static final float EXP = AnimatedFloatExpression.asNan(3211277);
    public static final float FLOOR = AnimatedFloatExpression.asNan(3211278);
    public static final float LOG = AnimatedFloatExpression.asNan(3211279);
    public static final float LN = AnimatedFloatExpression.asNan(0x310010);
    public static final float ROUND = AnimatedFloatExpression.asNan(0x310011);
    public static final float SIN = AnimatedFloatExpression.asNan(3211282);
    public static final float COS = AnimatedFloatExpression.asNan(0x310013);
    public static final float TAN = AnimatedFloatExpression.asNan(3211284);
    public static final float ASIN = AnimatedFloatExpression.asNan(3211285);
    public static final float ACOS = AnimatedFloatExpression.asNan(3211286);
    public static final float ATAN = AnimatedFloatExpression.asNan(3211287);
    public static final float ATAN2 = AnimatedFloatExpression.asNan(3211288);
    public static final float MAD = AnimatedFloatExpression.asNan(3211289);
    public static final float IFELSE = AnimatedFloatExpression.asNan(3211290);
    public static final float CLAMP = AnimatedFloatExpression.asNan(3211291);
    public static final float CBRT = AnimatedFloatExpression.asNan(3211292);
    public static final float DEG = AnimatedFloatExpression.asNan(3211293);
    public static final float RAD = AnimatedFloatExpression.asNan(3211294);
    public static final float CEIL = AnimatedFloatExpression.asNan(3211295);
    public static final float A_DEREF = AnimatedFloatExpression.asNan(3211296);
    public static final float A_MAX = AnimatedFloatExpression.asNan(3211297);
    public static final float A_MIN = AnimatedFloatExpression.asNan(3211298);
    public static final float A_SUM = AnimatedFloatExpression.asNan(3211299);
    public static final float A_AVG = AnimatedFloatExpression.asNan(3211300);
    public static final float A_LEN = AnimatedFloatExpression.asNan(3211301);
    public static final float A_SPLINE = AnimatedFloatExpression.asNan(3211302);
    public static final float RAND = AnimatedFloatExpression.asNan(3211303);
    public static final float RAND_SEED = AnimatedFloatExpression.asNan(3211304);
    public static final float NOISE_FROM = AnimatedFloatExpression.asNan(3211305);
    public static final float RAND_IN_RANGE = AnimatedFloatExpression.asNan(3211306);
    public static final float SQUARE_SUM = AnimatedFloatExpression.asNan(3211307);
    public static final float STEP = AnimatedFloatExpression.asNan(3211308);
    public static final float SQUARE = AnimatedFloatExpression.asNan(3211309);
    public static final float DUP = AnimatedFloatExpression.asNan(3211310);
    public static final float HYPOT = AnimatedFloatExpression.asNan(3211311);
    public static final float SWAP = AnimatedFloatExpression.asNan(0x310030);
    public static final float LERP = AnimatedFloatExpression.asNan(0x310031);
    public static final float SMOOTH_STEP = AnimatedFloatExpression.asNan(3211314);
    public static final int LAST_OP = 3211314;
    public static final float VAR1 = AnimatedFloatExpression.asNan(0x310033);
    public static final float VAR2 = AnimatedFloatExpression.asNan(3211316);
    public static final float VAR3 = AnimatedFloatExpression.asNan(3211317);
    private static final float FP_TO_RAD = 57.29578f;
    private static final float FP_TO_DEG = (float)Math.PI / 180;
    @NonNull
    float[] mStack = new float[0];
    @NonNull
    float[] mLocalStack = new float[128];
    @NonNull
    float[] mVar = new float[0];
    @Nullable
    CollectionsAccess mCollectionsAccess;
    IntMap<MonotonicSpline> mSplineMap = new IntMap();
    private static Random sRandom;
    static final int[] NO_OF_OPS;
    private static final int OP_ADD = 0x310001;
    private static final int OP_SUB = 3211266;
    private static final int OP_MUL = 0x310003;
    private static final int OP_DIV = 3211268;
    private static final int OP_MOD = 3211269;
    private static final int OP_MIN = 3211270;
    private static final int OP_MAX = 3211271;
    private static final int OP_POW = 3211272;
    private static final int OP_SQRT = 3211273;
    private static final int OP_ABS = 3211274;
    private static final int OP_SIGN = 3211275;
    private static final int OP_COPY_SIGN = 3211276;
    private static final int OP_EXP = 3211277;
    private static final int OP_FLOOR = 3211278;
    private static final int OP_LOG = 3211279;
    private static final int OP_LN = 0x310010;
    private static final int OP_ROUND = 0x310011;
    private static final int OP_SIN = 3211282;
    private static final int OP_COS = 0x310013;
    private static final int OP_TAN = 3211284;
    private static final int OP_ASIN = 3211285;
    private static final int OP_ACOS = 3211286;
    private static final int OP_ATAN = 3211287;
    private static final int OP_ATAN2 = 3211288;
    private static final int OP_MAD = 3211289;
    private static final int OP_TERNARY_CONDITIONAL = 3211290;
    private static final int OP_CLAMP = 3211291;
    private static final int OP_CBRT = 3211292;
    private static final int OP_DEG = 3211293;
    private static final int OP_RAD = 3211294;
    private static final int OP_CEIL = 3211295;
    private static final int OP_A_DEREF = 3211296;
    private static final int OP_A_MAX = 3211297;
    private static final int OP_A_MIN = 3211298;
    private static final int OP_A_SUM = 3211299;
    private static final int OP_A_AVG = 3211300;
    private static final int OP_A_LEN = 3211301;
    private static final int OP_A_SPLINE = 3211302;
    private static final int OP_RAND = 3211303;
    private static final int OP_RAND_SEED = 3211304;
    private static final int OP_NOISE_FROM = 3211305;
    private static final int OP_RAND_IN_RANGE = 3211306;
    private static final int OP_SQUARE_SUM = 3211307;
    private static final int OP_STEP = 3211308;
    private static final int OP_SQUARE = 3211309;
    private static final int OP_DUP = 3211310;
    private static final int OP_HYPOT = 3211311;
    private static final int OP_SWAP = 0x310030;
    private static final int OP_LERP = 0x310031;
    private static final int OP_SMOOTH_STEP = 3211314;
    private static final int OP_FIRST_VAR = 0x310033;
    private static final int OP_SECOND_VAR = 3211316;
    private static final int OP_THIRD_VAR = 3211317;

    private float getSplineValue(int arrayId, float pos) {
        MonotonicSpline fit = this.mSplineMap.get(arrayId);
        float[] f = this.mCollectionsAccess.getFloats(arrayId);
        if (fit != null && fit.getArray() == f) {
            return fit.getPos(pos);
        }
        fit = new MonotonicSpline(null, f);
        this.mSplineMap.put(arrayId, fit);
        return fit.getPos(pos);
    }

    public static boolean isMathOperator(float v) {
        if (Float.isNaN(v)) {
            int pos = AnimatedFloatExpression.fromNaN(v);
            if (NanMap.isDataVariable(v)) {
                return false;
            }
            return pos > 0x310000 && pos <= 3211314;
        }
        return false;
    }

    public float eval(@NonNull float[] exp, float ... var) {
        this.mStack = exp;
        this.mVar = var;
        int sp = -1;
        for (int i = 0; i < this.mStack.length; ++i) {
            float v = this.mStack[i];
            if (Float.isNaN(v)) {
                sp = this.opEval(sp, AnimatedFloatExpression.fromNaN(v));
                continue;
            }
            this.mStack[++sp] = v;
        }
        return this.mStack[sp];
    }

    public float eval(@NonNull CollectionsAccess ca, @NonNull float[] exp, int len, float ... var) {
        System.arraycopy(exp, 0, this.mLocalStack, 0, len);
        this.mStack = this.mLocalStack;
        this.mVar = var;
        this.mCollectionsAccess = ca;
        int sp = -1;
        for (int i = 0; i < this.mStack.length; ++i) {
            float v = this.mStack[i];
            if (Float.isNaN(v)) {
                int id2 = AnimatedFloatExpression.fromNaN(v);
                if ((id2 & 0x700000) != 0x200000) {
                    sp = this.opEval(sp, id2);
                    continue;
                }
                this.mStack[++sp] = v;
                continue;
            }
            this.mStack[++sp] = v;
        }
        return this.mStack[sp];
    }

    public float eval(@NonNull CollectionsAccess ca, @NonNull float[] exp, int len) {
        System.arraycopy(exp, 0, this.mLocalStack, 0, len);
        this.mStack = this.mLocalStack;
        this.mCollectionsAccess = ca;
        int sp = -1;
        for (int i = 0; i < len; ++i) {
            float v = this.mStack[i];
            if (Float.isNaN(v)) {
                int id2 = AnimatedFloatExpression.fromNaN(v);
                if ((id2 & 0x700000) != 0x200000) {
                    sp = this.opEval(sp, id2);
                    continue;
                }
                this.mStack[++sp] = v;
                continue;
            }
            this.mStack[++sp] = v;
        }
        return this.mStack[sp];
    }

    private int dereference(@NonNull CollectionsAccess ca, int id2, int sp) {
        this.mStack[sp] = ca.getFloatValue(id2, (int)this.mStack[sp]);
        return sp;
    }

    public float eval(@NonNull float[] exp, int len, float ... var) {
        System.arraycopy(exp, 0, this.mLocalStack, 0, len);
        this.mStack = this.mLocalStack;
        this.mVar = var;
        int sp = -1;
        for (int i = 0; i < len; ++i) {
            float v = this.mStack[i];
            if (Float.isNaN(v)) {
                sp = this.opEval(sp, AnimatedFloatExpression.fromNaN(v));
                continue;
            }
            this.mStack[++sp] = v;
        }
        return this.mStack[sp];
    }

    public float evalDB(@NonNull float[] exp, float ... var) {
        this.mStack = exp;
        this.mVar = var;
        int sp = -1;
        for (float v : exp) {
            if (Float.isNaN(v)) {
                sp = this.opEval(sp, AnimatedFloatExpression.fromNaN(v));
                continue;
            }
            System.out.print(" " + v);
            this.mStack[++sp] = v;
        }
        return this.mStack[sp];
    }

    @Nullable
    public static String toMathName(float f) {
        int id2 = AnimatedFloatExpression.fromNaN(f) - 0x310000;
        return sNames.get(id2);
    }

    @NonNull
    public static String toString(@NonNull float[] exp, @Nullable String[] labels) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < exp.length; ++i) {
            float v = exp[i];
            if (Float.isNaN(v)) {
                if (AnimatedFloatExpression.isMathOperator(v)) {
                    s.append(AnimatedFloatExpression.toMathName(v));
                } else {
                    int id2 = AnimatedFloatExpression.fromNaN(v);
                    String idString = id2 > 0x200000 ? "A_" + (id2 & 0xFFFFF) : "" + id2;
                    s.append("[");
                    s.append(idString);
                    s.append("]");
                }
            } else if (labels != null && labels[i] != null) {
                s.append(labels[i]);
                if (!labels[i].contains("_")) {
                    s.append(v);
                }
            } else {
                s.append(v);
            }
            s.append(" ");
        }
        return s.toString();
    }

    static String toString(@NonNull float[] exp, int sp) {
        if (Float.isNaN(exp[sp])) {
            int id2 = AnimatedFloatExpression.fromNaN(exp[sp]) - 0x310000;
            switch (NO_OF_OPS[id2]) {
                case -1: {
                    return "nop";
                }
                case 1: {
                    return sNames.get(id2) + "(" + AnimatedFloatExpression.toString(exp, sp + 1) + ") ";
                }
                case 2: {
                    if (AnimatedFloatExpression.infix(id2)) {
                        return "(" + AnimatedFloatExpression.toString(exp, sp + 1) + sNames.get(id2) + " " + AnimatedFloatExpression.toString(exp, sp + 2) + ") ";
                    }
                    return sNames.get(id2) + "(" + AnimatedFloatExpression.toString(exp, sp + 1) + ", " + AnimatedFloatExpression.toString(exp, sp + 2) + ")";
                }
                case 3: {
                    if (AnimatedFloatExpression.infix(id2)) {
                        return "((" + AnimatedFloatExpression.toString(exp, sp + 1) + ") ? " + AnimatedFloatExpression.toString(exp, sp + 2) + ":" + AnimatedFloatExpression.toString(exp, sp + 3) + ")";
                    }
                    return sNames.get(id2) + "(" + AnimatedFloatExpression.toString(exp, sp + 1) + ", " + AnimatedFloatExpression.toString(exp, sp + 2) + ", " + AnimatedFloatExpression.toString(exp, sp + 3) + ")";
                }
            }
        }
        return Float.toString(exp[sp]);
    }

    static boolean infix(int n) {
        return n < 6 || n == 25 || n == 26;
    }

    public static float asNan(int v) {
        return Float.intBitsToFloat(v | 0xFF800000);
    }

    public static int fromNaN(float v) {
        int b = Float.floatToRawIntBits(v);
        return b & 0x7FFFFF;
    }

    int opEval(int sp, int id2) {
        switch (id2) {
            case 0x310001: {
                this.mStack[sp - 1] = this.mStack[sp - 1] + this.mStack[sp];
                return sp - 1;
            }
            case 3211266: {
                this.mStack[sp - 1] = this.mStack[sp - 1] - this.mStack[sp];
                return sp - 1;
            }
            case 0x310003: {
                this.mStack[sp - 1] = this.mStack[sp - 1] * this.mStack[sp];
                return sp - 1;
            }
            case 3211268: {
                this.mStack[sp - 1] = this.mStack[sp - 1] / this.mStack[sp];
                return sp - 1;
            }
            case 3211269: {
                this.mStack[sp - 1] = this.mStack[sp - 1] % this.mStack[sp];
                return sp - 1;
            }
            case 3211270: {
                this.mStack[sp - 1] = Math.min(this.mStack[sp - 1], this.mStack[sp]);
                return sp - 1;
            }
            case 3211271: {
                this.mStack[sp - 1] = Math.max(this.mStack[sp - 1], this.mStack[sp]);
                return sp - 1;
            }
            case 3211272: {
                this.mStack[sp - 1] = (float)Math.pow(this.mStack[sp - 1], this.mStack[sp]);
                return sp - 1;
            }
            case 3211273: {
                this.mStack[sp] = (float)Math.sqrt(this.mStack[sp]);
                return sp;
            }
            case 3211274: {
                this.mStack[sp] = Math.abs(this.mStack[sp]);
                return sp;
            }
            case 3211275: {
                this.mStack[sp] = Math.signum(this.mStack[sp]);
                return sp;
            }
            case 3211276: {
                this.mStack[sp - 1] = Math.copySign(this.mStack[sp - 1], this.mStack[sp]);
                return sp - 1;
            }
            case 3211277: {
                this.mStack[sp] = (float)Math.exp(this.mStack[sp]);
                return sp;
            }
            case 3211278: {
                this.mStack[sp] = (float)Math.floor(this.mStack[sp]);
                return sp;
            }
            case 3211279: {
                this.mStack[sp] = (float)Math.log10(this.mStack[sp]);
                return sp;
            }
            case 0x310010: {
                this.mStack[sp] = (float)Math.log(this.mStack[sp]);
                return sp;
            }
            case 0x310011: {
                this.mStack[sp] = Math.round(this.mStack[sp]);
                return sp;
            }
            case 3211282: {
                this.mStack[sp] = (float)Math.sin(this.mStack[sp]);
                return sp;
            }
            case 0x310013: {
                this.mStack[sp] = (float)Math.cos(this.mStack[sp]);
                return sp;
            }
            case 3211284: {
                this.mStack[sp] = (float)Math.tan(this.mStack[sp]);
                return sp;
            }
            case 3211285: {
                this.mStack[sp] = (float)Math.asin(this.mStack[sp]);
                return sp;
            }
            case 3211286: {
                this.mStack[sp] = (float)Math.acos(this.mStack[sp]);
                return sp;
            }
            case 3211287: {
                this.mStack[sp] = (float)Math.atan(this.mStack[sp]);
                return sp;
            }
            case 3211288: {
                this.mStack[sp - 1] = (float)Math.atan2(this.mStack[sp - 1], this.mStack[sp]);
                return sp - 1;
            }
            case 3211289: {
                this.mStack[sp - 2] = this.mStack[sp] + this.mStack[sp - 1] * this.mStack[sp - 2];
                return sp - 2;
            }
            case 3211290: {
                this.mStack[sp - 2] = this.mStack[sp] > 0.0f ? this.mStack[sp - 1] : this.mStack[sp - 2];
                return sp - 2;
            }
            case 3211291: {
                this.mStack[sp - 2] = Math.min(Math.max(this.mStack[sp - 2], this.mStack[sp]), this.mStack[sp - 1]);
                return sp - 2;
            }
            case 3211292: {
                this.mStack[sp] = (float)Math.pow(this.mStack[sp], 0.3333333333333333);
                return sp;
            }
            case 3211293: {
                this.mStack[sp] = this.mStack[sp] * 57.29578f;
                return sp;
            }
            case 3211294: {
                this.mStack[sp] = this.mStack[sp] * ((float)Math.PI / 180);
                return sp;
            }
            case 3211295: {
                this.mStack[sp] = (float)Math.ceil(this.mStack[sp]);
                return sp;
            }
            case 3211296: {
                id2 = AnimatedFloatExpression.fromNaN(this.mStack[sp - 1]);
                this.mStack[sp - 1] = this.mCollectionsAccess.getFloatValue(id2, (int)this.mStack[sp]);
                return sp - 1;
            }
            case 3211297: {
                id2 = AnimatedFloatExpression.fromNaN(this.mStack[sp]);
                float[] array2 = this.mCollectionsAccess.getFloats(id2);
                float max = array2[0];
                for (int i = 1; i < array2.length; ++i) {
                    max = Math.max(max, array2[i]);
                }
                this.mStack[sp] = max;
                return sp;
            }
            case 3211298: {
                id2 = AnimatedFloatExpression.fromNaN(this.mStack[sp]);
                float[] array3 = this.mCollectionsAccess.getFloats(id2);
                if (array3.length == 0) {
                    return sp;
                }
                float min = array3[0];
                for (int i = 1; i < array3.length; ++i) {
                    min = Math.min(min, array3[i]);
                }
                this.mStack[sp] = min;
                return sp;
            }
            case 3211299: {
                id2 = AnimatedFloatExpression.fromNaN(this.mStack[sp]);
                float[] array4 = this.mCollectionsAccess.getFloats(id2);
                float sum = 0.0f;
                for (int i = 0; i < array4.length; ++i) {
                    sum += array4[i];
                }
                this.mStack[sp] = sum;
                return sp;
            }
            case 3211300: {
                id2 = AnimatedFloatExpression.fromNaN(this.mStack[sp]);
                float[] array5 = this.mCollectionsAccess.getFloats(id2);
                float sum = 0.0f;
                for (int i = 0; i < array5.length; ++i) {
                    sum += array5[i];
                }
                this.mStack[sp] = sum / (float)array5.length;
                return sp;
            }
            case 3211301: {
                id2 = AnimatedFloatExpression.fromNaN(this.mStack[sp]);
                this.mStack[sp] = this.mCollectionsAccess.getListLength(id2);
                return sp;
            }
            case 3211302: {
                id2 = AnimatedFloatExpression.fromNaN(this.mStack[sp - 1]);
                this.mStack[sp - 1] = this.getSplineValue(id2, this.mStack[sp]);
                return sp - 1;
            }
            case 3211303: {
                if (sRandom == null) {
                    sRandom = new Random();
                }
                this.mStack[sp + 1] = sRandom.nextFloat();
                return sp + 1;
            }
            case 3211304: {
                float seed = this.mStack[sp];
                if (seed == 0.0f) {
                    sRandom = new Random();
                } else if (sRandom == null) {
                    sRandom = new Random(Float.floatToRawIntBits(seed));
                } else {
                    sRandom.setSeed(Float.floatToRawIntBits(seed));
                }
                return sp - 1;
            }
            case 3211305: {
                int x = Float.floatToRawIntBits(this.mStack[sp]);
                x = x << 13 ^ x;
                this.mStack[sp] = 1.0f - (float)(x * (x * x * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.0737418E9f;
                return sp;
            }
            case 3211306: {
                if (sRandom == null) {
                    sRandom = new Random();
                }
                this.mStack[sp] = sRandom.nextFloat() * (this.mStack[sp] - this.mStack[sp - 1]) + this.mStack[sp - 1];
                return sp;
            }
            case 3211307: {
                this.mStack[sp - 1] = this.mStack[sp - 1] * this.mStack[sp - 1] + this.mStack[sp] * this.mStack[sp];
                return sp - 1;
            }
            case 3211308: {
                System.out.println(this.mStack[sp] + " > " + this.mStack[sp - 1]);
                this.mStack[sp - 1] = this.mStack[sp - 1] > this.mStack[sp] ? 1.0f : 0.0f;
                return sp - 1;
            }
            case 3211309: {
                this.mStack[sp] = this.mStack[sp] * this.mStack[sp];
                return sp;
            }
            case 3211310: {
                this.mStack[sp + 1] = this.mStack[sp];
                return sp + 1;
            }
            case 3211311: {
                this.mStack[sp - 1] = (float)Math.hypot(this.mStack[sp - 1], this.mStack[sp]);
                return sp - 1;
            }
            case 0x310030: {
                float swap = this.mStack[sp - 1];
                this.mStack[sp - 1] = this.mStack[sp];
                this.mStack[sp] = swap;
                return sp;
            }
            case 0x310031: {
                float tmp1 = this.mStack[sp - 2];
                float tmp2 = this.mStack[sp - 1];
                float tmp3 = this.mStack[sp];
                this.mStack[sp - 2] = tmp1 + (tmp2 - tmp1) * tmp3;
                return sp - 2;
            }
            case 3211314: {
                float val3 = this.mStack[sp - 2];
                float max2 = this.mStack[sp - 1];
                float min1 = this.mStack[sp];
                System.out.println("val3 = " + val3 + " min1 = " + min1 + " max2 = " + max2);
                if (val3 < min1) {
                    this.mStack[sp - 2] = 0.0f;
                    System.out.println("below min ");
                } else if (val3 > max2) {
                    this.mStack[sp - 2] = 1.0f;
                    System.out.println("above max ");
                } else {
                    float v = (val3 - min1) / (max2 - min1);
                    System.out.println("v = " + v);
                    this.mStack[sp - 2] = v * v * (3.0f - 2.0f * v);
                }
                return sp - 2;
            }
            case 0x310033: {
                this.mStack[sp] = this.mVar[0];
                return sp;
            }
            case 3211316: {
                this.mStack[sp] = this.mVar[1];
                return sp;
            }
            case 3211317: {
                this.mStack[sp] = this.mVar[2];
                return sp;
            }
        }
        return sp;
    }

    static {
        int k = 0;
        sNames.put(k++, "NOP");
        sNames.put(k++, "+");
        sNames.put(k++, "-");
        sNames.put(k++, "*");
        sNames.put(k++, "/");
        sNames.put(k++, "%");
        sNames.put(k++, "min");
        sNames.put(k++, "max");
        sNames.put(k++, "pow");
        sNames.put(k++, "sqrt");
        sNames.put(k++, "abs");
        sNames.put(k++, "sign");
        sNames.put(k++, "copySign");
        sNames.put(k++, "exp");
        sNames.put(k++, "floor");
        sNames.put(k++, "log");
        sNames.put(k++, "ln");
        sNames.put(k++, "round");
        sNames.put(k++, "sin");
        sNames.put(k++, "cos");
        sNames.put(k++, "tan");
        sNames.put(k++, "asin");
        sNames.put(k++, "acos");
        sNames.put(k++, "atan");
        sNames.put(k++, "atan2");
        sNames.put(k++, "mad");
        sNames.put(k++, "ifElse");
        sNames.put(k++, "clamp");
        sNames.put(k++, "cbrt");
        sNames.put(k++, "deg");
        sNames.put(k++, "rad");
        sNames.put(k++, "ceil");
        sNames.put(k++, "A_DEREF");
        sNames.put(k++, "A_MAX");
        sNames.put(k++, "A_MIN");
        sNames.put(k++, "A_SUM");
        sNames.put(k++, "A_AVG");
        sNames.put(k++, "A_LEN");
        sNames.put(k++, "A_SPLINE");
        sNames.put(k++, "RAND");
        sNames.put(k++, "RAND_SEED");
        sNames.put(k++, "noise_from");
        sNames.put(k++, "rand_in_range");
        sNames.put(k++, "square_sum");
        sNames.put(k++, "step");
        sNames.put(k++, "square");
        sNames.put(k++, "dup");
        sNames.put(k++, "hypot");
        sNames.put(k++, "swap");
        sNames.put(k++, "lerp");
        sNames.put(k++, "smooth_step");
        sNames.put(k++, "a[0]");
        sNames.put(k++, "a[1]");
        sNames.put(k++, "a[2]");
        NO_OF_OPS = new int[]{-1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 1, 1, 1, 1, 0, 0, 0};
    }

    static interface Op {
        public int eval(int var1);
    }
}

