/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DecoratorModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ShapeType;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class BorderModifierOperation
extends DecoratorModifierOperation {
    private static final int OP_CODE = 107;
    public static final String CLASS_NAME = "BorderModifierOperation";
    float mX;
    float mY;
    float mWidth;
    float mHeight;
    float mBorderWidth;
    float mRoundedCorner;
    float mR;
    float mG;
    float mB;
    float mA;
    int mShapeType = 0;
    @NonNull
    public PaintBundle paint = new PaintBundle();

    public BorderModifierOperation(float x, float y, float width, float height, float borderWidth, float roundedCorner, float r, float g, float b, float a, int shapeType) {
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
        this.mBorderWidth = borderWidth;
        this.mRoundedCorner = roundedCorner;
        this.mR = r;
        this.mG = g;
        this.mB = b;
        this.mA = a;
        this.mShapeType = shapeType;
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "BORDER = [" + this.mX + ", " + this.mY + ", " + this.mWidth + ", " + this.mHeight + "] color [" + this.mR + ", " + this.mG + ", " + this.mB + ", " + this.mA + "] border [" + this.mBorderWidth + ", " + this.mRoundedCorner + "] shape [" + this.mShapeType + "]");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        BorderModifierOperation.apply(buffer, this.mX, this.mY, this.mWidth, this.mHeight, this.mBorderWidth, this.mRoundedCorner, this.mR, this.mG, this.mB, this.mA, this.mShapeType);
    }

    @Override
    public void layout(@NonNull RemoteContext context, Component component, float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @NonNull
    public String toString() {
        return "BorderModifierOperation(" + this.mX + "," + this.mY + " - " + this.mWidth + " x " + this.mHeight + ") borderWidth(" + this.mBorderWidth + ") color(" + this.mR + "," + this.mG + "," + this.mB + "," + this.mA + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 107;
    }

    public static void apply(@NonNull WireBuffer buffer, float x, float y, float width, float height, float borderWidth, float roundedCorner, float r, float g, float b, float a, int shapeType) {
        buffer.start(107);
        buffer.writeFloat(x);
        buffer.writeFloat(y);
        buffer.writeFloat(width);
        buffer.writeFloat(height);
        buffer.writeFloat(borderWidth);
        buffer.writeFloat(roundedCorner);
        buffer.writeFloat(r);
        buffer.writeFloat(g);
        buffer.writeFloat(b);
        buffer.writeFloat(a);
        buffer.writeInt(shapeType);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        float width = buffer.readFloat();
        float height = buffer.readFloat();
        float bw = buffer.readFloat();
        float rc = buffer.readFloat();
        float r = buffer.readFloat();
        float g = buffer.readFloat();
        float b = buffer.readFloat();
        float a = buffer.readFloat();
        int shapeType = buffer.readInt();
        operations.add(new BorderModifierOperation(x, y, width, height, bw, rc, r, g, b, a, shapeType));
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.savePaint();
        this.paint.reset();
        this.paint.setColor(this.mR, this.mG, this.mB, this.mA);
        this.paint.setStrokeWidth(this.mBorderWidth * context.getContext().getDensity());
        this.paint.setStyle(1);
        context.replacePaint(this.paint);
        if (this.mShapeType == 0) {
            context.drawRect(0.0f, 0.0f, this.mWidth, this.mHeight);
        } else {
            float size = this.mRoundedCorner;
            if (this.mShapeType == 1) {
                size = Math.min(this.mWidth, this.mHeight) / 2.0f;
            }
            context.drawRoundRect(0.0f, 0.0f, this.mWidth, this.mHeight, size, size);
        }
        context.restorePaint();
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 107, CLASS_NAME).description("define the Border Modifier").field(1, "x", "").field(1, "y", "").field(1, "width", "").field(1, "height", "").field(1, "borderWidth", "").field(1, "roundedCorner", "").field(1, "r", "").field(1, "g", "").field(1, "b", "").field(1, "a", "").field(1, "shapeType", "");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("x", Float.valueOf(this.mX)).add("y", Float.valueOf(this.mY)).add("width", Float.valueOf(this.mWidth)).add("height", Float.valueOf(this.mHeight)).add("borderWidth", Float.valueOf(this.mBorderWidth)).add("roundedCornerRadius", Float.valueOf(this.mRoundedCorner)).add("color", this.mA, this.mR, this.mG, this.mB).add("shapeType", ShapeType.getString(this.mShapeType));
    }
}

