/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.LayoutManager;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Size;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.HeightInModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.HeightModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.WidthInModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.WidthModifierOperation;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class FitBoxLayout
extends LayoutManager {
    public static final int START = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    int mHorizontalPositioning;
    int mVerticalPositioning;

    public FitBoxLayout(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height, int horizontalPositioning, int verticalPositioning) {
        super(parent, componentId, animationId, x, y, width, height);
        this.mHorizontalPositioning = horizontalPositioning;
        this.mVerticalPositioning = verticalPositioning;
    }

    public FitBoxLayout(@Nullable Component parent, int componentId, int animationId, int horizontalPositioning, int verticalPositioning) {
        this(parent, componentId, animationId, 0.0f, 0.0f, 0.0f, 0.0f, horizontalPositioning, verticalPositioning);
    }

    @Override
    @NonNull
    public String toString() {
        return "BOX [" + this.mComponentId + ":" + this.mAnimationId + "] (" + this.mX + ", " + this.mY + " - " + this.mWidth + " x " + this.mHeight + ") " + this.mVisibility;
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "FITBOX";
    }

    @Override
    public void computeWrapSize(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @NonNull Size size) {
        boolean found = false;
        ComponentMeasure self = measure.get(this);
        for (Component c : this.mChildrenComponents) {
            float cw = 0.0f;
            float ch = 0.0f;
            if (c instanceof LayoutComponent) {
                HeightInModifierOperation heightIn;
                HeightModifierOperation heightModifier;
                WidthInModifierOperation widthIn;
                LayoutComponent lc = (LayoutComponent)c;
                WidthModifierOperation widthModifier = lc.getWidthModifier();
                if (widthModifier != null && (widthIn = lc.getWidthModifier().getWidthIn()) != null) {
                    cw = widthIn.getMin();
                }
                if ((heightModifier = lc.getHeightModifier()) != null && (heightIn = lc.getHeightModifier().getHeightIn()) != null) {
                    ch = heightIn.getMin();
                }
            }
            c.measure(context, 0.0f, maxWidth, 0.0f, maxHeight, measure);
            ComponentMeasure m = measure.get(c);
            if (!found && cw <= maxWidth && ch <= maxHeight) {
                found = true;
                m.addVisibilityOverride(32);
                size.setWidth(m.getW());
                size.setHeight(m.getH());
                continue;
            }
            m.addVisibilityOverride(16);
        }
        if (!found) {
            self.setVisibility(0);
        } else {
            self.setVisibility(1);
        }
    }

    @Override
    public void computeSize(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        ComponentMeasure self = measure.get(this);
        boolean found = false;
        for (Component c : this.mChildrenComponents) {
            float cw = 0.0f;
            float ch = 0.0f;
            if (c instanceof LayoutComponent) {
                HeightInModifierOperation heightIn;
                HeightModifierOperation heightModifier;
                WidthInModifierOperation widthIn;
                LayoutComponent lc = (LayoutComponent)c;
                WidthModifierOperation widthModifier = lc.getWidthModifier();
                if (widthModifier != null && (widthIn = lc.getWidthModifier().getWidthIn()) != null) {
                    cw = widthIn.getMin();
                }
                if ((heightModifier = lc.getHeightModifier()) != null && (heightIn = lc.getHeightModifier().getHeightIn()) != null) {
                    ch = heightIn.getMin();
                }
            }
            c.measure(context, minWidth, maxWidth, minHeight, maxHeight, measure);
            ComponentMeasure m = measure.get(c);
            m.clearVisibilityOverride();
            if (!found && cw <= maxWidth && ch <= maxHeight) {
                found = true;
                m.addVisibilityOverride(32);
                continue;
            }
            m.addVisibilityOverride(16);
        }
    }

    @Override
    public void internalLayoutMeasure(@NonNull PaintContext context, @NonNull MeasurePass measure) {
        ComponentMeasure selfMeasure = measure.get(this);
        float selfWidth = selfMeasure.getW() - this.mPaddingLeft - this.mPaddingRight;
        float selfHeight = selfMeasure.getH() - this.mPaddingTop - this.mPaddingBottom;
        this.applyVisibility(selfWidth, selfHeight, measure);
        for (Component child : this.mChildrenComponents) {
            ComponentMeasure m = measure.get(child);
            float tx = 0.0f;
            float ty = 0.0f;
            switch (this.mVerticalPositioning) {
                case 4: {
                    ty = 0.0f;
                    break;
                }
                case 2: {
                    ty = (selfHeight - m.getH()) / 2.0f;
                    break;
                }
                case 5: {
                    ty = selfHeight - m.getH();
                }
            }
            switch (this.mHorizontalPositioning) {
                case 1: {
                    tx = 0.0f;
                    break;
                }
                case 2: {
                    tx = (selfWidth - m.getW()) / 2.0f;
                    break;
                }
                case 3: {
                    tx = selfWidth - m.getW();
                }
            }
            m.setX(tx);
            m.setY(ty);
        }
    }

    @NonNull
    public static String name() {
        return "BoxLayout";
    }

    public static int id() {
        return 176;
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId, int animationId, int horizontalPositioning, int verticalPositioning) {
        buffer.start(FitBoxLayout.id());
        buffer.writeInt(componentId);
        buffer.writeInt(animationId);
        buffer.writeInt(horizontalPositioning);
        buffer.writeInt(verticalPositioning);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        int animationId = buffer.readInt();
        int horizontalPositioning = buffer.readInt();
        int verticalPositioning = buffer.readInt();
        operations.add(new FitBoxLayout(null, componentId, animationId, horizontalPositioning, verticalPositioning));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", FitBoxLayout.id(), FitBoxLayout.name()).description("FitBox layout implementation.\n\nOnly display the first child component that fits in the available space").examplesDimension(150, 100).exampleImage("Top", "layout-BoxLayout-start-top.png").exampleImage("Center", "layout-BoxLayout-center-center.png").exampleImage("Bottom", "layout-BoxLayout-end-bottom.png").field(0, "COMPONENT_ID", "unique id for this component").field(0, "ANIMATION_ID", "id used to match components, for animation purposes").field(0, "HORIZONTAL_POSITIONING", "horizontal positioning value").possibleValues("START", 1).possibleValues("CENTER", 2).possibleValues("END", 3).field(0, "VERTICAL_POSITIONING", "vertical positioning value").possibleValues("TOP", 4).possibleValues("CENTER", 2).possibleValues("BOTTOM", 5);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        FitBoxLayout.apply(buffer, this.mComponentId, this.mAnimationId, this.mHorizontalPositioning, this.mVerticalPositioning);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        super.serialize(serializer);
        serializer.add("verticalPositioning", this.getPositioningString(this.mVerticalPositioning));
        serializer.add("horizontalPositioning", this.getPositioningString(this.mHorizontalPositioning));
    }

    private String getPositioningString(int pos) {
        switch (pos) {
            case 1: {
                return "START";
            }
            case 2: {
                return "CENTER";
            }
            case 3: {
                return "END";
            }
            case 4: {
                return "TOP";
            }
            case 5: {
                return "BOTTOM";
            }
        }
        return "NONE";
    }
}

