/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.animation;

import android.annotation.NonNull;
import com.android.internal.lang.System_Delegate;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.DecoratorComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.animation.AnimationSpec;
import com.android.internal.widget.remotecompose.core.operations.layout.animation.ParticleAnimation;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.PaddingModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.FloatAnimation;

public class AnimateMeasure {
    private long mStartTime = System_Delegate.currentTimeMillis();
    @NonNull
    private final Component mComponent;
    @NonNull
    private final ComponentMeasure mOriginal;
    @NonNull
    private final ComponentMeasure mTarget;
    private float mDuration;
    private float mDurationVisibilityChange = this.mDuration;
    @NonNull
    private AnimationSpec.ANIMATION mEnterAnimation = AnimationSpec.ANIMATION.FADE_IN;
    @NonNull
    private AnimationSpec.ANIMATION mExitAnimation = AnimationSpec.ANIMATION.FADE_OUT;
    private int mMotionEasingType = 1;
    private int mVisibilityEasingType = 2;
    private float mP = 0.0f;
    private float mVp = 0.0f;
    @NonNull
    private FloatAnimation mMotionEasing = new FloatAnimation(this.mMotionEasingType, this.mDuration / 1000.0f, null, 0.0f, Float.NaN);
    @NonNull
    private FloatAnimation mVisibilityEasing = new FloatAnimation(this.mVisibilityEasingType, this.mDurationVisibilityChange / 1000.0f, null, 0.0f, Float.NaN);
    private ParticleAnimation mParticleAnimation;
    @NonNull
    public PaintBundle paint = new PaintBundle();

    public AnimateMeasure(long startTime, @NonNull Component component, @NonNull ComponentMeasure original, @NonNull ComponentMeasure target, float duration, float durationVisibilityChange, @NonNull AnimationSpec.ANIMATION enterAnimation, @NonNull AnimationSpec.ANIMATION exitAnimation, int motionEasingType, int visibilityEasingType) {
        this.mStartTime = startTime;
        this.mComponent = component;
        this.mOriginal = original;
        this.mTarget = target;
        this.mDuration = duration;
        this.mDurationVisibilityChange = durationVisibilityChange;
        this.mEnterAnimation = enterAnimation;
        this.mExitAnimation = exitAnimation;
        this.mMotionEasingType = motionEasingType;
        this.mVisibilityEasingType = visibilityEasingType;
        float motionDuration = this.mDuration / 1000.0f;
        float visibilityDuration = this.mDurationVisibilityChange / 1000.0f;
        this.mMotionEasing = new FloatAnimation(this.mMotionEasingType, motionDuration, null, 0.0f, Float.NaN);
        this.mVisibilityEasing = new FloatAnimation(this.mVisibilityEasingType, visibilityDuration, null, 0.0f, Float.NaN);
        this.mMotionEasing.setTargetValue(1.0f);
        this.mVisibilityEasing.setTargetValue(1.0f);
        component.mVisibility = target.getVisibility();
    }

    public void update(long currentTime) {
        long elapsed = currentTime - this.mStartTime;
        float motionProgress = (float)elapsed / this.mDuration;
        float visibilityProgress = (float)elapsed / this.mDurationVisibilityChange;
        this.mP = this.mMotionEasing.get(motionProgress);
        this.mVp = this.mVisibilityEasing.get(visibilityProgress);
    }

    public void apply(@NonNull RemoteContext context) {
        this.update(context.currentTime);
        this.mComponent.setX(this.getX());
        this.mComponent.setY(this.getY());
        this.mComponent.setWidth(this.getWidth());
        this.mComponent.setHeight(this.getHeight());
        this.mComponent.updateVariables(context);
        float w = this.mComponent.getWidth();
        float h = this.mComponent.getHeight();
        for (Operation op : this.mComponent.mList) {
            if (op instanceof PaddingModifierOperation) {
                PaddingModifierOperation pop = (PaddingModifierOperation)op;
                w -= pop.getLeft() + pop.getRight();
                h -= pop.getTop() + pop.getBottom();
            }
            if (!(op instanceof DecoratorComponent)) continue;
            ((DecoratorComponent)((Object)op)).layout(context, this.mComponent, w, h);
        }
    }

    public void paint(@NonNull PaintContext context) {
        if (this.mOriginal.getVisibility() != this.mTarget.getVisibility()) {
            if (this.mTarget.isGone()) {
                switch (this.mExitAnimation) {
                    case PARTICLE: {
                        if (this.mParticleAnimation == null) {
                            this.mParticleAnimation = new ParticleAnimation();
                        }
                        this.mParticleAnimation.animate(context, this.mComponent, this.mOriginal, this.mTarget, this.mVp);
                        break;
                    }
                    case FADE_OUT: {
                        context.save();
                        context.savePaint();
                        this.paint.reset();
                        this.paint.setColor(0.0f, 0.0f, 0.0f, 1.0f - this.mVp);
                        context.applyPaint(this.paint);
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restorePaint();
                        context.restore();
                        break;
                    }
                    case SLIDE_LEFT: {
                        context.save();
                        context.translate(-this.mVp * this.mComponent.getParent().getWidth(), 0.0f);
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restore();
                        break;
                    }
                    case SLIDE_RIGHT: {
                        context.save();
                        context.savePaint();
                        this.paint.reset();
                        this.paint.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                        context.applyPaint(this.paint);
                        context.translate(this.mVp * this.mComponent.getParent().getWidth(), 0.0f);
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restorePaint();
                        context.restore();
                        break;
                    }
                    case SLIDE_TOP: {
                        context.save();
                        context.translate(0.0f, -this.mVp * this.mComponent.getParent().getHeight());
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restore();
                        break;
                    }
                    case SLIDE_BOTTOM: {
                        context.save();
                        context.translate(0.0f, this.mVp * this.mComponent.getParent().getHeight());
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restore();
                        break;
                    }
                    default: {
                        if (this.mParticleAnimation == null) {
                            this.mParticleAnimation = new ParticleAnimation();
                        }
                        this.mParticleAnimation.animate(context, this.mComponent, this.mOriginal, this.mTarget, this.mVp);
                        break;
                    }
                }
            } else if (this.mOriginal.isGone() && this.mTarget.isVisible()) {
                switch (this.mEnterAnimation) {
                    case ROTATE: {
                        float px = this.mTarget.getX() + this.mTarget.getW() / 2.0f;
                        float py = this.mTarget.getY() + this.mTarget.getH() / 2.0f;
                        context.save();
                        context.savePaint();
                        context.matrixRotate(this.mVp * 360.0f, px, py);
                        context.matrixScale(1.0f * this.mVp, 1.0f * this.mVp, px, py);
                        this.paint.reset();
                        this.paint.setColor(0.0f, 0.0f, 0.0f, this.mVp);
                        context.applyPaint(this.paint);
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restorePaint();
                        context.restore();
                        break;
                    }
                    case FADE_IN: {
                        context.save();
                        context.savePaint();
                        this.paint.reset();
                        this.paint.setColor(0.0f, 0.0f, 0.0f, this.mVp);
                        context.applyPaint(this.paint);
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restorePaint();
                        context.restore();
                        break;
                    }
                    case SLIDE_LEFT: {
                        context.save();
                        context.translate((1.0f - this.mVp) * this.mComponent.getParent().getWidth(), 0.0f);
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restore();
                        break;
                    }
                    case SLIDE_RIGHT: {
                        context.save();
                        context.translate(-(1.0f - this.mVp) * this.mComponent.getParent().getWidth(), 0.0f);
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restore();
                        break;
                    }
                    case SLIDE_TOP: {
                        context.save();
                        context.translate(0.0f, (1.0f - this.mVp) * this.mComponent.getParent().getHeight());
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restore();
                        break;
                    }
                    case SLIDE_BOTTOM: {
                        context.save();
                        context.translate(0.0f, -(1.0f - this.mVp) * this.mComponent.getParent().getHeight());
                        context.saveLayer(this.mComponent.getX(), this.mComponent.getY(), this.mComponent.getWidth(), this.mComponent.getHeight());
                        this.mComponent.paintingComponent(context);
                        context.restore();
                        context.restore();
                        break;
                    }
                }
            } else {
                this.mComponent.paintingComponent(context);
            }
        } else if (this.mTarget.isVisible()) {
            this.mComponent.paintingComponent(context);
        }
        if (this.mP >= 1.0f && this.mVp >= 1.0f) {
            this.mComponent.mVisibility = this.mTarget.getVisibility();
        }
    }

    public boolean isDone() {
        return this.mP >= 1.0f && this.mVp >= 1.0f;
    }

    public float getX() {
        return this.mOriginal.getX() * (1.0f - this.mP) + this.mTarget.getX() * this.mP;
    }

    public float getY() {
        return this.mOriginal.getY() * (1.0f - this.mP) + this.mTarget.getY() * this.mP;
    }

    public float getWidth() {
        return this.mOriginal.getW() * (1.0f - this.mP) + this.mTarget.getW() * this.mP;
    }

    public float getHeight() {
        return this.mOriginal.getH() * (1.0f - this.mP) + this.mTarget.getH() * this.mP;
    }

    public float getVisibility() {
        if (this.mOriginal.getVisibility() == this.mTarget.getVisibility()) {
            return 1.0f;
        }
        if (this.mTarget.isVisible()) {
            return this.mVp;
        }
        return 1.0f - this.mVp;
    }

    public void updateTarget(@NonNull ComponentMeasure measure, long currentTime) {
        this.mOriginal.setX(this.getX());
        this.mOriginal.setY(this.getY());
        this.mOriginal.setW(this.getWidth());
        this.mOriginal.setH(this.getHeight());
        float targetX = this.mTarget.getX();
        float targetY = this.mTarget.getY();
        float targetW = this.mTarget.getW();
        float targetH = this.mTarget.getH();
        int targetVisibility = this.mTarget.getVisibility();
        if (targetX != measure.getX() || targetY != measure.getY() || targetW != measure.getW() || targetH != measure.getH() || targetVisibility != measure.getVisibility()) {
            this.mTarget.setX(measure.getX());
            this.mTarget.setY(measure.getY());
            this.mTarget.setW(measure.getW());
            this.mTarget.setH(measure.getH());
            this.mTarget.setVisibility(measure.getVisibility());
        }
    }
}

