/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import java.util.List;

public class LayoutComponentContent
extends Component {
    public LayoutComponentContent(int componentId, float x, float y, float width, float height, @Nullable Component parent, int animationId) {
        super(parent, componentId, animationId, x, y, width, height);
    }

    @NonNull
    public static String name() {
        return "LayoutContent";
    }

    public static int id() {
        return 201;
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "CONTENT";
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId) {
        buffer.start(201);
        buffer.writeInt(componentId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        operations.add(new LayoutComponentContent(componentId, 0.0f, 0.0f, 0.0f, 0.0f, null, -1));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", LayoutComponentContent.id(), LayoutComponentContent.name()).field(0, "COMPONENT_ID", "unique id for this component").description("Container for components. BoxLayout, RowLayout and ColumnLayout expects a LayoutComponentContent as a child, encapsulating the components that needs to be laid out.");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        LayoutComponentContent.apply(buffer, this.mComponentId);
    }
}

