/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringUtils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class TextFromFloat
extends Operation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 135;
    private static final String CLASS_NAME = "TextFromFloat";
    public int mTextId;
    public float mValue;
    public float mOutValue;
    public short mDigitsBefore;
    public short mDigitsAfter;
    public int mFlags;
    public static final int MAX_STRING_SIZE = 4000;
    char mPre = (char)32;
    char mAfter = (char)32;
    public static final int PAD_AFTER_SPACE = 0;
    public static final int PAD_AFTER_NONE = 1;
    public static final int PAD_AFTER_ZERO = 3;
    public static final int PAD_PRE_SPACE = 0;
    public static final int PAD_PRE_NONE = 4;
    public static final int PAD_PRE_ZERO = 12;

    public TextFromFloat(int textId, float value, short digitsBefore, short digitsAfter, int flags) {
        this.mTextId = textId;
        this.mValue = value;
        this.mDigitsAfter = digitsAfter;
        this.mDigitsBefore = digitsBefore;
        this.mFlags = flags;
        this.mOutValue = this.mValue;
        switch (this.mFlags & 3) {
            case 0: {
                this.mAfter = (char)32;
                break;
            }
            case 1: {
                this.mAfter = '\u0000';
                break;
            }
            case 3: {
                this.mAfter = (char)48;
            }
        }
        switch (this.mFlags & 0xC) {
            case 0: {
                this.mPre = (char)32;
                break;
            }
            case 4: {
                this.mPre = '\u0000';
                break;
            }
            case 12: {
                this.mPre = (char)48;
            }
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextFromFloat.apply(buffer, this.mTextId, this.mValue, this.mDigitsBefore, this.mDigitsAfter, this.mFlags);
    }

    @NonNull
    public String toString() {
        return "TextFromFloat[" + this.mTextId + "] = " + Utils.floatToString(this.mValue) + " " + this.mDigitsBefore + "." + this.mDigitsAfter + " " + this.mFlags;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mValue)) {
            this.mOutValue = context.getFloat(Utils.idFromNan(this.mValue));
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mValue)) {
            context.listensTo(Utils.idFromNan(this.mValue), this);
        }
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 135;
    }

    public static void apply(@NonNull WireBuffer buffer, int textId, float value, short digitsBefore, short digitsAfter, int flags) {
        buffer.start(135);
        buffer.writeInt(textId);
        buffer.writeFloat(value);
        buffer.writeInt(digitsBefore << 16 | digitsAfter);
        buffer.writeInt(flags);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int textId = buffer.readInt();
        float value = buffer.readFloat();
        int tmp = buffer.readInt();
        short post = (short)(tmp & 0xFFFF);
        short pre = (short)(tmp >> 16 & 0xFFFF);
        int flags = buffer.readInt();
        operations.add(new TextFromFloat(textId, value, pre, post, flags));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 135, CLASS_NAME).description("Draw text along path object").field(0, "textId", "id of the text generated").field(0, "value", "Value to add").field(9, "prePoint", "digits before the decimal point").field(9, "pstPoint", "digit after the decimal point").field(0, "flags", "options on padding");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        float v = this.mOutValue;
        String s = StringUtils.floatToString(v, this.mDigitsBefore, this.mDigitsAfter, this.mPre, this.mAfter);
        context.loadText(this.mTextId, s);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("textId", this.mTextId).add("value", this.mValue, this.mOutValue).add("digitsBefore", this.mDigitsBefore).add("digitsAfter", this.mDigitsAfter).add("flags", this.mFlags);
    }
}

