/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.ParticlesCreate;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.operations.utilities.AnimatedFloatExpression;
import com.android.internal.widget.remotecompose.core.operations.utilities.NanMap;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.ArrayList;
import java.util.List;

public class ParticlesLoop
extends PaintOperation
implements VariableSupport,
Container {
    private static final int OP_CODE = 163;
    private static final String CLASS_NAME = "ParticlesLoop";
    private final int mId;
    private final float[] mRestart;
    private final float[] mOutRestart;
    private final float[][] mEquations;
    private final float[][] mOutEquations;
    private int[] mVarId;
    private float[][] mParticles;
    private static final int MAX_FLOAT_ARRAY = 2000;
    private static final int MAX_EQU_LENGTH = 32;
    ParticlesCreate mParticlesSource;
    @NonNull
    private ArrayList<Operation> mList = new ArrayList();
    @NonNull
    AnimatedFloatExpression mExp = new AnimatedFloatExpression();

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }

    public ParticlesLoop(int id2, float[] restart, float[][] values) {
        this.mId = id2;
        this.mRestart = restart;
        if (restart != null) {
            this.mOutRestart = new float[restart.length];
            System.arraycopy(restart, 0, this.mOutRestart, 0, restart.length);
        } else {
            this.mOutRestart = null;
        }
        this.mEquations = values;
        this.mOutEquations = new float[values.length][];
        for (int i = 0; i < values.length; ++i) {
            this.mOutEquations[i] = new float[values[i].length];
            System.arraycopy(values[i], 0, this.mOutEquations[i], 0, values[i].length);
        }
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        int i;
        if (this.mOutRestart != null) {
            for (i = 0; i < this.mRestart.length; ++i) {
                float v = this.mRestart[i];
                this.mOutRestart[i] = Float.isNaN(v) && !AnimatedFloatExpression.isMathOperator(v) && !NanMap.isDataVariable(v) ? context.getFloat(Utils.idFromNan(v)) : v;
            }
        }
        for (i = 0; i < this.mEquations.length; ++i) {
            float[] mEquation = this.mEquations[i];
            for (int j = 0; j < mEquation.length; ++j) {
                float v = mEquation[j];
                this.mOutEquations[i][j] = Float.isNaN(v) && !AnimatedFloatExpression.isMathOperator(v) && !NanMap.isDataVariable(v) ? context.getFloat(Utils.idFromNan(v)) : v;
            }
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        int i;
        this.mParticlesSource = (ParticlesCreate)context.getObject(this.mId);
        this.mParticles = this.mParticlesSource.getParticles();
        this.mVarId = this.mParticlesSource.getVariableIds();
        if (this.mRestart != null) {
            for (i = 0; i < this.mRestart.length; ++i) {
                float v = this.mRestart[i];
                if (!Float.isNaN(v) || AnimatedFloatExpression.isMathOperator(v) || NanMap.isDataVariable(v)) continue;
                context.listensTo(Utils.idFromNan(v), this);
            }
        }
        for (i = 0; i < this.mEquations.length; ++i) {
            float[] mEquation;
            for (float v : mEquation = this.mEquations[i]) {
                if (!Float.isNaN(v) || AnimatedFloatExpression.isMathOperator(v) || NanMap.isDataVariable(v)) continue;
                context.listensTo(Utils.idFromNan(v), this);
            }
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ParticlesLoop.apply(buffer, this.mId, this.mRestart, this.mEquations);
    }

    @NonNull
    public String toString() {
        String str = "ParticlesLoop[" + Utils.idString(this.mId) + "] ";
        return str;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @Nullable float[] restart, @NonNull float[][] equations) {
        int i;
        buffer.start(163);
        buffer.writeInt(id2);
        if (restart != null) {
            buffer.writeInt(restart.length);
            for (i = 0; i < restart.length; ++i) {
                buffer.writeFloat(restart[i]);
            }
        } else {
            buffer.writeInt(0);
        }
        buffer.writeInt(equations.length);
        for (i = 0; i < equations.length; ++i) {
            buffer.writeInt(equations[i].length);
            for (int j = 0; j < equations[i].length; ++j) {
                buffer.writeFloat(equations[i][j]);
            }
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int varLen;
        int id2 = buffer.readInt();
        int restartLen = buffer.readInt();
        float[] restart = null;
        if (restartLen > 0) {
            restart = new float[restartLen];
            for (int i = 0; i < restartLen; ++i) {
                restart[i] = buffer.readFloat();
            }
        }
        if ((varLen = buffer.readInt()) > 2000) {
            throw new RuntimeException(varLen + " map entries more than max = " + 2000);
        }
        float[][] equations = new float[varLen][];
        for (int i = 0; i < varLen; ++i) {
            int equLen = buffer.readInt();
            if (equLen > 32) {
                throw new RuntimeException(equLen + " map entries more than max = " + 2000);
            }
            equations[i] = new float[equLen];
            for (int j = 0; j < equations[i].length; ++j) {
                equations[i][j] = buffer.readFloat();
            }
        }
        ParticlesLoop data = new ParticlesLoop(id2, restart, equations);
        operations.add(data);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 163, CLASS_NAME).description("This evolves the particles & recycles them").field(0, "id", "id of particle system").field(0, "recycleLen", "the number of floats in restart equeation if 0 no restart").field(10, "values", "recycleLen", "array of floats").field(0, "varLen", "the number of equations to follow").field(0, "equLen", "the number of equations to follow").field(10, "values", "equLen", "floats for the equation");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        RemoteContext remoteContext = context.getContext();
        for (int i = 0; i < this.mParticles.length; ++i) {
            int j;
            for (j = 0; j < this.mParticles[i].length; ++j) {
                remoteContext.loadFloat(this.mVarId[j], this.mParticles[i][j]);
                this.updateVariables(remoteContext);
            }
            for (j = 0; j < this.mParticles[i].length; ++j) {
                this.mParticles[i][j] = this.mExp.eval(this.mOutEquations[j], this.mOutEquations[j].length, new float[0]);
                remoteContext.loadFloat(this.mVarId[j], this.mParticles[i][j]);
            }
            if (this.mOutRestart != null) {
                for (int k = 0; k < this.mRestart.length; ++k) {
                    float v = this.mRestart[k];
                    this.mOutRestart[k] = Float.isNaN(v) && !AnimatedFloatExpression.isMathOperator(v) && !NanMap.isDataVariable(v) ? remoteContext.getFloat(Utils.idFromNan(v)) : v;
                }
                if (this.mExp.eval(this.mOutRestart, this.mOutRestart.length, new float[0]) > 0.0f) {
                    this.mParticlesSource.initializeParticle(i);
                }
            }
            for (Operation op : this.mList) {
                if (op instanceof VariableSupport) {
                    ((VariableSupport)((Object)op)).updateVariables(context.getContext());
                }
                remoteContext.incrementOpCount();
                op.apply(context.getContext());
            }
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId);
    }
}

