/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class NamedVariable
extends Operation
implements Serializable {
    private static final int OP_CODE = 137;
    private static final String CLASS_NAME = "NamedVariable";
    public final int mVarId;
    @NonNull
    public final String mVarName;
    public final int mVarType;
    public static final int MAX_STRING_SIZE = 4000;
    public static final int COLOR_TYPE = 2;
    public static final int FLOAT_TYPE = 1;
    public static final int STRING_TYPE = 0;
    public static final int IMAGE_TYPE = 3;
    public static final int INT_TYPE = 4;
    public static final int LONG_TYPE = 5;

    public NamedVariable(int varId, int varType, @NonNull String name) {
        this.mVarId = varId;
        this.mVarType = varType;
        this.mVarName = name;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        NamedVariable.apply(buffer, this.mVarId, this.mVarType, this.mVarName);
    }

    @NonNull
    public String toString() {
        return "VariableName[" + this.mVarId + "] = \"" + Utils.trimString(this.mVarName, 10) + "\" type=" + this.mVarType;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 137;
    }

    public static void apply(@NonNull WireBuffer buffer, int varId, int varType, @NonNull String text) {
        buffer.start(137);
        buffer.writeInt(varId);
        buffer.writeInt(varType);
        buffer.writeUTF8(text);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int varId = buffer.readInt();
        int varType = buffer.readInt();
        String text = buffer.readUTF8(4000);
        operations.add(new NamedVariable(varId, varType, text));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 137, CLASS_NAME).description("Add a string name for an ID").field(0, "varId", "id to label").field(0, "varType", "The type of variable").field(5, "name", "String");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.loadVariableName(this.mVarName, this.mVarId, this.mVarType);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("varId", this.mVarId).add("varName", this.mVarName).add("varType", this.typeToString());
    }

    private String typeToString() {
        switch (this.mVarType) {
            case 2: {
                return "COLOR_TYPE";
            }
            case 1: {
                return "FLOAT_TYPE";
            }
            case 0: {
                return "STRING_TYPE";
            }
            case 3: {
                return "IMAGE_TYPE";
            }
            case 4: {
                return "INT_TYPE";
            }
        }
        return "INVALID_TYPE";
    }
}

