/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase4;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class MatrixScale
extends DrawBase4 {
    private static final int OP_CODE = 126;
    private static final String CLASS_NAME = "MatrixScale";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase4.Maker m = MatrixScale::new;
        MatrixScale.read(m, buffer, operations);
    }

    public static int id() {
        return 126;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3, float v4) {
        MatrixScale.apply(buffer, v1, v2, v3, v4);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 126, CLASS_NAME).description("Scale the following draw commands").field(1, "scaleX", "The amount to scale in X").field(1, "scaleY", "The amount to scale in Y").field(1, "pivotX", "The x-coordinate for the pivot point").field(1, "pivotY", "The y-coordinate for the pivot point");
    }

    public MatrixScale(float scaleX, float scaleY, float centerX, float centerY) {
        super(scaleX, scaleY, centerX, centerY);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.matrixScale(this.mX1, this.mY1, this.mX2, this.mY2);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1, float x2, float y2) {
        MatrixScale.write(buffer, 126, x1, y1, x2, y2);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "scaleX", "scaleY", "pivotX", "pivotY").addType(CLASS_NAME);
    }
}

