/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntegerExpressionEvaluator;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.Arrays;
import java.util.List;

public class IntegerExpression
extends Operation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 144;
    private static final String CLASS_NAME = "IntegerExpression";
    public int mId;
    private int mMask;
    private int mPreMask;
    @NonNull
    public final int[] mSrcValue;
    @Nullable
    public int[] mPreCalcValue;
    private float mLastChange = Float.NaN;
    public static final int MAX_SIZE = 320;
    @NonNull
    IntegerExpressionEvaluator mExp = new IntegerExpressionEvaluator();

    public IntegerExpression(int id2, int mask, @NonNull int[] value) {
        this.mId = id2;
        this.mMask = mask;
        this.mSrcValue = value;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (this.mPreCalcValue == null || this.mPreCalcValue.length != this.mSrcValue.length) {
            this.mPreCalcValue = new int[this.mSrcValue.length];
        }
        this.mPreMask = this.mMask;
        for (int i = 0; i < this.mSrcValue.length; ++i) {
            if (IntegerExpression.isId(this.mMask, i, this.mSrcValue[i])) {
                this.mPreMask &= ~(1 << i);
                this.mPreCalcValue[i] = context.getInteger(this.mSrcValue[i]);
                continue;
            }
            this.mPreCalcValue[i] = this.mSrcValue[i];
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        for (int i = 0; i < this.mSrcValue.length; ++i) {
            if (!IntegerExpression.isId(this.mMask, i, this.mSrcValue[i])) continue;
            context.listensTo(this.mSrcValue[i], this);
        }
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        this.updateVariables(context);
        float t = context.getAnimationTime();
        if (Float.isNaN(this.mLastChange)) {
            this.mLastChange = t;
        }
        int v = this.mExp.eval(this.mPreMask, Arrays.copyOf(this.mPreCalcValue, this.mPreCalcValue.length), new int[0]);
        context.loadInteger(this.mId, v);
    }

    public int evaluate(@NonNull RemoteContext context) {
        this.updateVariables(context);
        float t = context.getAnimationTime();
        if (Float.isNaN(this.mLastChange)) {
            this.mLastChange = t;
        }
        return this.mExp.eval(this.mPreMask, Arrays.copyOf(this.mPreCalcValue, this.mPreCalcValue.length), new int[0]);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        IntegerExpression.apply(buffer, this.mId, this.mMask, this.mSrcValue);
    }

    @NonNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.mPreCalcValue == null) {
            return "";
        }
        for (int i = 0; i < this.mPreCalcValue.length; ++i) {
            if (i != 0) {
                s.append(" ");
            }
            if (IntegerExpressionEvaluator.isOperation(this.mMask, i)) {
                if (IntegerExpression.isId(this.mMask, i, this.mSrcValue[i])) {
                    s.append("[" + this.mSrcValue[i] + "]");
                    continue;
                }
                s.append(IntegerExpressionEvaluator.toMathName(this.mPreCalcValue[i]));
                continue;
            }
            s.append(this.mSrcValue[i]);
        }
        return "IntegerExpression[" + this.mId + "] = (" + s + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 144;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int mask, @NonNull int[] value) {
        buffer.start(144);
        buffer.writeInt(id2);
        buffer.writeInt(mask);
        buffer.writeInt(value.length);
        for (int opMask : value) {
            buffer.writeInt(opMask);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int mask = buffer.readInt();
        int len = buffer.readInt();
        if (len > 320) {
            throw new RuntimeException("buffer corrupt integer expression " + len);
        }
        int[] values = new int[len];
        for (int i = 0; i < values.length; ++i) {
            values[i] = buffer.readInt();
        }
        operations.add(new IntegerExpression(id2, mask, values));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 144, CLASS_NAME).description("Expression that computes an integer").field(0, "id", "id of integer").field(0, "mask", "bits representing operators or other id's").field(0, "length", "length of array").field(11, "values", "length", "Array of ints");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    public static boolean isId(int mask, int i, int value) {
        return (1 << i & mask) != 0 && value < 65536;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.EXPRESSION).addType(CLASS_NAME).add("id", this.mId).add("mask", this.mId).addIntExpressionSrc("srcValues", this.mSrcValue, this.mMask);
    }
}

