/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteComposeOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class Header
extends Operation
implements RemoteComposeOperation {
    private static final int OP_CODE = 0;
    private static final String CLASS_NAME = "Header";
    private static final int MAGIC_NUMBER = 76283904;
    int mMajorVersion;
    int mMinorVersion;
    int mPatchVersion;
    int mWidth = 256;
    int mHeight = 256;
    float mDensity = 3.0f;
    long mCapabilities = 0L;
    private IntMap<Object> mProperties;
    public static final short DOC_WIDTH = 5;
    public static final short DOC_HEIGHT = 6;
    public static final short DOC_DENSITY_AT_GENERATION = 7;
    public static final short DOC_DESIRED_FPS = 8;
    public static final short DOC_CONTENT_DESCRIPTION = 9;
    public static final short DOC_SOURCE = 11;
    public static final short DOC_DATA_UPDATE = 12;
    private static final short DATA_TYPE_INT = 0;
    private static final short DATA_TYPE_FLOAT = 1;
    private static final short DATA_TYPE_LONG = 2;
    private static final short DATA_TYPE_STRING = 3;
    private static final short[] KEYS = new short[]{5, 6, 7, 8, 9, 11, 12};
    private static final String[] KEY_NAMES = new String[]{"DOC_WIDTH", "DOC_HEIGHT", "DOC_DENSITY_AT_GENERATION", "DOC_DESIRED_FPS", "DOC_CONTENT_DESCRIPTION", "DOC_SOURCE"};

    public Object get(short property) {
        return this.mProperties.get(property);
    }

    public Header(int majorVersion, int minorVersion, int patchVersion, int width, int height, float density, long capabilities) {
        this.mMajorVersion = majorVersion;
        this.mMinorVersion = minorVersion;
        this.mPatchVersion = patchVersion;
        this.mWidth = width;
        this.mHeight = height;
        this.mDensity = density;
        this.mCapabilities = capabilities;
    }

    public Header(int majorVersion, int minorVersion, int patchVersion, IntMap<Object> properties) {
        this.mMajorVersion = majorVersion;
        this.mMinorVersion = minorVersion;
        this.mPatchVersion = patchVersion;
        if (properties != null) {
            this.mProperties = properties;
            this.mWidth = this.getInt(5, 256);
            this.mHeight = this.getInt(6, 256);
            this.mDensity = this.getFloat(7, 0.0f);
        }
    }

    private int getInt(int key, int defaultValue) {
        if (this.mProperties == null) {
            return defaultValue;
        }
        Integer value = (Integer)this.mProperties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private long getLong(int key, long defaultValue) {
        if (this.mProperties == null) {
            return defaultValue;
        }
        Long value = (Long)this.mProperties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private float getFloat(int key, float defaultValue) {
        if (this.mProperties == null) {
            return defaultValue;
        }
        Float value = (Float)this.mProperties.get(key);
        if (value != null) {
            return value.floatValue();
        }
        return defaultValue;
    }

    private String getString(int key, String defaultValue) {
        if (this.mProperties == null) {
            return defaultValue;
        }
        String value = (String)this.mProperties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        Header.apply(buffer, this.mWidth, this.mHeight, this.mDensity, this.mCapabilities);
    }

    @NonNull
    public String toString() {
        String prop = "";
        if (this.mProperties != null) {
            for (int i = 0; i < KEYS.length; ++i) {
                Object p = this.mProperties.get(KEYS[i]);
                if (p == null) continue;
                prop = prop + "\n  " + KEY_NAMES[i] + " " + p.toString();
            }
            return "HEADER v" + this.mMajorVersion + "." + this.mMinorVersion + "." + this.mPatchVersion + prop;
        }
        return "HEADER v" + this.mMajorVersion + "." + this.mMinorVersion + "." + this.mPatchVersion + ", " + this.mWidth + " x " + this.mHeight + " [" + this.mCapabilities + "]" + prop;
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.header(this.mMajorVersion, this.mMinorVersion, this.mPatchVersion, this.mWidth, this.mHeight, this.mCapabilities, this.mProperties);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return this.toString();
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 0;
    }

    public static void apply(@NonNull WireBuffer buffer, int width, int height, float density, long capabilities) {
        buffer.start(0);
        buffer.writeInt(1);
        buffer.writeInt(0);
        buffer.writeInt(0);
        buffer.writeInt(width);
        buffer.writeInt(height);
        buffer.writeLong(capabilities);
    }

    public static void apply(@NonNull WireBuffer buffer, short[] type, Object[] value) {
        buffer.start(0);
        buffer.writeInt(76283905);
        buffer.writeInt(0);
        buffer.writeInt(0);
        buffer.writeInt(type.length);
        Header.writeMap(buffer, type, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Header readDirect(InputStream is) throws IOException {
        try (DataInputStream stream = new DataInputStream(is);){
            byte type = stream.readByte();
            if (type != 0) {
                throw new IOException("Invalid header " + type + " != " + 0);
            }
            int majorVersion = stream.readInt();
            int minorVersion = stream.readInt();
            int patchVersion = stream.readInt();
            if (majorVersion < 65536) {
                int width = stream.readInt();
                int height = stream.readInt();
                float density = 1.0f;
                long capabilities = stream.readLong();
                Header header = new Header(majorVersion, minorVersion, patchVersion, width, height, density, capabilities);
                return header;
            }
            if ((majorVersion & 0xFFFF0000) != 76283904) {
                throw new IOException("Invalid header MAGIC_NUMBER " + (majorVersion & 0xFFFF0000) + " != " + 76283904);
            }
            majorVersion &= 0xFFFF;
            int len = stream.readInt();
            short[] types = new short[len];
            Object[] values = new Object[len];
            Header.readMap(stream, types, values);
            IntMap<Object> map = new IntMap<Object>();
            for (int i = 0; i < len; ++i) {
                map.put(types[i], values[i]);
            }
            Header header = new Header(majorVersion, minorVersion, patchVersion, map);
            return header;
        }
    }

    private static void readMap(DataInputStream stream, short[] types, Object[] values) throws IOException {
        block6: for (int i = 0; i < types.length; ++i) {
            short tag = stream.readShort();
            short itemLen = stream.readShort();
            int dataType = tag >> 10;
            types[i] = (short)(tag & 0x3F);
            switch (dataType) {
                case 0: {
                    values[i] = stream.readInt();
                    continue block6;
                }
                case 1: {
                    values[i] = Float.valueOf(stream.readFloat());
                    continue block6;
                }
                case 2: {
                    values[i] = stream.readLong();
                    continue block6;
                }
                case 3: {
                    int slen = stream.readInt();
                    byte[] data = new byte[slen];
                    stream.readFully(data);
                    values[i] = new String(data);
                }
            }
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int majorVersion = buffer.readInt();
        int minorVersion = buffer.readInt();
        int patchVersion = buffer.readInt();
        if (majorVersion < 65536) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            float density = 1.0f;
            long capabilities = buffer.readLong();
            Header header = new Header(majorVersion, minorVersion, patchVersion, width, height, density, capabilities);
            operations.add(header);
        } else {
            majorVersion &= 0xFFFF;
            int length = buffer.readInt();
            short[] types = new short[length];
            Object[] values = new Object[length];
            Header.readMap(buffer, types, values);
            IntMap<Object> map = new IntMap<Object>();
            for (int i = 0; i < length; ++i) {
                map.put(types[i], values[i]);
            }
            Header header = new Header(majorVersion, minorVersion, patchVersion, map);
            operations.add(header);
        }
    }

    private static void readMap(@NonNull WireBuffer buffer, short[] types, Object[] values) {
        block6: for (int i = 0; i < types.length; ++i) {
            short tag = (short)buffer.readShort();
            int itemLen = buffer.readShort();
            int dataType = tag >> 10;
            types[i] = (short)(tag & 0x3F);
            switch (dataType) {
                case 0: {
                    values[i] = buffer.readInt();
                    continue block6;
                }
                case 1: {
                    values[i] = Float.valueOf(buffer.readFloat());
                    continue block6;
                }
                case 2: {
                    values[i] = buffer.readLong();
                    continue block6;
                }
                case 3: {
                    values[i] = buffer.readUTF8();
                }
            }
        }
    }

    private static void writeMap(@NonNull WireBuffer buffer, short[] types, Object[] values) {
        for (int i = 0; i < types.length; ++i) {
            short tag = types[i];
            if (values[i] instanceof String) {
                tag = (short)(tag | 0xC00);
                buffer.writeShort(tag);
                String str = (String)values[i];
                byte[] data = str.getBytes();
                buffer.writeShort(data.length + 4);
                buffer.writeBuffer(data);
                continue;
            }
            if (values[i] instanceof Integer) {
                tag = (short)(tag | 0);
                buffer.writeShort(tag);
                buffer.writeShort(4);
                buffer.writeInt((Integer)values[i]);
                continue;
            }
            if (values[i] instanceof Float) {
                tag = (short)(tag | 0x400);
                buffer.writeShort(tag);
                buffer.writeShort(4);
                buffer.writeFloat(((Float)values[i]).floatValue());
                continue;
            }
            if (!(values[i] instanceof Long)) continue;
            tag = (short)(tag | 0x800);
            buffer.writeShort(tag);
            buffer.writeShort(8);
            buffer.writeLong((Long)values[i]);
        }
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Protocol Operations", 0, CLASS_NAME).description("Document metadata, containing the version, original size & density, capabilities mask").field(0, "MAJOR_VERSION", "Major version").field(0, "MINOR_VERSION", "Minor version").field(0, "PATCH_VERSION", "Patch version").field(0, "WIDTH", "Major version").field(0, "HEIGHT", "Major version").field(8, "CAPABILITIES", "Major version");
    }

    public void setVersion(CoreDocument document) {
        document.setUpdateDoc(this.getInt(12, 0) != 0);
        document.setVersion(this.mMajorVersion, this.mMinorVersion, this.mPatchVersion);
    }
}

