/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase6;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawArc
extends DrawBase6 {
    private static final int OP_CODE = 152;
    private static final String CLASS_NAME = "DrawArc";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase6.Maker m = DrawArc::new;
        DrawArc.read(m, buffer, operations);
    }

    public static int id() {
        return 152;
    }

    public static void apply(@NonNull WireBuffer buffer, float v1, float v2, float v3, float v4, float v5, float v6) {
        buffer.start(152);
        buffer.writeFloat(v1);
        buffer.writeFloat(v2);
        buffer.writeFloat(v3);
        buffer.writeFloat(v4);
        buffer.writeFloat(v5);
        buffer.writeFloat(v6);
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3, float v4, float v5, float v6) {
        DrawArc.apply(buffer, v1, v2, v3, v4, v5, v6);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 152, CLASS_NAME).description("Draw the specified arcwhich will be scaled to fit inside the specified oval").field(1, "left", "The left side of the Oval").field(1, "top", "The top of the Oval").field(1, "right", "The right side of the Oval").field(1, "bottom", "The bottom of the Oval").field(1, "startAngle", "Starting angle (in degrees) where the arc begins").field(1, "sweepAngle", "Sweep angle (in degrees) measured clockwise");
    }

    public DrawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        super(left, top, right, bottom, startAngle, sweepAngle);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawArc(this.mV1, this.mV2, this.mV3, this.mV4, this.mV5, this.mV6);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "left", "top", "right", "bottom", "startAngle", "sweepAngle").addType(CLASS_NAME);
    }
}

