/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.DataMap;
import com.android.internal.widget.remotecompose.core.types.BooleanConstant;
import com.android.internal.widget.remotecompose.core.types.LongConstant;
import java.util.List;

public class DataMapLookup
extends Operation {
    private static final int OP_CODE = 154;
    private static final String CLASS_NAME = "DataMapLookup";
    public int mId;
    public int mDataMapId;
    public int mStringId;

    public DataMapLookup(int id2, int dataMapId, int keyStringId) {
        this.mId = id2;
        this.mDataMapId = dataMapId;
        this.mStringId = keyStringId;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DataMapLookup.apply(buffer, this.mId, this.mDataMapId, this.mStringId);
    }

    @NonNull
    public String toString() {
        return "DataMapLookup[" + this.mId + "] = " + Utils.idString(this.mDataMapId) + " " + this.mStringId;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 154;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int dataMapId, int keyStringId) {
        buffer.start(154);
        buffer.writeInt(id2);
        buffer.writeInt(dataMapId);
        buffer.writeInt(keyStringId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int mapId = buffer.readInt();
        int stringId = buffer.readInt();
        operations.add(new DataMapLookup(id2, mapId, stringId));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 154, CLASS_NAME).description("Look up a value in a data map").field(0, "id", "id of float").field(0, "dataMapId", "32-bit float value").field(0, "stringId", "32-bit float value");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        String str = context.getText(this.mStringId);
        DataMap data = context.getDataMap(this.mDataMapId);
        int pos = data.getPos(str);
        byte type = data.getType(pos);
        int dataId = data.getId(pos);
        switch (type) {
            case 0: {
                context.loadText(this.mId, context.getText(dataId));
                break;
            }
            case 1: {
                context.loadInteger(this.mId, context.getInteger(dataId));
                break;
            }
            case 2: {
                context.loadFloat(this.mId, context.getFloat(dataId));
                break;
            }
            case 3: {
                LongConstant lc = (LongConstant)context.getObject(dataId);
                context.loadInteger(this.mId, (int)lc.getValue());
                break;
            }
            case 4: {
                BooleanConstant bc = (BooleanConstant)context.getObject(dataId);
                context.loadInteger(this.mId, bc.getValue() ? 1 : 0);
            }
        }
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }
}

