/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class ColorExpression
extends Operation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 134;
    private static final String CLASS_NAME = "ColorExpression";
    public int mId;
    int mMode;
    public int mColor1;
    public int mColor2;
    public float mTween = 0.0f;
    public float mHue = 0.0f;
    public float mSat = 0.0f;
    public float mValue = 0.0f;
    public float mOutHue = 0.0f;
    public float mOutSat = 0.0f;
    public float mOutValue = 0.0f;
    public int mAlpha = 255;
    private float mArgbAlpha = 0.0f;
    private float mArgbRed = 0.0f;
    private float mArgbGreen = 0.0f;
    private float mArgbBlue = 0.0f;
    private float mOutArgbAlpha = 0.0f;
    private float mOutArgbRed = 0.0f;
    private float mOutArgbGreen = 0.0f;
    private float mOutArgbBlue = 0.0f;
    public float mOutTween = 0.0f;
    public int mOutColor1;
    public int mOutColor2;
    public static final byte COLOR_COLOR_INTERPOLATE = 0;
    public static final byte ID_COLOR_INTERPOLATE = 1;
    public static final byte COLOR_ID_INTERPOLATE = 2;
    public static final byte ID_ID_INTERPOLATE = 3;
    public static final byte HSV_MODE = 4;
    public static final byte ARGB_MODE = 5;
    public static final byte IDARGB_MODE = 6;

    public ColorExpression(int id2, float hue, float sat, float value) {
        this.mMode = 4;
        this.mAlpha = 255;
        this.mOutHue = this.mHue = hue;
        this.mOutSat = this.mSat = sat;
        this.mOutValue = this.mValue = value;
        this.mColor1 = Float.floatToRawIntBits(hue);
        this.mColor2 = Float.floatToRawIntBits(sat);
        this.mTween = value;
    }

    public ColorExpression(int id2, byte mode, int alpha, float hue, float sat, float value) {
        if (mode != 4) {
            throw new RuntimeException("Invalid mode " + mode);
        }
        this.mId = id2;
        this.mMode = 4;
        this.mAlpha = alpha;
        this.mOutHue = this.mHue = hue;
        this.mOutSat = this.mSat = sat;
        this.mOutValue = this.mValue = value;
        this.mColor1 = Float.floatToRawIntBits(hue);
        this.mColor2 = Float.floatToRawIntBits(sat);
        this.mTween = value;
    }

    public ColorExpression(int id2, int mode, int color1, int color2, float tween) {
        this.mId = id2;
        this.mMode = mode & 0xFF;
        this.mAlpha = mode >> 16 & 0xFF;
        if (this.mMode == 4) {
            this.mOutHue = this.mHue = Float.intBitsToFloat(color1);
            this.mOutSat = this.mSat = Float.intBitsToFloat(color2);
            this.mOutValue = this.mValue = tween;
        }
        this.mColor1 = color1;
        this.mColor2 = color2;
        this.mTween = tween;
        this.mOutTween = tween;
        this.mOutColor1 = color1;
        this.mOutColor2 = color2;
    }

    public ColorExpression(int id2, byte mode, float alpha, float red, float green, float blue) {
        if (mode != 5) {
            throw new RuntimeException("Invalid mode " + mode);
        }
        this.mMode = 5;
        this.mId = id2;
        this.mOutArgbAlpha = this.mArgbAlpha = alpha;
        this.mOutArgbRed = this.mArgbRed = red;
        this.mOutArgbGreen = this.mArgbGreen = green;
        this.mOutArgbBlue = this.mArgbBlue = blue;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (this.mMode == 4) {
            if (Float.isNaN(this.mHue)) {
                this.mOutHue = context.getFloat(Utils.idFromNan(this.mHue));
            }
            if (Float.isNaN(this.mSat)) {
                this.mOutSat = context.getFloat(Utils.idFromNan(this.mSat));
            }
            if (Float.isNaN(this.mValue)) {
                this.mOutValue = context.getFloat(Utils.idFromNan(this.mValue));
            }
        }
        if (this.mMode == 5) {
            if (Float.isNaN(this.mArgbAlpha)) {
                this.mOutArgbAlpha = context.getFloat(Utils.idFromNan(this.mArgbAlpha));
            }
            if (Float.isNaN(this.mArgbRed)) {
                this.mOutArgbRed = context.getFloat(Utils.idFromNan(this.mArgbRed));
            }
            if (Float.isNaN(this.mArgbGreen)) {
                this.mOutArgbGreen = context.getFloat(Utils.idFromNan(this.mArgbGreen));
            }
            if (Float.isNaN(this.mArgbBlue)) {
                this.mOutArgbBlue = context.getFloat(Utils.idFromNan(this.mArgbBlue));
            }
        }
        if (Float.isNaN(this.mTween)) {
            this.mOutTween = context.getFloat(Utils.idFromNan(this.mTween));
        }
        if ((this.mMode & 1) == 1) {
            this.mOutColor1 = context.getColor(this.mColor1);
        }
        if ((this.mMode & 2) == 2) {
            this.mOutColor2 = context.getColor(this.mColor2);
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (this.mMode == 4) {
            if (Float.isNaN(this.mHue)) {
                context.listensTo(Utils.idFromNan(this.mHue), this);
            }
            if (Float.isNaN(this.mSat)) {
                context.listensTo(Utils.idFromNan(this.mSat), this);
            }
            if (Float.isNaN(this.mValue)) {
                context.listensTo(Utils.idFromNan(this.mValue), this);
            }
            return;
        }
        if (this.mMode == 5) {
            if (Float.isNaN(this.mArgbAlpha)) {
                context.listensTo(Utils.idFromNan(this.mArgbAlpha), this);
            }
            if (Float.isNaN(this.mArgbRed)) {
                context.listensTo(Utils.idFromNan(this.mArgbRed), this);
            }
            if (Float.isNaN(this.mArgbGreen)) {
                context.listensTo(Utils.idFromNan(this.mArgbGreen), this);
            }
            if (Float.isNaN(this.mArgbBlue)) {
                context.listensTo(Utils.idFromNan(this.mArgbBlue), this);
            }
            return;
        }
        if (Float.isNaN(this.mTween)) {
            context.listensTo(Utils.idFromNan(this.mTween), this);
        }
        if ((this.mMode & 1) == 1) {
            context.listensTo(this.mColor1, this);
        }
        if ((this.mMode & 2) == 2) {
            context.listensTo(this.mColor2, this);
        }
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        if (this.mMode == 4) {
            context.loadColor(this.mId, this.mAlpha << 24 | 0xFFFFFF & Utils.hsvToRgb(this.mOutHue, this.mOutSat, this.mOutValue));
            return;
        }
        if (this.mMode == 5) {
            context.loadColor(this.mId, Utils.toARGB(this.mOutArgbAlpha, this.mOutArgbRed, this.mOutArgbGreen, this.mOutArgbBlue));
            return;
        }
        if ((double)this.mOutTween == 0.0) {
            if ((this.mMode & 1) == 1) {
                this.mOutColor1 = context.getColor(this.mColor1);
            }
            context.loadColor(this.mId, this.mOutColor1);
        } else {
            if ((this.mMode & 1) == 1) {
                this.mOutColor1 = context.getColor(this.mColor1);
            }
            if ((this.mMode & 2) == 2) {
                this.mOutColor2 = context.getColor(this.mColor2);
            }
            context.loadColor(this.mId, Utils.interpolateColor(this.mOutColor1, this.mOutColor2, this.mOutTween));
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        switch (this.mMode) {
            case 5: {
                ColorExpression.apply(buffer, this.mId, this.mArgbAlpha, this.mArgbRed, this.mArgbGreen, this.mArgbBlue);
                break;
            }
            case 4: {
                this.mOutValue = this.mValue;
                this.mColor1 = Float.floatToRawIntBits(this.mHue);
                this.mColor2 = Float.floatToRawIntBits(this.mSat);
                int mode = this.mMode | this.mAlpha << 16;
                ColorExpression.apply(buffer, this.mId, mode, this.mColor1, this.mColor2, this.mTween);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ColorExpression.apply(buffer, this.mId, this.mMode, this.mColor1, this.mColor2, this.mTween);
                break;
            }
            default: {
                throw new RuntimeException("Invalid mode ");
            }
        }
    }

    @NonNull
    public String toString() {
        if (this.mMode == 4) {
            return "ColorExpression[" + this.mId + "] = hsv (" + Utils.floatToString(this.mHue) + ", " + Utils.floatToString(this.mSat) + ", " + Utils.floatToString(this.mValue) + ")";
        }
        Utils.log(" ColorExpression toString" + this.mId + " " + this.mMode);
        if (this.mMode == 5) {
            return "ColorExpression[" + this.mId + "] = rgb (" + Utils.floatToString(this.mArgbAlpha) + ", " + Utils.floatToString(this.mArgbRed) + ", " + Utils.floatToString(this.mArgbGreen) + ", " + Utils.floatToString(this.mArgbRed) + ")";
        }
        String c1 = (this.mMode & 1) == 1 ? "[" + this.mColor1 + "]" : Utils.colorInt(this.mColor1);
        String c2 = (this.mMode & 2) == 2 ? "[" + this.mColor2 + "]" : Utils.colorInt(this.mColor2);
        return "ColorExpression[" + this.mId + "] = tween(" + c1 + ", " + c2 + ", " + Utils.floatToString(this.mTween) + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 134;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int mode, int color1, int color2, float tween) {
        ColorExpression.apply(buffer, id2, mode, color1, color2, Float.floatToRawIntBits(tween));
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, float alpha, float red, float green, float blue) {
        int param1 = Float.isNaN(alpha) ? 6 : 5;
        int n = Float.isNaN(alpha) ? Utils.idFromNan(alpha) << 16 : (int)(alpha * 1024.0f) << 16;
        int param2 = Float.floatToRawIntBits(red);
        int param3 = Float.floatToRawIntBits(green);
        int param4 = Float.floatToRawIntBits(blue);
        ColorExpression.apply(buffer, id2, param1 |= n, param2, param3, param4);
    }

    private static void apply(@NonNull WireBuffer buffer, int id2, int param1, int param2, int param3, int param4) {
        buffer.start(134);
        buffer.writeInt(id2);
        buffer.writeInt(param1);
        buffer.writeInt(param2);
        buffer.writeInt(param3);
        buffer.writeInt(param4);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int param1 = buffer.readInt();
        int param2 = buffer.readInt();
        int param3 = buffer.readInt();
        int param4 = buffer.readInt();
        int mode = param1 & 0xFF;
        switch (mode) {
            case 6: {
                float alpha = Utils.asNan(param1 >> 16);
                float red = Float.intBitsToFloat(param2);
                float green = Float.intBitsToFloat(param3);
                float blue = Float.intBitsToFloat(param4);
                operations.add(new ColorExpression(id2, 5, alpha, red, green, blue));
                break;
            }
            case 5: {
                float alpha = (float)(param1 >> 16) / 1024.0f;
                float red = Float.intBitsToFloat(param2);
                float green = Float.intBitsToFloat(param3);
                float blue = Float.intBitsToFloat(param4);
                operations.add(new ColorExpression(id2, 5, alpha, red, green, blue));
                break;
            }
            case 4: {
                float alpha = (float)(param1 >> 16) / 1024.0f;
                float hue = Float.intBitsToFloat(param2);
                float sat = Float.intBitsToFloat(param3);
                float value = Float.intBitsToFloat(param4);
                operations.add(new ColorExpression(id2, 4, param1 >> 16, hue, sat, value));
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                operations.add(new ColorExpression(id2, mode, param2, param3, Float.intBitsToFloat(param4)));
                break;
            }
            default: {
                throw new RuntimeException("Invalid mode " + mode);
            }
        }
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 134, CLASS_NAME).description("A Color defined by an expression").field(0, "id", "Id of the color").field(0, "mode", "The use of the next 3 fields").possibleValues("COLOR_COLOR_INTERPOLATE", 0).possibleValues("COLOR_ID_INTERPOLATE", 1).possibleValues("ID_COLOR_INTERPOLATE", 2).possibleValues("ID_ID_INTERPOLATE", 3).possibleValues("HSV", 4).field(0, "color1", "32 bit ARGB color").field(0, "color2", "32 bit ARGB color").field(1, "tween", "32 bit ARGB color");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId);
        switch (this.mMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                serializer.add("mode", "TWEEN");
                serializer.add("startColor", this.mColor1, this.mOutColor1);
                serializer.add("endColor", this.mColor2, this.mOutColor2);
                serializer.add("startColor", this.mTween, this.mOutTween);
                break;
            }
            case 4: {
                serializer.add("mode", "HSV");
                serializer.add("hue", this.mHue, this.mOutHue);
                serializer.add("sat", this.mSat, this.mOutSat);
                serializer.add("val", this.mValue, this.mOutValue);
                break;
            }
            case 5: 
            case 6: {
                serializer.add("mode", "ARGB");
                serializer.add("a", this.mArgbAlpha, this.mOutArgbAlpha);
                serializer.add("r", this.mArgbRed, this.mOutArgbRed);
                serializer.add("g", this.mArgbGreen, this.mOutArgbGreen);
                serializer.add("b", this.mArgbBlue, this.mOutArgbBlue);
                break;
            }
            default: {
                serializer.add("mode", "NONE");
            }
        }
    }
}

