/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class ColorConstant
extends Operation
implements Serializable {
    private static final int OP_CODE = 138;
    private static final String CLASS_NAME = "ColorConstant";
    public int mColorId;
    public int mColor;

    public ColorConstant(int colorId, int color2) {
        this.mColorId = colorId;
        this.mColor = color2;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ColorConstant.apply(buffer, this.mColorId, this.mColor);
    }

    @NonNull
    public String toString() {
        return "ColorConstant[" + this.mColorId + "] = " + Utils.colorInt(this.mColor) + "";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 138;
    }

    public static void apply(@NonNull WireBuffer buffer, int colorId, int color2) {
        buffer.start(138);
        buffer.writeInt(colorId);
        buffer.writeInt(color2);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int colorId = buffer.readInt();
        int color2 = buffer.readInt();
        operations.add(new ColorConstant(colorId, color2));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 138, CLASS_NAME).description("Define a Color").field(0, "id", "Id of the color").field(0, "color", "32 bit ARGB color");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.loadColor(this.mColorId, this.mColor);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("color", Utils.colorInt(this.mColor)).add("colorId", this.mColorId);
    }
}

