/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class BitmapData
extends Operation
implements SerializableToString,
Serializable {
    private static final int OP_CODE = 101;
    private static final String CLASS_NAME = "BitmapData";
    public final int mImageId;
    int mImageWidth;
    int mImageHeight;
    short mType;
    short mEncoding;
    @NonNull
    byte[] mBitmap;
    public static final int MAX_IMAGE_DIMENSION = 8000;
    public static final short ENCODING_INLINE = 0;
    public static final short ENCODING_URL = 1;
    public static final short ENCODING_FILE = 2;
    public static final short TYPE_PNG_8888 = 0;
    public static final short TYPE_PNG = 1;
    public static final short TYPE_RAW8 = 2;
    public static final short TYPE_RAW8888 = 3;
    public static final short TYPE_PNG_ALPHA_8 = 4;

    public BitmapData(int imageId, int width, int height, @NonNull byte[] bitmap) {
        this.mImageId = imageId;
        this.mImageWidth = width;
        this.mImageHeight = height;
        this.mBitmap = bitmap;
    }

    public void update(BitmapData from) {
        this.mImageWidth = from.mImageWidth;
        this.mImageHeight = from.mImageHeight;
        this.mBitmap = from.mBitmap;
        this.mType = from.mType;
        this.mEncoding = from.mEncoding;
    }

    public int getWidth() {
        return this.mImageWidth;
    }

    public int getHeight() {
        return this.mImageHeight;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        BitmapData.apply(buffer, this.mImageId, this.mImageWidth, this.mImageHeight, this.mBitmap);
    }

    @NonNull
    public String toString() {
        return "BITMAP DATA " + this.mImageId;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 101;
    }

    public int getType() {
        return this.mType;
    }

    public static void apply(@NonNull WireBuffer buffer, int imageId, int width, int height, @NonNull byte[] bitmap) {
        buffer.start(101);
        buffer.writeInt(imageId);
        buffer.writeInt(width);
        buffer.writeInt(height);
        buffer.writeBuffer(bitmap);
    }

    public static void apply(@NonNull WireBuffer buffer, int imageId, short type, short width, short encoding, short height, @NonNull byte[] bitmap) {
        buffer.start(101);
        buffer.writeInt(imageId);
        int w = type << 16 | width;
        int h = encoding << 16 | height;
        buffer.writeInt(w);
        buffer.writeInt(h);
        buffer.writeBuffer(bitmap);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int encoding;
        int type;
        int imageId = buffer.readInt();
        int width = buffer.readInt();
        int height = buffer.readInt();
        if (width > 65535) {
            type = width >> 16;
            width &= 0xFFFF;
        } else {
            type = 0;
        }
        if (height > 65535) {
            encoding = height >> 16;
            height &= 0xFFFF;
        } else {
            encoding = 0;
        }
        if (width < 1 || height < 1 || height > 8000 || width > 8000) {
            throw new RuntimeException("Dimension of image is invalid " + width + "x" + height);
        }
        byte[] bitmap = buffer.readBuffer();
        BitmapData bitmapData = new BitmapData(imageId, width, height, bitmap);
        bitmapData.mType = (short)type;
        bitmapData.mEncoding = (short)encoding;
        operations.add(bitmapData);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 101, CLASS_NAME).description("Bitmap data").field(0, "id", "id of bitmap data").field(9, "type", "width of the image").field(9, "width", "width of the image").field(9, "encoding", "height of the image").field(0, "width", "width of the image").field(9, "height", "height of the image").field(11, "values", "length", "Array of ints");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.putObject(this.mImageId, this);
        context.loadBitmap(this.mImageId, this.mEncoding, this.mType, this.mImageWidth, this.mImageHeight, this.mBitmap);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "BitmapData id " + this.mImageId + " (" + this.mImageWidth + "x" + this.mImageHeight + ")");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("imageId", this.mImageId).add("imageWidth", this.mImageWidth).add("imageHeight", this.mImageHeight).add("imageType", this.getImageTypeString(this.mType)).add("encoding", this.getEncodingString(this.mEncoding));
    }

    private String getEncodingString(short encoding) {
        switch (encoding) {
            case 0: {
                return "ENCODING_INLINE";
            }
            case 1: {
                return "ENCODING_URL";
            }
            case 2: {
                return "ENCODING_FILE";
            }
        }
        return "ENCODING_INVALID";
    }

    private String getImageTypeString(short type) {
        switch (type) {
            case 0: {
                return "TYPE_PNG_8888";
            }
            case 1: {
                return "TYPE_PNG";
            }
            case 2: {
                return "TYPE_RAW8";
            }
            case 3: {
                return "TYPE_RAW8888";
            }
            case 4: {
                return "TYPE_PNG_ALPHA_8";
            }
        }
        return "TYPE_INVALID";
    }
}

