/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core;

import android.annotation.NonNull;
import java.util.Arrays;

public class WireBuffer {
    private static final int BUFFER_SIZE = 0x100000;
    int mMaxSize;
    @NonNull
    byte[] mBuffer;
    int mIndex = 0;
    int mStartingIndex = 0;
    int mSize = 0;

    public WireBuffer(int size) {
        this.mMaxSize = size;
        this.mBuffer = new byte[this.mMaxSize];
    }

    public WireBuffer() {
        this(0x100000);
    }

    private void resize(int need) {
        if (this.mSize + need >= this.mMaxSize) {
            this.mMaxSize = Math.max(this.mMaxSize * 2, this.mSize + need);
            this.mBuffer = Arrays.copyOf(this.mBuffer, this.mMaxSize);
        }
    }

    @NonNull
    public byte[] getBuffer() {
        return this.mBuffer;
    }

    public int getMax_size() {
        return this.mMaxSize;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getSize() {
        return this.mSize;
    }

    public void setIndex(int index) {
        this.mIndex = index;
    }

    public void start(int type) {
        this.mStartingIndex = this.mIndex;
        this.writeByte(type);
    }

    public void startWithSize(int type) {
        this.mStartingIndex = this.mIndex;
        this.writeByte(type);
        this.mIndex += 4;
    }

    public void endWithSize() {
        int size = this.mIndex - this.mStartingIndex;
        int currentIndex = this.mIndex;
        this.mIndex = this.mStartingIndex + 1;
        this.writeInt(size);
        this.mIndex = currentIndex;
    }

    public void reset(int expectedSize) {
        this.mIndex = 0;
        this.mStartingIndex = 0;
        this.mSize = 0;
        if (expectedSize >= this.mMaxSize) {
            this.resize(expectedSize);
        }
    }

    public int size() {
        return this.mSize;
    }

    public boolean available() {
        return this.mSize - this.mIndex > 0;
    }

    public int readOperationType() {
        return this.readByte();
    }

    public boolean readBoolean() {
        byte value = this.mBuffer[this.mIndex];
        ++this.mIndex;
        return value == 1;
    }

    public int readByte() {
        int value = 0xFF & this.mBuffer[this.mIndex];
        ++this.mIndex;
        return value;
    }

    public int readShort() {
        int v1 = (this.mBuffer[this.mIndex++] & 0xFF) << 8;
        int v2 = (this.mBuffer[this.mIndex++] & 0xFF) << 0;
        return v1 + v2;
    }

    public int peekInt() {
        int tmp = this.mIndex;
        int v1 = (this.mBuffer[tmp++] & 0xFF) << 24;
        int v2 = (this.mBuffer[tmp++] & 0xFF) << 16;
        int v3 = (this.mBuffer[tmp++] & 0xFF) << 8;
        int v4 = (this.mBuffer[tmp++] & 0xFF) << 0;
        return v1 + v2 + v3 + v4;
    }

    public int readInt() {
        int v1 = (this.mBuffer[this.mIndex++] & 0xFF) << 24;
        int v2 = (this.mBuffer[this.mIndex++] & 0xFF) << 16;
        int v3 = (this.mBuffer[this.mIndex++] & 0xFF) << 8;
        int v4 = (this.mBuffer[this.mIndex++] & 0xFF) << 0;
        return v1 + v2 + v3 + v4;
    }

    public long readLong() {
        long v1 = ((long)this.mBuffer[this.mIndex++] & 0xFFL) << 56;
        long v2 = ((long)this.mBuffer[this.mIndex++] & 0xFFL) << 48;
        long v3 = ((long)this.mBuffer[this.mIndex++] & 0xFFL) << 40;
        long v4 = ((long)this.mBuffer[this.mIndex++] & 0xFFL) << 32;
        long v5 = ((long)this.mBuffer[this.mIndex++] & 0xFFL) << 24;
        long v6 = ((long)this.mBuffer[this.mIndex++] & 0xFFL) << 16;
        long v7 = ((long)this.mBuffer[this.mIndex++] & 0xFFL) << 8;
        long v8 = ((long)this.mBuffer[this.mIndex++] & 0xFFL) << 0;
        return v1 + v2 + v3 + v4 + v5 + v6 + v7 + v8;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @NonNull
    public byte[] readBuffer() {
        int count = this.readInt();
        byte[] b = Arrays.copyOfRange(this.mBuffer, this.mIndex, this.mIndex + count);
        this.mIndex += count;
        return b;
    }

    @NonNull
    public byte[] readBuffer(int maxSize) {
        int count = this.readInt();
        if (count < 0 || count > maxSize) {
            throw new RuntimeException("attempt read a buff of invalid size 0 <= " + count + " > " + maxSize);
        }
        byte[] b = Arrays.copyOfRange(this.mBuffer, this.mIndex, this.mIndex + count);
        this.mIndex += count;
        return b;
    }

    @NonNull
    public String readUTF8() {
        byte[] stringBuffer = this.readBuffer();
        return new String(stringBuffer);
    }

    @NonNull
    public String readUTF8(int maxSize) {
        byte[] stringBuffer = this.readBuffer(maxSize);
        return new String(stringBuffer);
    }

    public void writeBoolean(boolean value) {
        this.resize(1);
        this.mBuffer[this.mIndex++] = (byte)(value ? 1 : 0);
        ++this.mSize;
    }

    public void writeByte(int value) {
        this.resize(1);
        this.mBuffer[this.mIndex++] = (byte)value;
        ++this.mSize;
    }

    public void writeShort(int value) {
        int need = 2;
        this.resize(need);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 8 & 0xFF);
        this.mBuffer[this.mIndex++] = (byte)(value & 0xFF);
        this.mSize += need;
    }

    public void writeInt(int value) {
        int need = 4;
        this.resize(need);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 24 & 0xFF);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 16 & 0xFF);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 8 & 0xFF);
        this.mBuffer[this.mIndex++] = (byte)(value & 0xFF);
        this.mSize += need;
    }

    public void writeLong(long value) {
        int need = 8;
        this.resize(need);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 56 & 0xFFL);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 48 & 0xFFL);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 40 & 0xFFL);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 32 & 0xFFL);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 24 & 0xFFL);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 16 & 0xFFL);
        this.mBuffer[this.mIndex++] = (byte)(value >>> 8 & 0xFFL);
        this.mBuffer[this.mIndex++] = (byte)(value & 0xFFL);
        this.mSize += need;
    }

    public void writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
    }

    public void writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
    }

    public void writeBuffer(@NonNull byte[] b) {
        this.resize(b.length + 4);
        this.writeInt(b.length);
        for (int i = 0; i < b.length; ++i) {
            this.mBuffer[this.mIndex++] = b[i];
        }
        this.mSize += b.length;
    }

    public void writeUTF8(@NonNull String content) {
        byte[] buffer = content.getBytes();
        this.writeBuffer(buffer);
    }
}

