/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Platform;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import java.util.HashMap;

public abstract class PaintContext {
    public static final int TEXT_MEASURE_MONOSPACE_WIDTH = 1;
    public static final int TEXT_MEASURE_FONT_HEIGHT = 2;
    public static final int TEXT_MEASURE_SPACES = 4;
    public static final int TEXT_COMPLEX = 8;
    @NonNull
    protected RemoteContext mContext;
    private boolean mNeedsRepaint = false;

    @NonNull
    public RemoteContext getContext() {
        return this.mContext;
    }

    public boolean doesNeedsRepaint() {
        return this.mNeedsRepaint;
    }

    public void clearNeedsRepaint() {
        this.mNeedsRepaint = false;
    }

    public PaintContext(@NonNull RemoteContext context) {
        this.mContext = context;
    }

    public void setContext(@NonNull RemoteContext context) {
        this.mContext = context;
    }

    public void save() {
        this.matrixSave();
    }

    public void restore() {
        this.matrixRestore();
    }

    public void saveLayer(float x, float y, float width, float height) {
        this.matrixSave();
    }

    public abstract void drawBitmap(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public abstract void scale(float var1, float var2);

    public abstract void translate(float var1, float var2);

    public abstract void drawArc(float var1, float var2, float var3, float var4, float var5, float var6);

    public abstract void drawSector(float var1, float var2, float var3, float var4, float var5, float var6);

    public abstract void drawBitmap(int var1, float var2, float var3, float var4, float var5);

    public abstract void drawCircle(float var1, float var2, float var3);

    public abstract void drawLine(float var1, float var2, float var3, float var4);

    public abstract void drawOval(float var1, float var2, float var3, float var4);

    public abstract void drawPath(int var1, float var2, float var3);

    public abstract void drawRect(float var1, float var2, float var3, float var4);

    public abstract void savePaint();

    public abstract void restorePaint();

    public abstract void replacePaint(PaintBundle var1);

    public abstract void drawRoundRect(float var1, float var2, float var3, float var4, float var5, float var6);

    public abstract void drawTextOnPath(int var1, int var2, float var3, float var4);

    public abstract void getTextBounds(int var1, int var2, int var3, int var4, @NonNull float[] var5);

    public abstract Platform.ComputedTextLayout layoutComplexText(int var1, int var2, int var3, int var4, int var5, int var6, float var7, int var8);

    public abstract void drawTextRun(int var1, int var2, int var3, int var4, int var5, float var6, float var7, boolean var8);

    public abstract void drawComplexText(Platform.ComputedTextLayout var1);

    public abstract void drawTweenPath(int var1, int var2, float var3, float var4, float var5);

    public abstract void tweenPath(int var1, int var2, int var3, float var4);

    public abstract void combinePath(int var1, int var2, int var3, byte var4);

    public abstract void applyPaint(@NonNull PaintBundle var1);

    public abstract void matrixScale(float var1, float var2, float var3, float var4);

    public abstract void matrixTranslate(float var1, float var2);

    public abstract void matrixSkew(float var1, float var2);

    public abstract void matrixRotate(float var1, float var2, float var3);

    public abstract void matrixSave();

    public abstract void matrixRestore();

    public abstract void clipRect(float var1, float var2, float var3, float var4);

    public abstract void clipPath(int var1, int var2);

    public abstract void roundedClipRect(float var1, float var2, float var3, float var4, float var5, float var6);

    public abstract void reset();

    public boolean isDebug() {
        return this.mContext.isDebug();
    }

    public boolean isAnimationEnabled() {
        return this.mContext.isAnimationEnabled();
    }

    public void log(@NonNull String content) {
        System.out.println("[LOG] " + content);
    }

    public void needsRepaint() {
        this.mNeedsRepaint = true;
    }

    public abstract void startGraphicsLayer(int var1, int var2);

    public abstract void setGraphicsLayer(@NonNull HashMap<Integer, Object> var1);

    public abstract void endGraphicsLayer();

    public boolean isVisualDebug() {
        return this.mContext.isVisualDebug();
    }

    @Nullable
    public abstract String getText(int var1);

    public boolean supportsVersion(int major, int minor, int patch) {
        return this.mContext.supportsVersion(major, minor, patch);
    }
}

