/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.Nullable;
import android.content.Context;
import android.os.Trace;
import android.os._Original_Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.PrecomputedText;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.widget.RemoteViews;
import android.widget.TextView;

@RemoteViews.RemoteView
public class ImageFloatingTextView
extends TextView {
    private int mIndentLines = 0;
    private boolean mHasImage = false;
    private int mResolvedDirection = -1;
    private int mMaxLinesForHeight = -1;
    private int mLayoutMaxLines = -1;
    private int mImageEndMargin;
    private final int mMaxLineUpperLimit;
    private int mStaticLayoutCreationCountInOnMeasure = 0;
    private static final boolean TRACE_ONMEASURE = _Original_Build.isDebuggable();

    public ImageFloatingTextView(Context context) {
        this(context, null);
    }

    public ImageFloatingTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageFloatingTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setHyphenationFrequency(4);
        this.setBreakStrategy(1);
        this.mMaxLineUpperLimit = this.getResources().getInteger(17694962);
    }

    @Override
    protected Layout makeSingleLayout(int wantWidth, BoringLayout.Metrics boring, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, boolean useSaved) {
        int maxLines;
        if (TRACE_ONMEASURE) {
            Trace.beginSection("ImageFloatingTextView#makeSingleLayout");
            ++this.mStaticLayoutCreationCountInOnMeasure;
        }
        TransformationMethod transformationMethod = this.getTransformationMethod();
        CharSequence text = this.getText();
        if (transformationMethod != null) {
            text = transformationMethod.getTransformation(text, this);
        }
        text = text == null ? "" : text;
        StaticLayout.Builder builder = StaticLayout.Builder.obtain(text, 0, text.length(), this.getPaint(), wantWidth).setAlignment(alignment).setTextDirection(this.getTextDirectionHeuristic()).setLineSpacing(this.getLineSpacingExtra(), this.getLineSpacingMultiplier()).setIncludePad(this.getIncludeFontPadding()).setUseLineSpacingFromFallbacks(true).setBreakStrategy(this.getBreakStrategy()).setHyphenationFrequency(this.getHyphenationFrequency());
        if (this.mMaxLinesForHeight > 0) {
            maxLines = this.mMaxLinesForHeight;
        } else {
            int n = maxLines = this.getMaxLines() >= 0 ? this.getMaxLines() : Integer.MAX_VALUE;
        }
        if (this.mMaxLineUpperLimit > 0) {
            maxLines = Math.min(maxLines, this.mMaxLineUpperLimit);
        }
        builder.setMaxLines(maxLines);
        this.mLayoutMaxLines = maxLines;
        if (shouldEllipsize) {
            builder.setEllipsize(effectiveEllipsize).setEllipsizedWidth(ellipsisWidth);
        }
        int[] margins = null;
        if (this.mHasImage && this.mIndentLines > 0) {
            margins = new int[this.mIndentLines + 1];
            for (int i = 0; i < this.mIndentLines; ++i) {
                margins[i] = this.mImageEndMargin;
            }
        }
        if (this.mResolvedDirection == 1) {
            builder.setIndents(margins, null);
        } else {
            builder.setIndents(null, margins);
        }
        StaticLayout result = builder.build();
        if (TRACE_ONMEASURE) {
            this.trackMaxLines();
            Trace.endSection();
        }
        return result;
    }

    @RemotableViewMethod
    public void setImageEndMargin(int imageEndMargin) {
        if (this.mImageEndMargin != imageEndMargin) {
            this.mImageEndMargin = imageEndMargin;
            this.invalidateTextIfIndenting();
        }
    }

    @RemotableViewMethod
    public void setImageEndMarginDp(float imageEndMarginDp) {
        this.setImageEndMargin((int)(imageEndMarginDp * this.getResources().getDisplayMetrics().density));
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (TRACE_ONMEASURE) {
            Trace.beginSection("ImageFloatingTextView#onMeasure");
        }
        this.mStaticLayoutCreationCountInOnMeasure = 0;
        int availableHeight = View.MeasureSpec.getSize(heightMeasureSpec) - this.mPaddingTop - this.mPaddingBottom;
        if (this.getLayout() != null && this.getLayout().getHeight() != availableHeight) {
            this.mMaxLinesForHeight = -1;
            this.nullLayouts();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Layout layout2 = this.getLayout();
        if (layout2.getHeight() > availableHeight) {
            int maxLines;
            for (maxLines = layout2.getLineCount(); maxLines > 1 && layout2.getLineBottom(maxLines - 1) > availableHeight; --maxLines) {
            }
            if (this.getMaxLines() > 0) {
                maxLines = Math.min(this.getMaxLines(), maxLines);
            }
            if (maxLines != this.mLayoutMaxLines) {
                this.mMaxLinesForHeight = maxLines;
                this.nullLayouts();
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
        if (TRACE_ONMEASURE) {
            this.trackParameters();
            Trace.endSection();
        }
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (layoutDirection != this.mResolvedDirection && this.isLayoutDirectionResolved()) {
            this.mResolvedDirection = layoutDirection;
            this.invalidateTextIfIndenting();
        }
    }

    private void invalidateTextIfIndenting() {
        if (this.mHasImage && this.mIndentLines > 0) {
            this.nullLayouts();
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setHasImage(boolean hasImage) {
        this.setHasImageAndNumIndentLines(hasImage, this.mIndentLines);
    }

    @RemotableViewMethod
    public void setNumIndentLines(int lines) {
        this.setHasImageAndNumIndentLines(this.mHasImage, lines);
    }

    private void setHasImageAndNumIndentLines(boolean hasImage, int lines) {
        int oldEffectiveLines = this.mHasImage ? this.mIndentLines : 0;
        int newEffectiveLines = hasImage ? lines : 0;
        this.mIndentLines = lines;
        this.mHasImage = hasImage;
        if (oldEffectiveLines != newEffectiveLines) {
            this.nullLayouts();
            this.requestLayout();
        }
    }

    private void trackParameters() {
        if (!TRACE_ONMEASURE) {
            return;
        }
        Trace.setCounter("ImageFloatingView#staticLayoutCreationCount", this.mStaticLayoutCreationCountInOnMeasure);
        Trace.setCounter("ImageFloatingView#isPrecomputedText", this.isTextAPrecomputedText());
    }

    private int isTextAPrecomputedText() {
        CharSequence text = this.getText();
        if (text == null) {
            return 0;
        }
        if (text instanceof PrecomputedText) {
            return 1;
        }
        return 0;
    }

    private void trackMaxLines() {
        if (!TRACE_ONMEASURE) {
            return;
        }
        Trace.setCounter("ImageFloatingView#layoutMaxLines", this.mLayoutMaxLines);
    }
}

