/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.annotation.EnforcePermission;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.window.ImeOnBackInvokedDispatcher;
import com.android.internal.inputmethod.IBooleanListener;
import com.android.internal.inputmethod.IConnectionlessHandwritingCallback;
import com.android.internal.inputmethod.IImeTracker;
import com.android.internal.inputmethod.IInputMethodClient;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.inputmethod.InputBindResult;
import com.android.internal.inputmethod.InputMethodInfoSafeList;
import java.util.ArrayList;
import java.util.List;

public interface IInputMethodManager
extends IInterface {
    public void addClient(IInputMethodClient var1, IRemoteInputConnection var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public InputMethodInfo getCurrentInputMethodInfoAsUser(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public InputMethodInfoSafeList getInputMethodList(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public InputMethodInfoSafeList getEnabledInputMethodList(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public List<InputMethodInfo> getInputMethodListLegacy(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public List<InputMethodInfo> getEnabledInputMethodListLegacy(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String var1, boolean var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public InputMethodSubtype getLastInputMethodSubtype(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    @EnforcePermission(value="android.permission.TEST_INPUT_METHOD")
    public void hideSoftInputFromServerForTest() throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public InputBindResult startInputOrWindowGainedFocus(int var1, IInputMethodClient var2, IBinder var3, int var4, int var5, int var6, EditorInfo var7, IRemoteInputConnection var8, IRemoteAccessibilityInputConnection var9, int var10, int var11, ImeOnBackInvokedDispatcher var12, boolean var13) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public void startInputOrWindowGainedFocusAsync(int var1, IInputMethodClient var2, IBinder var3, int var4, int var5, int var6, EditorInfo var7, IRemoteInputConnection var8, IRemoteAccessibilityInputConnection var9, int var10, int var11, ImeOnBackInvokedDispatcher var12, boolean var13, int var14, boolean var15) throws RemoteException;

    public void showInputMethodPickerFromClient(IInputMethodClient var1, int var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.WRITE_SECURE_SETTINGS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    @EnforcePermission(allOf={"android.permission.WRITE_SECURE_SETTINGS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void showInputMethodPickerFromSystem(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    @EnforcePermission(value="android.permission.TEST_INPUT_METHOD")
    public boolean isInputMethodPickerShownForTest() throws RemoteException;

    @RequiresPermission(allOf={"android.permission.WRITE_SECURE_SETTINGS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    @EnforcePermission(allOf={"android.permission.WRITE_SECURE_SETTINGS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void onImeSwitchButtonClickFromSystem(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    @EnforcePermission(value="android.permission.TEST_INPUT_METHOD")
    public boolean shouldShowImeSwitcherButtonForTest() throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public InputMethodSubtype getCurrentInputMethodSubtype(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public void setAdditionalInputMethodSubtypes(String var1, InputMethodSubtype[] var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public void setExplicitlyEnabledInputMethodSubtypes(String var1, int[] var2, int var3) throws RemoteException;

    public int getInputMethodWindowVisibleHeight(IInputMethodClient var1) throws RemoteException;

    public void reportPerceptibleAsync(IBinder var1, boolean var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.INTERNAL_SYSTEM_WINDOW", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    @EnforcePermission(allOf={"android.permission.INTERNAL_SYSTEM_WINDOW", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void removeImeSurface(int var1) throws RemoteException;

    public void removeImeSurfaceFromWindowAsync(IBinder var1) throws RemoteException;

    @RequiresNoPermission
    public void startProtoDump(byte[] var1, int var2, String var3) throws RemoteException;

    @RequiresNoPermission
    public boolean isImeTraceEnabled() throws RemoteException;

    @RequiresPermission(value="android.permission.CONTROL_UI_TRACING")
    @EnforcePermission(value="android.permission.CONTROL_UI_TRACING")
    public void startImeTrace() throws RemoteException;

    @RequiresPermission(value="android.permission.CONTROL_UI_TRACING")
    @EnforcePermission(value="android.permission.CONTROL_UI_TRACING")
    public void stopImeTrace() throws RemoteException;

    public void startStylusHandwriting(IInputMethodClient var1) throws RemoteException;

    public void startConnectionlessStylusHandwriting(IInputMethodClient var1, int var2, CursorAnchorInfo var3, String var4, String var5, IConnectionlessHandwritingCallback var6) throws RemoteException;

    public void prepareStylusHandwritingDelegation(IInputMethodClient var1, int var2, String var3, String var4) throws RemoteException;

    public boolean acceptStylusHandwritingDelegation(IInputMethodClient var1, int var2, String var3, String var4, int var5) throws RemoteException;

    public void acceptStylusHandwritingDelegationAsync(IInputMethodClient var1, int var2, String var3, String var4, int var5, IBooleanListener var6) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public boolean isStylusHandwritingAvailableAsUser(int var1, boolean var2) throws RemoteException;

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    @EnforcePermission(value="android.permission.TEST_INPUT_METHOD")
    public void addVirtualStylusIdForTestSession(IInputMethodClient var1) throws RemoteException;

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    @EnforcePermission(value="android.permission.TEST_INPUT_METHOD")
    public void setStylusWindowIdleTimeoutForTest(IInputMethodClient var1, long var2) throws RemoteException;

    public IImeTracker getImeTrackerService() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "com.android.internal.view.IInputMethodManager";
        static final int TRANSACTION_addClient = 1;
        static final int TRANSACTION_getCurrentInputMethodInfoAsUser = 2;
        static final int TRANSACTION_getInputMethodList = 3;
        static final int TRANSACTION_getEnabledInputMethodList = 4;
        static final int TRANSACTION_getInputMethodListLegacy = 5;
        static final int TRANSACTION_getEnabledInputMethodListLegacy = 6;
        static final int TRANSACTION_getEnabledInputMethodSubtypeList = 7;
        static final int TRANSACTION_getLastInputMethodSubtype = 8;
        static final int TRANSACTION_hideSoftInputFromServerForTest = 9;
        static final int TRANSACTION_startInputOrWindowGainedFocus = 10;
        static final int TRANSACTION_startInputOrWindowGainedFocusAsync = 11;
        static final int TRANSACTION_showInputMethodPickerFromClient = 12;
        static final int TRANSACTION_showInputMethodPickerFromSystem = 13;
        static final String[] PERMISSIONS_showInputMethodPickerFromSystem = new String[]{"android.permission.WRITE_SECURE_SETTINGS", "android.permission.INTERACT_ACROSS_USERS_FULL"};
        static final int TRANSACTION_isInputMethodPickerShownForTest = 14;
        static final int TRANSACTION_onImeSwitchButtonClickFromSystem = 15;
        static final String[] PERMISSIONS_onImeSwitchButtonClickFromSystem = new String[]{"android.permission.WRITE_SECURE_SETTINGS", "android.permission.INTERACT_ACROSS_USERS_FULL"};
        static final int TRANSACTION_shouldShowImeSwitcherButtonForTest = 16;
        static final int TRANSACTION_getCurrentInputMethodSubtype = 17;
        static final int TRANSACTION_setAdditionalInputMethodSubtypes = 18;
        static final int TRANSACTION_setExplicitlyEnabledInputMethodSubtypes = 19;
        static final int TRANSACTION_getInputMethodWindowVisibleHeight = 20;
        static final int TRANSACTION_reportPerceptibleAsync = 21;
        static final int TRANSACTION_removeImeSurface = 22;
        static final String[] PERMISSIONS_removeImeSurface = new String[]{"android.permission.INTERNAL_SYSTEM_WINDOW", "android.permission.INTERACT_ACROSS_USERS_FULL"};
        static final int TRANSACTION_removeImeSurfaceFromWindowAsync = 23;
        static final int TRANSACTION_startProtoDump = 24;
        static final int TRANSACTION_isImeTraceEnabled = 25;
        static final int TRANSACTION_startImeTrace = 26;
        static final int TRANSACTION_stopImeTrace = 27;
        static final int TRANSACTION_startStylusHandwriting = 28;
        static final int TRANSACTION_startConnectionlessStylusHandwriting = 29;
        static final int TRANSACTION_prepareStylusHandwritingDelegation = 30;
        static final int TRANSACTION_acceptStylusHandwritingDelegation = 31;
        static final int TRANSACTION_acceptStylusHandwritingDelegationAsync = 32;
        static final int TRANSACTION_isStylusHandwritingAvailableAsUser = 33;
        static final int TRANSACTION_addVirtualStylusIdForTestSession = 34;
        static final int TRANSACTION_setStylusWindowIdleTimeoutForTest = 35;
        static final int TRANSACTION_getImeTrackerService = 36;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IInputMethodManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethodManager) {
                return (IInputMethodManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addClient";
                }
                case 2: {
                    return "getCurrentInputMethodInfoAsUser";
                }
                case 3: {
                    return "getInputMethodList";
                }
                case 4: {
                    return "getEnabledInputMethodList";
                }
                case 5: {
                    return "getInputMethodListLegacy";
                }
                case 6: {
                    return "getEnabledInputMethodListLegacy";
                }
                case 7: {
                    return "getEnabledInputMethodSubtypeList";
                }
                case 8: {
                    return "getLastInputMethodSubtype";
                }
                case 9: {
                    return "hideSoftInputFromServerForTest";
                }
                case 10: {
                    return "startInputOrWindowGainedFocus";
                }
                case 11: {
                    return "startInputOrWindowGainedFocusAsync";
                }
                case 12: {
                    return "showInputMethodPickerFromClient";
                }
                case 13: {
                    return "showInputMethodPickerFromSystem";
                }
                case 14: {
                    return "isInputMethodPickerShownForTest";
                }
                case 15: {
                    return "onImeSwitchButtonClickFromSystem";
                }
                case 16: {
                    return "shouldShowImeSwitcherButtonForTest";
                }
                case 17: {
                    return "getCurrentInputMethodSubtype";
                }
                case 18: {
                    return "setAdditionalInputMethodSubtypes";
                }
                case 19: {
                    return "setExplicitlyEnabledInputMethodSubtypes";
                }
                case 20: {
                    return "getInputMethodWindowVisibleHeight";
                }
                case 21: {
                    return "reportPerceptibleAsync";
                }
                case 22: {
                    return "removeImeSurface";
                }
                case 23: {
                    return "removeImeSurfaceFromWindowAsync";
                }
                case 24: {
                    return "startProtoDump";
                }
                case 25: {
                    return "isImeTraceEnabled";
                }
                case 26: {
                    return "startImeTrace";
                }
                case 27: {
                    return "stopImeTrace";
                }
                case 28: {
                    return "startStylusHandwriting";
                }
                case 29: {
                    return "startConnectionlessStylusHandwriting";
                }
                case 30: {
                    return "prepareStylusHandwritingDelegation";
                }
                case 31: {
                    return "acceptStylusHandwritingDelegation";
                }
                case 32: {
                    return "acceptStylusHandwritingDelegationAsync";
                }
                case 33: {
                    return "isStylusHandwritingAvailableAsUser";
                }
                case 34: {
                    return "addVirtualStylusIdForTestSession";
                }
                case 35: {
                    return "setStylusWindowIdleTimeoutForTest";
                }
                case 36: {
                    return "getImeTrackerService";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    IRemoteInputConnection _arg1 = IRemoteInputConnection.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addClient(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    InputMethodInfo _result = this.getCurrentInputMethodInfoAsUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    InputMethodInfoSafeList _result = this.getInputMethodList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    InputMethodInfoSafeList _result = this.getEnabledInputMethodList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<InputMethodInfo> _result = this.getInputMethodListLegacy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<InputMethodInfo> _result = this.getEnabledInputMethodListLegacy(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    List<InputMethodSubtype> _result = this.getEnabledInputMethodSubtypeList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    InputMethodSubtype _result = this.getLastInputMethodSubtype(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    this.hideSoftInputFromServerForTest();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    IInputMethodClient _arg1 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg2 = data.readStrongBinder();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    EditorInfo _arg6 = data.readTypedObject(EditorInfo.CREATOR);
                    IRemoteInputConnection _arg7 = IRemoteInputConnection.Stub.asInterface(data.readStrongBinder());
                    IRemoteAccessibilityInputConnection _arg8 = IRemoteAccessibilityInputConnection.Stub.asInterface(data.readStrongBinder());
                    int _arg9 = data.readInt();
                    int _arg10 = data.readInt();
                    ImeOnBackInvokedDispatcher _arg11 = data.readTypedObject(ImeOnBackInvokedDispatcher.CREATOR);
                    boolean _arg12 = data.readBoolean();
                    data.enforceNoDataAvail();
                    InputBindResult _result = this.startInputOrWindowGainedFocus(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10, _arg11, _arg12);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    IInputMethodClient _arg1 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg2 = data.readStrongBinder();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    EditorInfo _arg6 = data.readTypedObject(EditorInfo.CREATOR);
                    IRemoteInputConnection _arg7 = IRemoteInputConnection.Stub.asInterface(data.readStrongBinder());
                    IRemoteAccessibilityInputConnection _arg8 = IRemoteAccessibilityInputConnection.Stub.asInterface(data.readStrongBinder());
                    int _arg9 = data.readInt();
                    int _arg10 = data.readInt();
                    ImeOnBackInvokedDispatcher _arg11 = data.readTypedObject(ImeOnBackInvokedDispatcher.CREATOR);
                    boolean _arg12 = data.readBoolean();
                    int _arg13 = data.readInt();
                    boolean _arg14 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.startInputOrWindowGainedFocusAsync(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10, _arg11, _arg12, _arg13, _arg14);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showInputMethodPickerFromClient(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showInputMethodPickerFromSystem(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    boolean _result = this.isInputMethodPickerShownForTest();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onImeSwitchButtonClickFromSystem(_arg0);
                    break;
                }
                case 16: {
                    boolean _result = this.shouldShowImeSwitcherButtonForTest();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    InputMethodSubtype _result = this.getCurrentInputMethodSubtype(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    InputMethodSubtype[] _arg1 = data.createTypedArray(InputMethodSubtype.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAdditionalInputMethodSubtypes(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    int[] _arg1 = data.createIntArray();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setExplicitlyEnabledInputMethodSubtypes(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.getInputMethodWindowVisibleHeight(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportPerceptibleAsync(_arg0, _arg1);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeImeSurface(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.removeImeSurfaceFromWindowAsync(_arg0);
                    break;
                }
                case 24: {
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.startProtoDump(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    boolean _result = this.isImeTraceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    this.startImeTrace();
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    this.stopImeTrace();
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startStylusHandwriting(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    CursorAnchorInfo _arg2 = data.readTypedObject(CursorAnchorInfo.CREATOR);
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    IConnectionlessHandwritingCallback _arg5 = IConnectionlessHandwritingCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startConnectionlessStylusHandwriting(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 30: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.prepareStylusHandwritingDelegation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.acceptStylusHandwritingDelegation(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    IBooleanListener _arg5 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.acceptStylusHandwritingDelegationAsync(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStylusHandwritingAvailableAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 34: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addVirtualStylusIdForTestSession(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setStylusWindowIdleTimeoutForTest(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    IImeTracker _result = this.getImeTrackerService();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void hideSoftInputFromServerForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_INPUT_METHOD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void showInputMethodPickerFromSystem_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_showInputMethodPickerFromSystem, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isInputMethodPickerShownForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_INPUT_METHOD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onImeSwitchButtonClickFromSystem_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_onImeSwitchButtonClickFromSystem, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void shouldShowImeSwitcherButtonForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_INPUT_METHOD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeImeSurface_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_removeImeSurface, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startImeTrace_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_UI_TRACING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void stopImeTrace_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_UI_TRACING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addVirtualStylusIdForTestSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_INPUT_METHOD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setStylusWindowIdleTimeoutForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_INPUT_METHOD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 35;
        }

        private static class Proxy
        implements IInputMethodManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addClient(IInputMethodClient client, IRemoteInputConnection inputmethod, int untrustedDisplayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeStrongInterface(inputmethod);
                    _data.writeInt(untrustedDisplayId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMethodInfo getCurrentInputMethodInfoAsUser(int userId) throws RemoteException {
                InputMethodInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMethodInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMethodInfoSafeList getInputMethodList(int userId, int directBootAwareness) throws RemoteException {
                InputMethodInfoSafeList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(directBootAwareness);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMethodInfoSafeList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMethodInfoSafeList getEnabledInputMethodList(int userId) throws RemoteException {
                InputMethodInfoSafeList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMethodInfoSafeList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InputMethodInfo> getInputMethodListLegacy(int userId, int directBootAwareness) throws RemoteException {
                ArrayList<InputMethodInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(directBootAwareness);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(InputMethodInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InputMethodInfo> getEnabledInputMethodListLegacy(int userId) throws RemoteException {
                ArrayList<InputMethodInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(InputMethodInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlyEnabledSubtypes, int userId) throws RemoteException {
                ArrayList<InputMethodSubtype> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(imiId);
                    _data.writeBoolean(allowsImplicitlyEnabledSubtypes);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(InputMethodSubtype.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMethodSubtype getLastInputMethodSubtype(int userId) throws RemoteException {
                InputMethodSubtype _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMethodSubtype.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideSoftInputFromServerForTest() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputBindResult startInputOrWindowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo editorInfo, IRemoteInputConnection inputConnection, IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, int userId, ImeOnBackInvokedDispatcher imeDispatcher, boolean imeRequestedVisible) throws RemoteException {
                InputBindResult _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(startInputReason);
                    _data.writeStrongInterface(client);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(startInputFlags);
                    _data.writeInt(softInputMode);
                    _data.writeInt(windowFlags);
                    _data.writeTypedObject(editorInfo, 0);
                    _data.writeStrongInterface(inputConnection);
                    _data.writeStrongInterface(remoteAccessibilityInputConnection);
                    _data.writeInt(unverifiedTargetSdkVersion);
                    _data.writeInt(userId);
                    _data.writeTypedObject(imeDispatcher, 0);
                    _data.writeBoolean(imeRequestedVisible);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputBindResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startInputOrWindowGainedFocusAsync(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo editorInfo, IRemoteInputConnection inputConnection, IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, int userId, ImeOnBackInvokedDispatcher imeDispatcher, boolean imeRequestedVisible, int startInputSeq, boolean useAsyncShowHideMethod) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(startInputReason);
                    _data.writeStrongInterface(client);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(startInputFlags);
                    _data.writeInt(softInputMode);
                    _data.writeInt(windowFlags);
                    _data.writeTypedObject(editorInfo, 0);
                    _data.writeStrongInterface(inputConnection);
                    _data.writeStrongInterface(remoteAccessibilityInputConnection);
                    _data.writeInt(unverifiedTargetSdkVersion);
                    _data.writeInt(userId);
                    _data.writeTypedObject(imeDispatcher, 0);
                    _data.writeBoolean(imeRequestedVisible);
                    _data.writeInt(startInputSeq);
                    _data.writeBoolean(useAsyncShowHideMethod);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInputMethodPickerFromClient(IInputMethodClient client, int auxiliarySubtypeMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(auxiliarySubtypeMode);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInputMethodPickerFromSystem(int auxiliarySubtypeMode, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(auxiliarySubtypeMode);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInputMethodPickerShownForTest() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImeSwitchButtonClickFromSystem(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowImeSwitcherButtonForTest() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMethodSubtype getCurrentInputMethodSubtype(int userId) throws RemoteException {
                InputMethodSubtype _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMethodSubtype.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdditionalInputMethodSubtypes(String id2, InputMethodSubtype[] subtypes, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedArray(subtypes, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExplicitlyEnabledInputMethodSubtypes(String imeId, int[] subtypeHashCodes, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(imeId);
                    _data.writeIntArray(subtypeHashCodes);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInputMethodWindowVisibleHeight(IInputMethodClient client) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportPerceptibleAsync(IBinder windowToken, boolean perceptible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeBoolean(perceptible);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeImeSurface(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeImeSurfaceFromWindowAsync(IBinder windowToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startProtoDump(byte[] protoDump, int source, String where) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(protoDump);
                    _data.writeInt(source);
                    _data.writeString(where);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isImeTraceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startImeTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopImeTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startStylusHandwriting(IInputMethodClient client) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startConnectionlessStylusHandwriting(IInputMethodClient client, int userId, CursorAnchorInfo cursorAnchorInfo, String delegatePackageName, String delegatorPackageName, IConnectionlessHandwritingCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    _data.writeTypedObject(cursorAnchorInfo, 0);
                    _data.writeString(delegatePackageName);
                    _data.writeString(delegatorPackageName);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareStylusHandwritingDelegation(IInputMethodClient client, int userId, String delegatePackageName, String delegatorPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    _data.writeString(delegatePackageName);
                    _data.writeString(delegatorPackageName);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean acceptStylusHandwritingDelegation(IInputMethodClient client, int userId, String delegatePackageName, String delegatorPackageName, int flags) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    _data.writeString(delegatePackageName);
                    _data.writeString(delegatorPackageName);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acceptStylusHandwritingDelegationAsync(IInputMethodClient client, int userId, String delegatePackageName, String delegatorPackageName, int flags, IBooleanListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    _data.writeString(delegatePackageName);
                    _data.writeString(delegatorPackageName);
                    _data.writeInt(flags);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStylusHandwritingAvailableAsUser(int userId, boolean connectionless) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(connectionless);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addVirtualStylusIdForTestSession(IInputMethodClient client) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStylusWindowIdleTimeoutForTest(IInputMethodClient client, long timeout) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeLong(timeout);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImeTracker getImeTrackerService() throws RemoteException {
                IImeTracker _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = IImeTracker.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IInputMethodManager {
        @Override
        public void addClient(IInputMethodClient client, IRemoteInputConnection inputmethod, int untrustedDisplayId) throws RemoteException {
        }

        @Override
        public InputMethodInfo getCurrentInputMethodInfoAsUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public InputMethodInfoSafeList getInputMethodList(int userId, int directBootAwareness) throws RemoteException {
            return null;
        }

        @Override
        public InputMethodInfoSafeList getEnabledInputMethodList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<InputMethodInfo> getInputMethodListLegacy(int userId, int directBootAwareness) throws RemoteException {
            return null;
        }

        @Override
        public List<InputMethodInfo> getEnabledInputMethodListLegacy(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlyEnabledSubtypes, int userId) throws RemoteException {
            return null;
        }

        @Override
        public InputMethodSubtype getLastInputMethodSubtype(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void hideSoftInputFromServerForTest() throws RemoteException {
        }

        @Override
        public InputBindResult startInputOrWindowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo editorInfo, IRemoteInputConnection inputConnection, IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, int userId, ImeOnBackInvokedDispatcher imeDispatcher, boolean imeRequestedVisible) throws RemoteException {
            return null;
        }

        @Override
        public void startInputOrWindowGainedFocusAsync(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo editorInfo, IRemoteInputConnection inputConnection, IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, int userId, ImeOnBackInvokedDispatcher imeDispatcher, boolean imeRequestedVisible, int startInputSeq, boolean useAsyncShowHideMethod) throws RemoteException {
        }

        @Override
        public void showInputMethodPickerFromClient(IInputMethodClient client, int auxiliarySubtypeMode) throws RemoteException {
        }

        @Override
        public void showInputMethodPickerFromSystem(int auxiliarySubtypeMode, int displayId) throws RemoteException {
        }

        @Override
        public boolean isInputMethodPickerShownForTest() throws RemoteException {
            return false;
        }

        @Override
        public void onImeSwitchButtonClickFromSystem(int displayId) throws RemoteException {
        }

        @Override
        public boolean shouldShowImeSwitcherButtonForTest() throws RemoteException {
            return false;
        }

        @Override
        public InputMethodSubtype getCurrentInputMethodSubtype(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setAdditionalInputMethodSubtypes(String id2, InputMethodSubtype[] subtypes, int userId) throws RemoteException {
        }

        @Override
        public void setExplicitlyEnabledInputMethodSubtypes(String imeId, int[] subtypeHashCodes, int userId) throws RemoteException {
        }

        @Override
        public int getInputMethodWindowVisibleHeight(IInputMethodClient client) throws RemoteException {
            return 0;
        }

        @Override
        public void reportPerceptibleAsync(IBinder windowToken, boolean perceptible) throws RemoteException {
        }

        @Override
        public void removeImeSurface(int displayId) throws RemoteException {
        }

        @Override
        public void removeImeSurfaceFromWindowAsync(IBinder windowToken) throws RemoteException {
        }

        @Override
        public void startProtoDump(byte[] protoDump, int source, String where) throws RemoteException {
        }

        @Override
        public boolean isImeTraceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void startImeTrace() throws RemoteException {
        }

        @Override
        public void stopImeTrace() throws RemoteException {
        }

        @Override
        public void startStylusHandwriting(IInputMethodClient client) throws RemoteException {
        }

        @Override
        public void startConnectionlessStylusHandwriting(IInputMethodClient client, int userId, CursorAnchorInfo cursorAnchorInfo, String delegatePackageName, String delegatorPackageName, IConnectionlessHandwritingCallback callback) throws RemoteException {
        }

        @Override
        public void prepareStylusHandwritingDelegation(IInputMethodClient client, int userId, String delegatePackageName, String delegatorPackageName) throws RemoteException {
        }

        @Override
        public boolean acceptStylusHandwritingDelegation(IInputMethodClient client, int userId, String delegatePackageName, String delegatorPackageName, int flags) throws RemoteException {
            return false;
        }

        @Override
        public void acceptStylusHandwritingDelegationAsync(IInputMethodClient client, int userId, String delegatePackageName, String delegatorPackageName, int flags, IBooleanListener callback) throws RemoteException {
        }

        @Override
        public boolean isStylusHandwritingAvailableAsUser(int userId, boolean connectionless) throws RemoteException {
            return false;
        }

        @Override
        public void addVirtualStylusIdForTestSession(IInputMethodClient client) throws RemoteException {
        }

        @Override
        public void setStylusWindowIdleTimeoutForTest(IInputMethodClient client, long timeout) throws RemoteException {
        }

        @Override
        public IImeTracker getImeTrackerService() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

