/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.os.VibrationEffect;
import android.text.TextUtils;
import com.android.internal.util.ArrayUtils;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlSerializedVibration;
import com.android.internal.vibrator.persistence.XmlSerializerException;
import com.android.modules.utils.TypedXmlPullParser;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class XmlValidator {
    public static void checkStartTag(TypedXmlPullParser parser, String expectedTag) throws XmlParserException {
        XmlValidator.checkStartTag(parser);
        XmlValidator.checkParserCondition(expectedTag.equals(parser.getName()), "Unexpected start tag found %s, expected %s", parser.getName(), expectedTag);
    }

    public static void checkStartTag(TypedXmlPullParser parser) throws XmlParserException {
        try {
            XmlValidator.checkParserCondition(parser.getEventType() == 2, "Expected start tag, got " + parser.getEventType(), new Object[0]);
        }
        catch (XmlPullParserException e) {
            throw XmlParserException.createFromPullParserException(parser.getName(), e);
        }
    }

    public static void checkTagHasNoUnexpectedAttributes(TypedXmlPullParser parser, String ... expectedAttributes) throws XmlParserException {
        if (expectedAttributes == null || expectedAttributes.length == 0) {
            XmlValidator.checkParserCondition(parser.getAttributeCount() == 0, "Unexpected attributes in tag %s, expected no attributes", parser.getName());
            return;
        }
        String tagName = parser.getName();
        int attributeCount = parser.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = parser.getAttributeName(i);
            XmlValidator.checkParserCondition(ArrayUtils.contains(expectedAttributes, attributeName), "Unexpected attribute %s found in tag %s", attributeName, tagName);
        }
    }

    public static void checkSerializedVibration(XmlSerializedVibration<? extends VibrationEffect> serializedVibration, VibrationEffect expectedVibration) throws XmlSerializerException {
        VibrationEffect deserializedVibration = Objects.requireNonNull(serializedVibration.deserialize());
        XmlValidator.checkSerializerCondition(Objects.equals(expectedVibration, deserializedVibration), "Unexpected serialized vibration %s: found deserialization %s, expected %s", serializedVibration, deserializedVibration, expectedVibration);
    }

    public static void checkSerializerCondition(boolean expression, String messageTemplate, Object ... messageArgs) throws XmlSerializerException {
        if (!expression) {
            throw new XmlSerializerException(TextUtils.formatSimple(messageTemplate, messageArgs));
        }
    }

    public static void checkParserCondition(boolean expression, String messageTemplate, Object ... messageArgs) throws XmlParserException {
        if (!expression) {
            throw new XmlParserException(TextUtils.formatSimple(messageTemplate, messageArgs));
        }
    }
}

