/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class SerializedWaveformEnvelopeEffect
implements SerializedComposedEffect.SerializedSegment {
    private final WaveformControlPoint[] mControlPoints;
    private final float mInitialFrequency;

    SerializedWaveformEnvelopeEffect(WaveformControlPoint[] controlPoints, float initialFrequency) {
        this.mControlPoints = controlPoints;
        this.mInitialFrequency = initialFrequency;
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "waveform-envelope-effect");
        if (!Float.isNaN(this.mInitialFrequency)) {
            serializer.attributeFloat(XmlConstants.NAMESPACE, "initialFrequencyHz", this.mInitialFrequency);
        }
        for (WaveformControlPoint point : this.mControlPoints) {
            serializer.startTag(XmlConstants.NAMESPACE, "control-point");
            serializer.attributeFloat(XmlConstants.NAMESPACE, "amplitude", point.mAmplitude);
            serializer.attributeFloat(XmlConstants.NAMESPACE, "frequencyHz", point.mFrequency);
            serializer.attributeLong(XmlConstants.NAMESPACE, "durationMs", point.mDurationMs);
            serializer.endTag(XmlConstants.NAMESPACE, "control-point");
        }
        serializer.endTag(XmlConstants.NAMESPACE, "waveform-envelope-effect");
    }

    @Override
    public void deserializeIntoComposition(@NonNull VibrationEffect.Composition composition) {
        VibrationEffect.WaveformEnvelopeBuilder builder = new VibrationEffect.WaveformEnvelopeBuilder();
        if (!Float.isNaN(this.mInitialFrequency)) {
            builder.setInitialFrequencyHz(this.mInitialFrequency);
        }
        for (WaveformControlPoint point : this.mControlPoints) {
            builder.addControlPoint(point.mAmplitude, point.mFrequency, point.mDurationMs);
        }
        composition.addEffect(builder.build());
    }

    public String toString() {
        return "SerializedWaveformEnvelopeEffect{InitialFrequency=" + (Float.isNaN(this.mInitialFrequency) ? "" : Float.valueOf(this.mInitialFrequency)) + ", controlPoints=" + Arrays.toString(this.mControlPoints) + '}';
    }

    private static class WaveformControlPoint {
        private final float mAmplitude;
        private final float mFrequency;
        private final long mDurationMs;

        WaveformControlPoint(float amplitude, float frequency, long durationMs) {
            this.mAmplitude = amplitude;
            this.mFrequency = frequency;
            this.mDurationMs = durationMs;
        }

        public String toString() {
            return String.format(Locale.ROOT, "(%.2f, %.2f, %dms)", Float.valueOf(this.mAmplitude), Float.valueOf(this.mFrequency), this.mDurationMs);
        }
    }

    static class Parser {
        Parser() {
        }

        @NonNull
        static SerializedWaveformEnvelopeEffect parseNext(@NonNull TypedXmlPullParser parser, int flags) throws XmlParserException, IOException {
            XmlValidator.checkStartTag(parser, "waveform-envelope-effect");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "initialFrequencyHz");
            Builder builder = new Builder();
            builder.setInitialFrequencyHz(XmlReader.readAttributePositiveFloat(parser, "initialFrequencyHz", Float.NaN));
            int outerDepth = parser.getDepth();
            while (XmlReader.readNextTagWithin(parser, outerDepth)) {
                Parser.parseControlPoint(parser, builder);
                XmlReader.readEndTag(parser);
            }
            XmlValidator.checkParserCondition(!builder.mControlPoints.isEmpty(), "Expected tag %s to have at least one control point", "waveform-envelope-effect");
            return builder.build();
        }

        private static void parseControlPoint(TypedXmlPullParser parser, Builder builder) throws XmlParserException {
            XmlValidator.checkStartTag(parser, "control-point");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "durationMs", "amplitude", "frequencyHz");
            float amplitude = XmlReader.readAttributeFloatInRange(parser, "amplitude", 0.0f, 1.0f);
            float frequencyHz = XmlReader.readAttributePositiveFloat(parser, "frequencyHz");
            long durationMs = XmlReader.readAttributePositiveLong(parser, "durationMs");
            builder.addControlPoint(amplitude, frequencyHz, durationMs);
        }
    }

    static class Builder {
        private final List<WaveformControlPoint> mControlPoints;
        private float mInitialFrequencyHz = Float.NaN;

        Builder() {
            this.mControlPoints = new ArrayList<WaveformControlPoint>();
        }

        void setInitialFrequencyHz(float frequencyHz) {
            this.mInitialFrequencyHz = frequencyHz;
        }

        void addControlPoint(float amplitude, float frequencyHz, long durationMs) {
            this.mControlPoints.add(new WaveformControlPoint(amplitude, frequencyHz, durationMs));
        }

        SerializedWaveformEnvelopeEffect build() {
            return new SerializedWaveformEnvelopeEffect(this.mControlPoints.toArray(new WaveformControlPoint[0]), this.mInitialFrequencyHz);
        }
    }
}

