/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;

class SerializedPredefinedEffect
implements SerializedComposedEffect.SerializedSegment {
    @NonNull
    private final XmlConstants.PredefinedEffectName mEffectName;
    private final boolean mShouldFallback;

    SerializedPredefinedEffect(XmlConstants.PredefinedEffectName effectName, boolean shouldFallback) {
        this.mEffectName = effectName;
        this.mShouldFallback = shouldFallback;
    }

    @Override
    public void deserializeIntoComposition(@NonNull VibrationEffect.Composition composition) {
        composition.addEffect(VibrationEffect.get(this.mEffectName.getEffectId(), this.mShouldFallback));
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "predefined-effect");
        serializer.attribute(XmlConstants.NAMESPACE, "name", this.mEffectName.toString());
        if (!this.mShouldFallback) {
            serializer.attributeBoolean(XmlConstants.NAMESPACE, "fallback", this.mShouldFallback);
        }
        serializer.endTag(XmlConstants.NAMESPACE, "predefined-effect");
    }

    public String toString() {
        return "SerializedPredefinedEffect{name=" + (Object)((Object)this.mEffectName) + ", fallback=" + this.mShouldFallback + '}';
    }

    static class Parser {
        Parser() {
        }

        @NonNull
        static SerializedPredefinedEffect parseNext(@NonNull TypedXmlPullParser parser, int flags) throws XmlParserException, IOException {
            boolean allowHidden;
            XmlValidator.checkStartTag(parser, "predefined-effect");
            boolean bl = allowHidden = (flags & 1) != 0;
            if (allowHidden) {
                XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "name", "fallback");
            } else {
                XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "name");
            }
            String nameAttr = parser.getAttributeValue(XmlConstants.NAMESPACE, "name");
            if (nameAttr == null) {
                throw new XmlParserException("Missing predefined effect name");
            }
            XmlConstants.PredefinedEffectName effectName = XmlConstants.PredefinedEffectName.findByName(nameAttr, flags);
            if (effectName == null) {
                throw new XmlParserException("Unexpected predefined effect name " + nameAttr);
            }
            boolean defaultFallback = true;
            boolean fallback = allowHidden ? parser.getAttributeBoolean(XmlConstants.NAMESPACE, "fallback", defaultFallback) : defaultFallback;
            XmlReader.readEndTag(parser);
            return new SerializedPredefinedEffect(effectName, fallback);
        }
    }
}

