/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import com.android.internal.util.Preconditions;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlSerializedVibration;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

class SerializedComposedEffect
implements XmlSerializedVibration<VibrationEffect.Composed> {
    @NonNull
    private final SerializedSegment[] mSegments;

    SerializedComposedEffect(@NonNull SerializedSegment segment) {
        Objects.requireNonNull(segment);
        this.mSegments = new SerializedSegment[]{segment};
    }

    SerializedComposedEffect(@NonNull SerializedSegment[] segments) {
        Objects.requireNonNull(segments);
        Preconditions.checkArgument(segments.length > 0, "Unsupported empty vibration");
        this.mSegments = segments;
    }

    @Override
    @NonNull
    public VibrationEffect.Composed deserialize() {
        VibrationEffect.Composition composition = VibrationEffect.startComposition();
        for (SerializedSegment segment : this.mSegments) {
            segment.deserializeIntoComposition(composition);
        }
        return (VibrationEffect.Composed)composition.compose();
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "vibration-effect");
        this.writeContent(serializer);
        serializer.endTag(XmlConstants.NAMESPACE, "vibration-effect");
    }

    @Override
    public void writeContent(@NonNull TypedXmlSerializer serializer) throws IOException {
        for (SerializedSegment segment : this.mSegments) {
            segment.write(serializer);
        }
    }

    public String toString() {
        return "SerializedComposedEffect{segments=" + Arrays.toString(this.mSegments) + '}';
    }

    static interface SerializedSegment {
        public void write(@NonNull TypedXmlSerializer var1) throws IOException;

        public void deserializeIntoComposition(@NonNull VibrationEffect.Composition var1);
    }
}

