/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import android.util.IntArray;
import android.util.LongArray;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.BiConsumer;

class SerializedAmplitudeStepWaveform
implements SerializedComposedEffect.SerializedSegment {
    @NonNull
    private final long[] mTimings;
    @NonNull
    private final int[] mAmplitudes;
    private final int mRepeatIndex;

    private SerializedAmplitudeStepWaveform(long[] timings, int[] amplitudes, int repeatIndex) {
        this.mTimings = timings;
        this.mAmplitudes = amplitudes;
        this.mRepeatIndex = repeatIndex;
    }

    @Override
    public void deserializeIntoComposition(@NonNull VibrationEffect.Composition composition) {
        composition.addEffect(VibrationEffect.createWaveform(this.mTimings, this.mAmplitudes, this.mRepeatIndex));
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "waveform-effect");
        for (int i = 0; i < this.mTimings.length; ++i) {
            if (i == this.mRepeatIndex) {
                serializer.startTag(XmlConstants.NAMESPACE, "repeating");
            }
            this.writeWaveformEntry(serializer, i);
        }
        if (this.mRepeatIndex >= 0) {
            serializer.endTag(XmlConstants.NAMESPACE, "repeating");
        }
        serializer.endTag(XmlConstants.NAMESPACE, "waveform-effect");
    }

    private void writeWaveformEntry(@NonNull TypedXmlSerializer serializer, int index) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "waveform-entry");
        if (this.mAmplitudes[index] == -1) {
            serializer.attribute(XmlConstants.NAMESPACE, "amplitude", "default");
        } else {
            serializer.attributeInt(XmlConstants.NAMESPACE, "amplitude", this.mAmplitudes[index]);
        }
        serializer.attributeLong(XmlConstants.NAMESPACE, "durationMs", this.mTimings[index]);
        serializer.endTag(XmlConstants.NAMESPACE, "waveform-entry");
    }

    public String toString() {
        return "SerializedAmplitudeStepWaveform{timings=" + Arrays.toString(this.mTimings) + ", amplitudes=" + Arrays.toString(this.mAmplitudes) + ", repeatIndex=" + this.mRepeatIndex + '}';
    }

    static class Parser {
        Parser() {
        }

        @NonNull
        static SerializedAmplitudeStepWaveform parseNext(@NonNull TypedXmlPullParser parser) throws XmlParserException, IOException {
            XmlValidator.checkStartTag(parser, "waveform-effect");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, new String[0]);
            Builder waveformBuilder = new Builder();
            int outerDepth = parser.getDepth();
            while (XmlReader.readNextTagWithin(parser, outerDepth) && !"repeating".equals(parser.getName())) {
                Parser.parseWaveformEntry(parser, waveformBuilder::addDurationAndAmplitude);
            }
            if ("repeating".equals(parser.getName())) {
                Parser.parseRepeating(parser, waveformBuilder);
            }
            XmlValidator.checkParserCondition(waveformBuilder.hasNonZeroDuration(), "Unexpected %s tag with total duration zero", "waveform-effect");
            XmlReader.readEndTag(parser, "waveform-effect", outerDepth);
            return waveformBuilder.build();
        }

        static void parseWaveformEntry(TypedXmlPullParser parser, BiConsumer<Integer, Integer> builder) throws XmlParserException, IOException {
            XmlValidator.checkStartTag(parser, "waveform-entry");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "durationMs", "amplitude");
            String rawAmplitude = parser.getAttributeValue(XmlConstants.NAMESPACE, "amplitude");
            int amplitude = "default".equals(rawAmplitude) ? -1 : XmlReader.readAttributeIntInRange(parser, "amplitude", 0, 255);
            int durationMs = XmlReader.readAttributeIntNonNegative(parser, "durationMs");
            builder.accept(durationMs, amplitude);
            XmlReader.readEndTag(parser);
        }

        private static void parseRepeating(TypedXmlPullParser parser, Builder waveformBuilder) throws XmlParserException, IOException {
            XmlValidator.checkStartTag(parser, "repeating");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, new String[0]);
            waveformBuilder.setRepeatIndexToCurrentEntry();
            boolean hasEntry = false;
            int outerDepth = parser.getDepth();
            while (XmlReader.readNextTagWithin(parser, outerDepth)) {
                Parser.parseWaveformEntry(parser, waveformBuilder::addDurationAndAmplitude);
                hasEntry = true;
            }
            XmlValidator.checkParserCondition(hasEntry, "Unexpected empty %s tag", "repeating");
            XmlReader.readEndTag(parser, "repeating", outerDepth);
        }
    }

    static class Builder {
        private final LongArray mTimings = new LongArray();
        private final IntArray mAmplitudes = new IntArray();
        private int mRepeatIndex = -1;

        Builder() {
        }

        void addDurationAndAmplitude(long durationMs, int amplitude) {
            this.mTimings.add(durationMs);
            this.mAmplitudes.add(amplitude);
        }

        void setRepeatIndexToCurrentEntry() {
            this.mRepeatIndex = this.mTimings.size();
        }

        boolean hasNonZeroDuration() {
            for (int i = 0; i < this.mTimings.size(); ++i) {
                if (this.mTimings.get(i) <= 0L) continue;
                return true;
            }
            return false;
        }

        SerializedAmplitudeStepWaveform build() {
            return new SerializedAmplitudeStepWaveform(this.mTimings.toArray(), this.mAmplitudes.toArray(), this.mRepeatIndex);
        }
    }
}

