/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.os.Trace;
import java.util.regex.Pattern;

public class NotificationBigTextNormalizer {
    private static final Pattern MULTIPLE_NEWLINES = Pattern.compile("\\v(\\s*\\v)?");
    private static final Pattern HORIZONTAL_WHITESPACES = Pattern.compile("\\h+");

    private NotificationBigTextNormalizer() {
    }

    @NonNull
    public static String normalizeBigText(@NonNull String text) {
        try {
            Trace.beginSection("NotifBigTextNormalizer#normalizeBigText");
            text = MULTIPLE_NEWLINES.matcher(text).replaceAll("\n");
            text = HORIZONTAL_WHITESPACES.matcher(text).replaceAll(" ");
            String string2 = text = NotificationBigTextNormalizer.normalizeLines(text);
            return string2;
        }
        finally {
            Trace.endSection();
        }
    }

    @NonNull
    private static String normalizeLines(@NonNull String text) {
        String[] lines = text.split("\n");
        StringBuilder textSB = new StringBuilder(text.length());
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            StringBuilder lineSB = new StringBuilder(line.length());
            boolean spaceSeen = false;
            for (int j = 0; j < line.length(); ++j) {
                char character = line.charAt(j);
                if (character >= '\u200b' && character <= '\u200d' || character == '\ufeff' || character == '\u034f' || character >= '\u2060' && character <= '\u2065' || character >= '\u206a' && character <= '\u206f' || character >= '\ufff9' && character <= '\ufffb') continue;
                if (NotificationBigTextNormalizer.isSpace(character)) {
                    if (!spaceSeen) {
                        lineSB.append(" ");
                    }
                    spaceSeen = true;
                    continue;
                }
                spaceSeen = false;
                lineSB.append(character);
            }
            String currentLine = lineSB.toString().trim();
            if (currentLine.length() <= 0) continue;
            if (textSB.length() > 0) {
                textSB.append("\n");
            }
            textSB.append(currentLine);
        }
        return textSB.toString();
    }

    private static boolean isSpace(char ch) {
        return ch != '\n' && Character.isSpaceChar(ch);
    }
}

