/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.os.RemoteException;
import android.util.ExceptionUtils;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FunctionalUtils {
    private FunctionalUtils() {
    }

    public static <T> Consumer<T> uncheckExceptions(ThrowingConsumer<T> action) {
        return action;
    }

    public static <I, O> Function<I, O> uncheckExceptions(ThrowingFunction<I, O> action) {
        return action;
    }

    public static Runnable uncheckExceptions(ThrowingRunnable action) {
        return action;
    }

    public static <A, B> BiConsumer<A, B> uncheckExceptions(ThrowingBiConsumer<A, B> action) {
        return action;
    }

    public static <T> Supplier<T> uncheckExceptions(ThrowingSupplier<T> action) {
        return action;
    }

    public static <T> Consumer<T> ignoreRemoteException(RemoteExceptionIgnoringConsumer<T> action) {
        return action;
    }

    public static Runnable handleExceptions(ThrowingRunnable r, Consumer<Throwable> handler) {
        return () -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                handler.accept(t);
            }
        };
    }

    @NonNull
    public static String getLambdaName(@NonNull Object function) {
        String fullFunction = function.toString();
        int endPkgIdx = fullFunction.indexOf("-$$");
        if (endPkgIdx == -1) {
            return fullFunction;
        }
        int firstDollarIdx = fullFunction.indexOf(36, endPkgIdx + 3);
        if (firstDollarIdx == -1) {
            return fullFunction;
        }
        int endClassIdx = fullFunction.indexOf(36, firstDollarIdx + 1);
        if (endClassIdx == -1) {
            return fullFunction.substring(0, endPkgIdx - 1) + "$Lambda";
        }
        return fullFunction.substring(0, endPkgIdx) + fullFunction.substring(firstDollarIdx + 1, endClassIdx) + "$Lambda";
    }

    @FunctionalInterface
    public static interface ThrowingRunnable
    extends Runnable {
        public void runOrThrow() throws Exception;

        @Override
        default public void run() {
            try {
                this.runOrThrow();
            }
            catch (Exception ex) {
                throw ExceptionUtils.propagate(ex);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingCheckedFunction<Input, Output, ExceptionType extends Exception> {
        public Output apply(Input var1) throws ExceptionType;
    }

    @FunctionalInterface
    public static interface ThrowingChecked2Consumer<Input, ExceptionOne extends Exception, ExceptionTwo extends Exception> {
        public void accept(Input var1) throws ExceptionOne, ExceptionTwo;
    }

    @FunctionalInterface
    public static interface ThrowingCheckedConsumer<Input, ExceptionType extends Exception> {
        public void accept(Input var1) throws ExceptionType;
    }

    @FunctionalInterface
    public static interface ThrowingCheckedSupplier<Output, ExceptionType extends Exception> {
        public Output get() throws ExceptionType;
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<A, B>
    extends BiConsumer<A, B> {
        public void acceptOrThrow(A var1, B var2) throws Exception;

        @Override
        default public void accept(A a, B b) {
            try {
                this.acceptOrThrow(a, b);
            }
            catch (Exception ex) {
                throw ExceptionUtils.propagate(ex);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<T, U, R>
    extends BiFunction<T, U, R> {
        public R applyOrThrow(T var1, U var2) throws Exception;

        @Override
        default public R apply(T t, U u) {
            try {
                return this.applyOrThrow(t, u);
            }
            catch (Exception ex) {
                throw ExceptionUtils.propagate(ex);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R>
    extends Function<T, R> {
        public R applyOrThrow(T var1) throws Exception;

        @Override
        default public R apply(T t) {
            try {
                return this.applyOrThrow(t);
            }
            catch (Exception ex) {
                throw ExceptionUtils.propagate(ex);
            }
        }
    }

    @FunctionalInterface
    public static interface RemoteExceptionIgnoringConsumer<T>
    extends Consumer<T> {
        public void acceptOrThrow(T var1) throws RemoteException;

        @Override
        default public void accept(T t) {
            try {
                this.acceptOrThrow(t);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T>
    extends Consumer<T> {
        public void acceptOrThrow(T var1) throws Exception;

        @Override
        default public void accept(T t) {
            try {
                this.acceptOrThrow(t);
            }
            catch (Exception ex) {
                throw ExceptionUtils.propagate(ex);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T>
    extends Supplier<T> {
        public T getOrThrow() throws Exception;

        @Override
        default public T get() {
            try {
                return this.getOrThrow();
            }
            catch (Exception ex) {
                throw ExceptionUtils.propagate(ex);
            }
        }
    }
}

