/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.BarringInfo;
import android.telephony.CallQuality;
import android.telephony.CellIdentity;
import android.telephony.CellInfo;
import android.telephony.CellularIdentifierDisclosure;
import android.telephony.LinkCapacityEstimate;
import android.telephony.PhoneCapability;
import android.telephony.PhysicalChannelConfig;
import android.telephony.PreciseDataConnectionState;
import android.telephony.SecurityAlgorithmUpdate;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.MediaQualityStatus;
import android.telephony.satellite.NtnSignalStrength;
import com.android.internal.telephony.ICarrierConfigChangeListener;
import com.android.internal.telephony.ICarrierPrivilegesCallback;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.IPhoneStateListener;
import com.android.internal.telephony.ISatelliteStateChangeListener;
import java.util.ArrayList;
import java.util.List;

public interface ITelephonyRegistry
extends IInterface {
    public void addOnSubscriptionsChangedListener(String var1, String var2, IOnSubscriptionsChangedListener var3) throws RemoteException;

    public void addOnOpportunisticSubscriptionsChangedListener(String var1, String var2, IOnSubscriptionsChangedListener var3) throws RemoteException;

    public void removeOnSubscriptionsChangedListener(String var1, IOnSubscriptionsChangedListener var2) throws RemoteException;

    public void listenWithEventList(boolean var1, boolean var2, int var3, String var4, String var5, IPhoneStateListener var6, int[] var7, boolean var8) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/telephony/ITelephonyRegistry.aidl:57:1:57:69")
    public void notifyCallStateForAllSubs(int var1, String var2) throws RemoteException;

    public void notifyCallState(int var1, int var2, int var3, String var4) throws RemoteException;

    public void notifyServiceStateForPhoneId(int var1, int var2, ServiceState var3) throws RemoteException;

    public void notifySignalStrengthForPhoneId(int var1, int var2, SignalStrength var3) throws RemoteException;

    public void notifyMessageWaitingChangedForPhoneId(int var1, int var2, boolean var3) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/com/android/internal/telephony/ITelephonyRegistry.aidl:64:1:64:44")
    public void notifyCallForwardingChanged(boolean var1) throws RemoteException;

    public void notifyCallForwardingChangedForSubscriber(int var1, boolean var2) throws RemoteException;

    public void notifyDataActivityForSubscriber(int var1, int var2) throws RemoteException;

    public void notifyDataActivityForSubscriberWithSlot(int var1, int var2, int var3) throws RemoteException;

    public void notifyDataConnectionForSubscriber(int var1, int var2, PreciseDataConnectionState var3) throws RemoteException;

    public void notifyCellLocationForSubscriber(int var1, CellIdentity var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/telephony/ITelephonyRegistry.aidl:73:1:73:25")
    public void notifyCellInfo(List<CellInfo> var1) throws RemoteException;

    public void notifyPreciseCallState(int var1, int var2, int[] var3, String[] var4, int[] var5, int[] var6) throws RemoteException;

    public void notifyDisconnectCause(int var1, int var2, int var3, int var4) throws RemoteException;

    public void notifyCellInfoForSubscriber(int var1, List<CellInfo> var2) throws RemoteException;

    public void notifySrvccStateChanged(int var1, int var2) throws RemoteException;

    public void notifySimActivationStateChangedForPhoneId(int var1, int var2, int var3, int var4) throws RemoteException;

    public void notifyOemHookRawEventForSubscriber(int var1, int var2, byte[] var3) throws RemoteException;

    public void notifySubscriptionInfoChanged() throws RemoteException;

    public void notifyOpportunisticSubscriptionInfoChanged() throws RemoteException;

    public void notifyCarrierNetworkChange(boolean var1) throws RemoteException;

    public void notifyCarrierNetworkChangeForPhoneAndSubId(int var1, int var2, boolean var3) throws RemoteException;

    public void notifyUserMobileDataStateChangedForPhoneId(int var1, int var2, boolean var3) throws RemoteException;

    public void notifyDisplayInfoChanged(int var1, int var2, TelephonyDisplayInfo var3) throws RemoteException;

    public void notifyPhoneCapabilityChanged(PhoneCapability var1) throws RemoteException;

    public void notifyActiveDataSubIdChanged(int var1) throws RemoteException;

    public void notifyRadioPowerStateChanged(int var1, int var2, int var3) throws RemoteException;

    public void notifyEmergencyNumberList(int var1, int var2) throws RemoteException;

    public void notifyOutgoingEmergencyCall(int var1, int var2, EmergencyNumber var3) throws RemoteException;

    public void notifyOutgoingEmergencySms(int var1, int var2, EmergencyNumber var3) throws RemoteException;

    public void notifyCallQualityChanged(CallQuality var1, int var2, int var3, int var4) throws RemoteException;

    public void notifyMediaQualityStatusChanged(int var1, int var2, MediaQualityStatus var3) throws RemoteException;

    public void notifyImsDisconnectCause(int var1, ImsReasonInfo var2) throws RemoteException;

    public void notifyRegistrationFailed(int var1, int var2, CellIdentity var3, String var4, int var5, int var6, int var7) throws RemoteException;

    public void notifyBarringInfoChanged(int var1, int var2, BarringInfo var3) throws RemoteException;

    public void notifyPhysicalChannelConfigForSubscriber(int var1, int var2, List<PhysicalChannelConfig> var3) throws RemoteException;

    public void notifyDataEnabled(int var1, int var2, boolean var3, int var4) throws RemoteException;

    public void notifyAllowedNetworkTypesChanged(int var1, int var2, int var3, long var4) throws RemoteException;

    public void notifyLinkCapacityEstimateChanged(int var1, int var2, List<LinkCapacityEstimate> var3) throws RemoteException;

    public void notifySimultaneousCellularCallingSubscriptionsChanged(int[] var1) throws RemoteException;

    public void addCarrierPrivilegesCallback(int var1, ICarrierPrivilegesCallback var2, String var3, String var4) throws RemoteException;

    public void removeCarrierPrivilegesCallback(ICarrierPrivilegesCallback var1, String var2) throws RemoteException;

    public void notifyCarrierPrivilegesChanged(int var1, List<String> var2, int[] var3) throws RemoteException;

    public void notifyCarrierServiceChanged(int var1, String var2, int var3) throws RemoteException;

    public void addCarrierConfigChangeListener(ICarrierConfigChangeListener var1, String var2, String var3) throws RemoteException;

    public void removeCarrierConfigChangeListener(ICarrierConfigChangeListener var1, String var2) throws RemoteException;

    public void notifyCarrierConfigChanged(int var1, int var2, int var3, int var4) throws RemoteException;

    public void notifyCallbackModeStarted(int var1, int var2, int var3, long var4) throws RemoteException;

    public void notifyCallbackModeRestarted(int var1, int var2, int var3, long var4) throws RemoteException;

    public void notifyCallbackModeStopped(int var1, int var2, int var3, int var4) throws RemoteException;

    public void notifyCarrierRoamingNtnModeChanged(int var1, boolean var2) throws RemoteException;

    public void notifyCarrierRoamingNtnEligibleStateChanged(int var1, boolean var2) throws RemoteException;

    public void notifyCarrierRoamingNtnAvailableServicesChanged(int var1, int[] var2) throws RemoteException;

    public void notifyCarrierRoamingNtnSignalStrengthChanged(int var1, NtnSignalStrength var2) throws RemoteException;

    public void addSatelliteStateChangeListener(ISatelliteStateChangeListener var1, String var2, String var3) throws RemoteException;

    public void removeSatelliteStateChangeListener(ISatelliteStateChangeListener var1, String var2) throws RemoteException;

    public void notifySatelliteStateChanged(boolean var1) throws RemoteException;

    public void notifySecurityAlgorithmsChanged(int var1, int var2, SecurityAlgorithmUpdate var3) throws RemoteException;

    public void notifyCellularIdentifierDisclosedChanged(int var1, int var2, CellularIdentifierDisclosure var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITelephonyRegistry {
        public static final String DESCRIPTOR = "com.android.internal.telephony.ITelephonyRegistry";
        static final int TRANSACTION_addOnSubscriptionsChangedListener = 1;
        static final int TRANSACTION_addOnOpportunisticSubscriptionsChangedListener = 2;
        static final int TRANSACTION_removeOnSubscriptionsChangedListener = 3;
        static final int TRANSACTION_listenWithEventList = 4;
        static final int TRANSACTION_notifyCallStateForAllSubs = 5;
        static final int TRANSACTION_notifyCallState = 6;
        static final int TRANSACTION_notifyServiceStateForPhoneId = 7;
        static final int TRANSACTION_notifySignalStrengthForPhoneId = 8;
        static final int TRANSACTION_notifyMessageWaitingChangedForPhoneId = 9;
        static final int TRANSACTION_notifyCallForwardingChanged = 10;
        static final int TRANSACTION_notifyCallForwardingChangedForSubscriber = 11;
        static final int TRANSACTION_notifyDataActivityForSubscriber = 12;
        static final int TRANSACTION_notifyDataActivityForSubscriberWithSlot = 13;
        static final int TRANSACTION_notifyDataConnectionForSubscriber = 14;
        static final int TRANSACTION_notifyCellLocationForSubscriber = 15;
        static final int TRANSACTION_notifyCellInfo = 16;
        static final int TRANSACTION_notifyPreciseCallState = 17;
        static final int TRANSACTION_notifyDisconnectCause = 18;
        static final int TRANSACTION_notifyCellInfoForSubscriber = 19;
        static final int TRANSACTION_notifySrvccStateChanged = 20;
        static final int TRANSACTION_notifySimActivationStateChangedForPhoneId = 21;
        static final int TRANSACTION_notifyOemHookRawEventForSubscriber = 22;
        static final int TRANSACTION_notifySubscriptionInfoChanged = 23;
        static final int TRANSACTION_notifyOpportunisticSubscriptionInfoChanged = 24;
        static final int TRANSACTION_notifyCarrierNetworkChange = 25;
        static final int TRANSACTION_notifyCarrierNetworkChangeForPhoneAndSubId = 26;
        static final int TRANSACTION_notifyUserMobileDataStateChangedForPhoneId = 27;
        static final int TRANSACTION_notifyDisplayInfoChanged = 28;
        static final int TRANSACTION_notifyPhoneCapabilityChanged = 29;
        static final int TRANSACTION_notifyActiveDataSubIdChanged = 30;
        static final int TRANSACTION_notifyRadioPowerStateChanged = 31;
        static final int TRANSACTION_notifyEmergencyNumberList = 32;
        static final int TRANSACTION_notifyOutgoingEmergencyCall = 33;
        static final int TRANSACTION_notifyOutgoingEmergencySms = 34;
        static final int TRANSACTION_notifyCallQualityChanged = 35;
        static final int TRANSACTION_notifyMediaQualityStatusChanged = 36;
        static final int TRANSACTION_notifyImsDisconnectCause = 37;
        static final int TRANSACTION_notifyRegistrationFailed = 38;
        static final int TRANSACTION_notifyBarringInfoChanged = 39;
        static final int TRANSACTION_notifyPhysicalChannelConfigForSubscriber = 40;
        static final int TRANSACTION_notifyDataEnabled = 41;
        static final int TRANSACTION_notifyAllowedNetworkTypesChanged = 42;
        static final int TRANSACTION_notifyLinkCapacityEstimateChanged = 43;
        static final int TRANSACTION_notifySimultaneousCellularCallingSubscriptionsChanged = 44;
        static final int TRANSACTION_addCarrierPrivilegesCallback = 45;
        static final int TRANSACTION_removeCarrierPrivilegesCallback = 46;
        static final int TRANSACTION_notifyCarrierPrivilegesChanged = 47;
        static final int TRANSACTION_notifyCarrierServiceChanged = 48;
        static final int TRANSACTION_addCarrierConfigChangeListener = 49;
        static final int TRANSACTION_removeCarrierConfigChangeListener = 50;
        static final int TRANSACTION_notifyCarrierConfigChanged = 51;
        static final int TRANSACTION_notifyCallbackModeStarted = 52;
        static final int TRANSACTION_notifyCallbackModeRestarted = 53;
        static final int TRANSACTION_notifyCallbackModeStopped = 54;
        static final int TRANSACTION_notifyCarrierRoamingNtnModeChanged = 55;
        static final int TRANSACTION_notifyCarrierRoamingNtnEligibleStateChanged = 56;
        static final int TRANSACTION_notifyCarrierRoamingNtnAvailableServicesChanged = 57;
        static final int TRANSACTION_notifyCarrierRoamingNtnSignalStrengthChanged = 58;
        static final int TRANSACTION_addSatelliteStateChangeListener = 59;
        static final int TRANSACTION_removeSatelliteStateChangeListener = 60;
        static final int TRANSACTION_notifySatelliteStateChanged = 61;
        static final int TRANSACTION_notifySecurityAlgorithmsChanged = 62;
        static final int TRANSACTION_notifyCellularIdentifierDisclosedChanged = 63;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITelephonyRegistry asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITelephonyRegistry) {
                return (ITelephonyRegistry)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addOnSubscriptionsChangedListener";
                }
                case 2: {
                    return "addOnOpportunisticSubscriptionsChangedListener";
                }
                case 3: {
                    return "removeOnSubscriptionsChangedListener";
                }
                case 4: {
                    return "listenWithEventList";
                }
                case 5: {
                    return "notifyCallStateForAllSubs";
                }
                case 6: {
                    return "notifyCallState";
                }
                case 7: {
                    return "notifyServiceStateForPhoneId";
                }
                case 8: {
                    return "notifySignalStrengthForPhoneId";
                }
                case 9: {
                    return "notifyMessageWaitingChangedForPhoneId";
                }
                case 10: {
                    return "notifyCallForwardingChanged";
                }
                case 11: {
                    return "notifyCallForwardingChangedForSubscriber";
                }
                case 12: {
                    return "notifyDataActivityForSubscriber";
                }
                case 13: {
                    return "notifyDataActivityForSubscriberWithSlot";
                }
                case 14: {
                    return "notifyDataConnectionForSubscriber";
                }
                case 15: {
                    return "notifyCellLocationForSubscriber";
                }
                case 16: {
                    return "notifyCellInfo";
                }
                case 17: {
                    return "notifyPreciseCallState";
                }
                case 18: {
                    return "notifyDisconnectCause";
                }
                case 19: {
                    return "notifyCellInfoForSubscriber";
                }
                case 20: {
                    return "notifySrvccStateChanged";
                }
                case 21: {
                    return "notifySimActivationStateChangedForPhoneId";
                }
                case 22: {
                    return "notifyOemHookRawEventForSubscriber";
                }
                case 23: {
                    return "notifySubscriptionInfoChanged";
                }
                case 24: {
                    return "notifyOpportunisticSubscriptionInfoChanged";
                }
                case 25: {
                    return "notifyCarrierNetworkChange";
                }
                case 26: {
                    return "notifyCarrierNetworkChangeForPhoneAndSubId";
                }
                case 27: {
                    return "notifyUserMobileDataStateChangedForPhoneId";
                }
                case 28: {
                    return "notifyDisplayInfoChanged";
                }
                case 29: {
                    return "notifyPhoneCapabilityChanged";
                }
                case 30: {
                    return "notifyActiveDataSubIdChanged";
                }
                case 31: {
                    return "notifyRadioPowerStateChanged";
                }
                case 32: {
                    return "notifyEmergencyNumberList";
                }
                case 33: {
                    return "notifyOutgoingEmergencyCall";
                }
                case 34: {
                    return "notifyOutgoingEmergencySms";
                }
                case 35: {
                    return "notifyCallQualityChanged";
                }
                case 36: {
                    return "notifyMediaQualityStatusChanged";
                }
                case 37: {
                    return "notifyImsDisconnectCause";
                }
                case 38: {
                    return "notifyRegistrationFailed";
                }
                case 39: {
                    return "notifyBarringInfoChanged";
                }
                case 40: {
                    return "notifyPhysicalChannelConfigForSubscriber";
                }
                case 41: {
                    return "notifyDataEnabled";
                }
                case 42: {
                    return "notifyAllowedNetworkTypesChanged";
                }
                case 43: {
                    return "notifyLinkCapacityEstimateChanged";
                }
                case 44: {
                    return "notifySimultaneousCellularCallingSubscriptionsChanged";
                }
                case 45: {
                    return "addCarrierPrivilegesCallback";
                }
                case 46: {
                    return "removeCarrierPrivilegesCallback";
                }
                case 47: {
                    return "notifyCarrierPrivilegesChanged";
                }
                case 48: {
                    return "notifyCarrierServiceChanged";
                }
                case 49: {
                    return "addCarrierConfigChangeListener";
                }
                case 50: {
                    return "removeCarrierConfigChangeListener";
                }
                case 51: {
                    return "notifyCarrierConfigChanged";
                }
                case 52: {
                    return "notifyCallbackModeStarted";
                }
                case 53: {
                    return "notifyCallbackModeRestarted";
                }
                case 54: {
                    return "notifyCallbackModeStopped";
                }
                case 55: {
                    return "notifyCarrierRoamingNtnModeChanged";
                }
                case 56: {
                    return "notifyCarrierRoamingNtnEligibleStateChanged";
                }
                case 57: {
                    return "notifyCarrierRoamingNtnAvailableServicesChanged";
                }
                case 58: {
                    return "notifyCarrierRoamingNtnSignalStrengthChanged";
                }
                case 59: {
                    return "addSatelliteStateChangeListener";
                }
                case 60: {
                    return "removeSatelliteStateChangeListener";
                }
                case 61: {
                    return "notifySatelliteStateChanged";
                }
                case 62: {
                    return "notifySecurityAlgorithmsChanged";
                }
                case 63: {
                    return "notifyCellularIdentifierDisclosedChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IOnSubscriptionsChangedListener _arg2 = IOnSubscriptionsChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnSubscriptionsChangedListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IOnSubscriptionsChangedListener _arg2 = IOnSubscriptionsChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnOpportunisticSubscriptionsChangedListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    IOnSubscriptionsChangedListener _arg1 = IOnSubscriptionsChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnSubscriptionsChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    IPhoneStateListener _arg5 = IPhoneStateListener.Stub.asInterface(data.readStrongBinder());
                    int[] _arg6 = data.createIntArray();
                    boolean _arg7 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.listenWithEventList(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.notifyCallStateForAllSubs(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.notifyCallState(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ServiceState _arg2 = data.readTypedObject(ServiceState.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyServiceStateForPhoneId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    SignalStrength _arg2 = data.readTypedObject(SignalStrength.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySignalStrengthForPhoneId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyMessageWaitingChangedForPhoneId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyCallForwardingChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyCallForwardingChangedForSubscriber(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyDataActivityForSubscriber(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyDataActivityForSubscriberWithSlot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    PreciseDataConnectionState _arg2 = data.readTypedObject(PreciseDataConnectionState.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyDataConnectionForSubscriber(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    CellIdentity _arg1 = data.readTypedObject(CellIdentity.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyCellLocationForSubscriber(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    ArrayList<CellInfo> _arg0 = data.createTypedArrayList(CellInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyCellInfo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    String[] _arg3 = data.createStringArray();
                    int[] _arg4 = data.createIntArray();
                    int[] _arg5 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.notifyPreciseCallState(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyDisconnectCause(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    ArrayList<CellInfo> _arg1 = data.createTypedArrayList(CellInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyCellInfoForSubscriber(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifySrvccStateChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifySimActivationStateChangedForPhoneId(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.notifyOemHookRawEventForSubscriber(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    this.notifySubscriptionInfoChanged();
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    this.notifyOpportunisticSubscriptionInfoChanged();
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyCarrierNetworkChange(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyCarrierNetworkChangeForPhoneAndSubId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyUserMobileDataStateChangedForPhoneId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    TelephonyDisplayInfo _arg2 = data.readTypedObject(TelephonyDisplayInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyDisplayInfoChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    PhoneCapability _arg0 = data.readTypedObject(PhoneCapability.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyPhoneCapabilityChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyActiveDataSubIdChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRadioPowerStateChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyEmergencyNumberList(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    EmergencyNumber _arg2 = data.readTypedObject(EmergencyNumber.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyOutgoingEmergencyCall(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    EmergencyNumber _arg2 = data.readTypedObject(EmergencyNumber.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyOutgoingEmergencySms(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    CallQuality _arg0 = data.readTypedObject(CallQuality.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyCallQualityChanged(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    MediaQualityStatus _arg2 = data.readTypedObject(MediaQualityStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyMediaQualityStatusChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    ImsReasonInfo _arg1 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyImsDisconnectCause(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    CellIdentity _arg2 = data.readTypedObject(CellIdentity.CREATOR);
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRegistrationFailed(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    BarringInfo _arg2 = data.readTypedObject(BarringInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyBarringInfoChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ArrayList<PhysicalChannelConfig> _arg2 = data.createTypedArrayList(PhysicalChannelConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyPhysicalChannelConfigForSubscriber(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyDataEnabled(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.notifyAllowedNetworkTypesChanged(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ArrayList<LinkCapacityEstimate> _arg2 = data.createTypedArrayList(LinkCapacityEstimate.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyLinkCapacityEstimateChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.notifySimultaneousCellularCallingSubscriptionsChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    int _arg0 = data.readInt();
                    ICarrierPrivilegesCallback _arg1 = ICarrierPrivilegesCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.addCarrierPrivilegesCallback(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    ICarrierPrivilegesCallback _arg0 = ICarrierPrivilegesCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeCarrierPrivilegesCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.notifyCarrierPrivilegesChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyCarrierServiceChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    ICarrierConfigChangeListener _arg0 = ICarrierConfigChangeListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.addCarrierConfigChangeListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    ICarrierConfigChangeListener _arg0 = ICarrierConfigChangeListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeCarrierConfigChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyCarrierConfigChanged(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.notifyCallbackModeStarted(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.notifyCallbackModeRestarted(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyCallbackModeStopped(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyCarrierRoamingNtnModeChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyCarrierRoamingNtnEligibleStateChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.notifyCarrierRoamingNtnAvailableServicesChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    NtnSignalStrength _arg1 = data.readTypedObject(NtnSignalStrength.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyCarrierRoamingNtnSignalStrengthChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    ISatelliteStateChangeListener _arg0 = ISatelliteStateChangeListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.addSatelliteStateChangeListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    ISatelliteStateChangeListener _arg0 = ISatelliteStateChangeListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeSatelliteStateChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifySatelliteStateChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 62: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    SecurityAlgorithmUpdate _arg2 = data.readTypedObject(SecurityAlgorithmUpdate.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySecurityAlgorithmsChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 63: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    CellularIdentifierDisclosure _arg2 = data.readTypedObject(CellularIdentifierDisclosure.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyCellularIdentifierDisclosedChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 62;
        }

        private static class Proxy
        implements ITelephonyRegistry {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnSubscriptionsChangedListener(String pkg, String featureId, IOnSubscriptionsChangedListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(featureId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnOpportunisticSubscriptionsChangedListener(String pkg, String featureId, IOnSubscriptionsChangedListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(featureId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnSubscriptionsChangedListener(String pkg, IOnSubscriptionsChangedListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void listenWithEventList(boolean renounceFineLocationAccess, boolean renounceCoarseLocationAccess, int subId, String pkg, String featureId, IPhoneStateListener callback, int[] events, boolean notifyNow) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(renounceFineLocationAccess);
                    _data.writeBoolean(renounceCoarseLocationAccess);
                    _data.writeInt(subId);
                    _data.writeString(pkg);
                    _data.writeString(featureId);
                    _data.writeStrongInterface(callback);
                    _data.writeIntArray(events);
                    _data.writeBoolean(notifyNow);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCallStateForAllSubs(int state, String incomingNumber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeString(incomingNumber);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCallState(int phoneId, int subId, int state, String incomingNumber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(state);
                    _data.writeString(incomingNumber);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyServiceStateForPhoneId(int phoneId, int subId, ServiceState state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedObject(state, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySignalStrengthForPhoneId(int phoneId, int subId, SignalStrength signalStrength) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedObject(signalStrength, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyMessageWaitingChangedForPhoneId(int phoneId, int subId, boolean mwi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeBoolean(mwi);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCallForwardingChanged(boolean cfi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(cfi);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCallForwardingChangedForSubscriber(int subId, boolean cfi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeBoolean(cfi);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDataActivityForSubscriber(int subId, int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDataActivityForSubscriberWithSlot(int phoneId, int subId, int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDataConnectionForSubscriber(int phoneId, int subId, PreciseDataConnectionState preciseState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedObject(preciseState, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCellLocationForSubscriber(int subId, CellIdentity cellLocation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeTypedObject(cellLocation, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCellInfo(List<CellInfo> cellInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(cellInfo, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPreciseCallState(int phoneId, int subId, int[] callStates, String[] imsCallIds, int[] imsCallServiceTypes, int[] imsCallTypes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeIntArray(callStates);
                    _data.writeStringArray(imsCallIds);
                    _data.writeIntArray(imsCallServiceTypes);
                    _data.writeIntArray(imsCallTypes);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDisconnectCause(int phoneId, int subId, int disconnectCause, int preciseDisconnectCause) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(disconnectCause);
                    _data.writeInt(preciseDisconnectCause);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCellInfoForSubscriber(int subId, List<CellInfo> cellInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeTypedList(cellInfo, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySrvccStateChanged(int subId, int lteState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(lteState);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySimActivationStateChangedForPhoneId(int phoneId, int subId, int activationState, int activationType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(activationState);
                    _data.writeInt(activationType);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyOemHookRawEventForSubscriber(int phoneId, int subId, byte[] rawData) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeByteArray(rawData);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySubscriptionInfoChanged() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyOpportunisticSubscriptionInfoChanged() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierNetworkChange(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierNetworkChangeForPhoneAndSubId(int phoneId, int subId, boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyUserMobileDataStateChangedForPhoneId(int phoneId, int subId, boolean state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeBoolean(state);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDisplayInfoChanged(int slotIndex, int subId, TelephonyDisplayInfo telephonyDisplayInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    _data.writeInt(subId);
                    _data.writeTypedObject(telephonyDisplayInfo, 0);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPhoneCapabilityChanged(PhoneCapability capability) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(capability, 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyActiveDataSubIdChanged(int activeDataSubId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(activeDataSubId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRadioPowerStateChanged(int phoneId, int subId, int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyEmergencyNumberList(int phoneId, int subId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyOutgoingEmergencyCall(int phoneId, int subId, EmergencyNumber emergencyNumber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedObject(emergencyNumber, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyOutgoingEmergencySms(int phoneId, int subId, EmergencyNumber emergencyNumber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedObject(emergencyNumber, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCallQualityChanged(CallQuality callQuality, int phoneId, int subId, int callNetworkType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(callQuality, 0);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(callNetworkType);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyMediaQualityStatusChanged(int phoneId, int subId, MediaQualityStatus status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedObject(status, 0);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyImsDisconnectCause(int subId, ImsReasonInfo imsReasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeTypedObject(imsReasonInfo, 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRegistrationFailed(int slotIndex, int subId, CellIdentity cellIdentity, String chosenPlmn, int domain, int causeCode, int additionalCauseCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    _data.writeInt(subId);
                    _data.writeTypedObject(cellIdentity, 0);
                    _data.writeString(chosenPlmn);
                    _data.writeInt(domain);
                    _data.writeInt(causeCode);
                    _data.writeInt(additionalCauseCode);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyBarringInfoChanged(int slotIndex, int subId, BarringInfo barringInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    _data.writeInt(subId);
                    _data.writeTypedObject(barringInfo, 0);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPhysicalChannelConfigForSubscriber(int phoneId, int subId, List<PhysicalChannelConfig> configs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedList(configs, 0);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDataEnabled(int phoneId, int subId, boolean enabled, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeBoolean(enabled);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAllowedNetworkTypesChanged(int phoneId, int subId, int reason, long allowedNetworkType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(reason);
                    _data.writeLong(allowedNetworkType);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyLinkCapacityEstimateChanged(int phoneId, int subId, List<LinkCapacityEstimate> linkCapacityEstimateList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedList(linkCapacityEstimateList, 0);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySimultaneousCellularCallingSubscriptionsChanged(int[] subIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(subIds);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCarrierPrivilegesCallback(int phoneId, ICarrierPrivilegesCallback callback, String pkg, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeStrongInterface(callback);
                    _data.writeString(pkg);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCarrierPrivilegesCallback(ICarrierPrivilegesCallback callback, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierPrivilegesChanged(int phoneId, List<String> privilegedPackageNames, int[] privilegedUids) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeStringList(privilegedPackageNames);
                    _data.writeIntArray(privilegedUids);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierServiceChanged(int phoneId, String packageName, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCarrierConfigChangeListener(ICarrierConfigChangeListener listener, String pkg, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(pkg);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCarrierConfigChangeListener(ICarrierConfigChangeListener listener, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierConfigChanged(int phoneId, int subId, int carrierId, int specificCarrierId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(carrierId);
                    _data.writeInt(specificCarrierId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCallbackModeStarted(int phoneId, int subId, int type, long durationMillis) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(type);
                    _data.writeLong(durationMillis);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCallbackModeRestarted(int phoneId, int subId, int type, long durationMillis) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(type);
                    _data.writeLong(durationMillis);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCallbackModeStopped(int phoneId, int subId, int type, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeInt(type);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierRoamingNtnModeChanged(int subId, boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierRoamingNtnEligibleStateChanged(int subId, boolean eligible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeBoolean(eligible);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierRoamingNtnAvailableServicesChanged(int subId, int[] availableServices) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeIntArray(availableServices);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCarrierRoamingNtnSignalStrengthChanged(int subId, NtnSignalStrength ntnSignalStrength) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeTypedObject(ntnSignalStrength, 0);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSatelliteStateChangeListener(ISatelliteStateChangeListener listener, String pkg, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(pkg);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSatelliteStateChangeListener(ISatelliteStateChangeListener listener, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySatelliteStateChanged(boolean isEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isEnabled);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySecurityAlgorithmsChanged(int phoneId, int subId, SecurityAlgorithmUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedObject(update, 0);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCellularIdentifierDisclosedChanged(int phoneId, int subId, CellularIdentifierDisclosure disclosure) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeInt(subId);
                    _data.writeTypedObject(disclosure, 0);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITelephonyRegistry {
        @Override
        public void addOnSubscriptionsChangedListener(String pkg, String featureId, IOnSubscriptionsChangedListener callback) throws RemoteException {
        }

        @Override
        public void addOnOpportunisticSubscriptionsChangedListener(String pkg, String featureId, IOnSubscriptionsChangedListener callback) throws RemoteException {
        }

        @Override
        public void removeOnSubscriptionsChangedListener(String pkg, IOnSubscriptionsChangedListener callback) throws RemoteException {
        }

        @Override
        public void listenWithEventList(boolean renounceFineLocationAccess, boolean renounceCoarseLocationAccess, int subId, String pkg, String featureId, IPhoneStateListener callback, int[] events, boolean notifyNow) throws RemoteException {
        }

        @Override
        public void notifyCallStateForAllSubs(int state, String incomingNumber) throws RemoteException {
        }

        @Override
        public void notifyCallState(int phoneId, int subId, int state, String incomingNumber) throws RemoteException {
        }

        @Override
        public void notifyServiceStateForPhoneId(int phoneId, int subId, ServiceState state) throws RemoteException {
        }

        @Override
        public void notifySignalStrengthForPhoneId(int phoneId, int subId, SignalStrength signalStrength) throws RemoteException {
        }

        @Override
        public void notifyMessageWaitingChangedForPhoneId(int phoneId, int subId, boolean mwi) throws RemoteException {
        }

        @Override
        public void notifyCallForwardingChanged(boolean cfi) throws RemoteException {
        }

        @Override
        public void notifyCallForwardingChangedForSubscriber(int subId, boolean cfi) throws RemoteException {
        }

        @Override
        public void notifyDataActivityForSubscriber(int subId, int state) throws RemoteException {
        }

        @Override
        public void notifyDataActivityForSubscriberWithSlot(int phoneId, int subId, int state) throws RemoteException {
        }

        @Override
        public void notifyDataConnectionForSubscriber(int phoneId, int subId, PreciseDataConnectionState preciseState) throws RemoteException {
        }

        @Override
        public void notifyCellLocationForSubscriber(int subId, CellIdentity cellLocation) throws RemoteException {
        }

        @Override
        public void notifyCellInfo(List<CellInfo> cellInfo) throws RemoteException {
        }

        @Override
        public void notifyPreciseCallState(int phoneId, int subId, int[] callStates, String[] imsCallIds, int[] imsCallServiceTypes, int[] imsCallTypes) throws RemoteException {
        }

        @Override
        public void notifyDisconnectCause(int phoneId, int subId, int disconnectCause, int preciseDisconnectCause) throws RemoteException {
        }

        @Override
        public void notifyCellInfoForSubscriber(int subId, List<CellInfo> cellInfo) throws RemoteException {
        }

        @Override
        public void notifySrvccStateChanged(int subId, int lteState) throws RemoteException {
        }

        @Override
        public void notifySimActivationStateChangedForPhoneId(int phoneId, int subId, int activationState, int activationType) throws RemoteException {
        }

        @Override
        public void notifyOemHookRawEventForSubscriber(int phoneId, int subId, byte[] rawData) throws RemoteException {
        }

        @Override
        public void notifySubscriptionInfoChanged() throws RemoteException {
        }

        @Override
        public void notifyOpportunisticSubscriptionInfoChanged() throws RemoteException {
        }

        @Override
        public void notifyCarrierNetworkChange(boolean active) throws RemoteException {
        }

        @Override
        public void notifyCarrierNetworkChangeForPhoneAndSubId(int phoneId, int subId, boolean active) throws RemoteException {
        }

        @Override
        public void notifyUserMobileDataStateChangedForPhoneId(int phoneId, int subId, boolean state) throws RemoteException {
        }

        @Override
        public void notifyDisplayInfoChanged(int slotIndex, int subId, TelephonyDisplayInfo telephonyDisplayInfo) throws RemoteException {
        }

        @Override
        public void notifyPhoneCapabilityChanged(PhoneCapability capability) throws RemoteException {
        }

        @Override
        public void notifyActiveDataSubIdChanged(int activeDataSubId) throws RemoteException {
        }

        @Override
        public void notifyRadioPowerStateChanged(int phoneId, int subId, int state) throws RemoteException {
        }

        @Override
        public void notifyEmergencyNumberList(int phoneId, int subId) throws RemoteException {
        }

        @Override
        public void notifyOutgoingEmergencyCall(int phoneId, int subId, EmergencyNumber emergencyNumber) throws RemoteException {
        }

        @Override
        public void notifyOutgoingEmergencySms(int phoneId, int subId, EmergencyNumber emergencyNumber) throws RemoteException {
        }

        @Override
        public void notifyCallQualityChanged(CallQuality callQuality, int phoneId, int subId, int callNetworkType) throws RemoteException {
        }

        @Override
        public void notifyMediaQualityStatusChanged(int phoneId, int subId, MediaQualityStatus status) throws RemoteException {
        }

        @Override
        public void notifyImsDisconnectCause(int subId, ImsReasonInfo imsReasonInfo) throws RemoteException {
        }

        @Override
        public void notifyRegistrationFailed(int slotIndex, int subId, CellIdentity cellIdentity, String chosenPlmn, int domain, int causeCode, int additionalCauseCode) throws RemoteException {
        }

        @Override
        public void notifyBarringInfoChanged(int slotIndex, int subId, BarringInfo barringInfo) throws RemoteException {
        }

        @Override
        public void notifyPhysicalChannelConfigForSubscriber(int phoneId, int subId, List<PhysicalChannelConfig> configs) throws RemoteException {
        }

        @Override
        public void notifyDataEnabled(int phoneId, int subId, boolean enabled, int reason) throws RemoteException {
        }

        @Override
        public void notifyAllowedNetworkTypesChanged(int phoneId, int subId, int reason, long allowedNetworkType) throws RemoteException {
        }

        @Override
        public void notifyLinkCapacityEstimateChanged(int phoneId, int subId, List<LinkCapacityEstimate> linkCapacityEstimateList) throws RemoteException {
        }

        @Override
        public void notifySimultaneousCellularCallingSubscriptionsChanged(int[] subIds) throws RemoteException {
        }

        @Override
        public void addCarrierPrivilegesCallback(int phoneId, ICarrierPrivilegesCallback callback, String pkg, String featureId) throws RemoteException {
        }

        @Override
        public void removeCarrierPrivilegesCallback(ICarrierPrivilegesCallback callback, String pkg) throws RemoteException {
        }

        @Override
        public void notifyCarrierPrivilegesChanged(int phoneId, List<String> privilegedPackageNames, int[] privilegedUids) throws RemoteException {
        }

        @Override
        public void notifyCarrierServiceChanged(int phoneId, String packageName, int uid) throws RemoteException {
        }

        @Override
        public void addCarrierConfigChangeListener(ICarrierConfigChangeListener listener, String pkg, String featureId) throws RemoteException {
        }

        @Override
        public void removeCarrierConfigChangeListener(ICarrierConfigChangeListener listener, String pkg) throws RemoteException {
        }

        @Override
        public void notifyCarrierConfigChanged(int phoneId, int subId, int carrierId, int specificCarrierId) throws RemoteException {
        }

        @Override
        public void notifyCallbackModeStarted(int phoneId, int subId, int type, long durationMillis) throws RemoteException {
        }

        @Override
        public void notifyCallbackModeRestarted(int phoneId, int subId, int type, long durationMillis) throws RemoteException {
        }

        @Override
        public void notifyCallbackModeStopped(int phoneId, int subId, int type, int reason) throws RemoteException {
        }

        @Override
        public void notifyCarrierRoamingNtnModeChanged(int subId, boolean active) throws RemoteException {
        }

        @Override
        public void notifyCarrierRoamingNtnEligibleStateChanged(int subId, boolean eligible) throws RemoteException {
        }

        @Override
        public void notifyCarrierRoamingNtnAvailableServicesChanged(int subId, int[] availableServices) throws RemoteException {
        }

        @Override
        public void notifyCarrierRoamingNtnSignalStrengthChanged(int subId, NtnSignalStrength ntnSignalStrength) throws RemoteException {
        }

        @Override
        public void addSatelliteStateChangeListener(ISatelliteStateChangeListener listener, String pkg, String featureId) throws RemoteException {
        }

        @Override
        public void removeSatelliteStateChangeListener(ISatelliteStateChangeListener listener, String pkg) throws RemoteException {
        }

        @Override
        public void notifySatelliteStateChanged(boolean isEnabled) throws RemoteException {
        }

        @Override
        public void notifySecurityAlgorithmsChanged(int phoneId, int subId, SecurityAlgorithmUpdate update) throws RemoteException {
        }

        @Override
        public void notifyCellularIdentifierDisclosedChanged(int phoneId, int subId, CellularIdentifierDisclosure disclosure) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

