/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.app.Notification;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.graphics.drawable.Icon;
import android.hardware.biometrics.IBiometricContextListener;
import android.hardware.biometrics.IBiometricSysuiReceiver;
import android.hardware.biometrics.PromptInfo;
import android.hardware.fingerprint.IUdfpsRefreshRateRequestCallback;
import android.media.INearbyMediaDevicesProvider;
import android.media.MediaRoute2Info;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.android.internal.logging.InstanceId;
import com.android.internal.statusbar.IAddTileResultCallback;
import com.android.internal.statusbar.ISessionListener;
import com.android.internal.statusbar.IStatusBar;
import com.android.internal.statusbar.IUndoMediaTransferCallback;
import com.android.internal.statusbar.NotificationVisibility;
import com.android.internal.statusbar.RegisterStatusBarResult;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;

public interface IStatusBarService
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/statusbar/IStatusBarService.aidl:48:1:48:25")
    public void expandNotificationsPanel() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/statusbar/IStatusBarService.aidl:50:1:50:25")
    public void collapsePanels() throws RemoteException;

    public void togglePanel() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/statusbar/IStatusBarService.aidl:53:1:53:25")
    public void disable(int var1, IBinder var2, String var3) throws RemoteException;

    public void disableForUser(int var1, IBinder var2, String var3, int var4) throws RemoteException;

    public void disable2(int var1, IBinder var2, String var3) throws RemoteException;

    public void disable2ForUser(int var1, IBinder var2, String var3, int var4) throws RemoteException;

    public int[] getDisableFlags(IBinder var1, int var2) throws RemoteException;

    public void setIcon(String var1, String var2, int var3, int var4, String var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/statusbar/IStatusBarService.aidl:60:1:60:25")
    public void setIconVisibility(String var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/statusbar/IStatusBarService.aidl:62:1:62:25")
    public void removeIcon(String var1) throws RemoteException;

    public void setImeWindowStatus(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public void expandSettingsPanel(String var1) throws RemoteException;

    public RegisterStatusBarResult registerStatusBar(IStatusBar var1) throws RemoteException;

    public Map<String, RegisterStatusBarResult> registerStatusBarForAllDisplays(IStatusBar var1) throws RemoteException;

    public void onPanelRevealed(boolean var1, int var2) throws RemoteException;

    public void onPanelHidden() throws RemoteException;

    public void clearNotificationEffects() throws RemoteException;

    public void onNotificationClick(String var1, NotificationVisibility var2) throws RemoteException;

    public void onNotificationActionClick(String var1, int var2, Notification.Action var3, NotificationVisibility var4, boolean var5) throws RemoteException;

    public void onNotificationError(String var1, String var2, int var3, int var4, int var5, String var6, int var7) throws RemoteException;

    public void onClearAllNotifications(int var1) throws RemoteException;

    public void onNotificationClear(String var1, int var2, String var3, int var4, int var5, NotificationVisibility var6, boolean var7) throws RemoteException;

    public void onNotificationVisibilityChanged(NotificationVisibility[] var1, NotificationVisibility[] var2) throws RemoteException;

    public void onNotificationExpansionChanged(String var1, boolean var2, boolean var3, int var4) throws RemoteException;

    public void onNotificationDirectReplied(String var1) throws RemoteException;

    public void onNotificationSmartSuggestionsAdded(String var1, int var2, int var3, boolean var4, boolean var5) throws RemoteException;

    public void onNotificationSmartReplySent(String var1, int var2, CharSequence var3, int var4, boolean var5) throws RemoteException;

    public void onNotificationSettingsViewed(String var1) throws RemoteException;

    public void onNotificationBubbleChanged(String var1, boolean var2, int var3) throws RemoteException;

    public void onBubbleMetadataFlagChanged(String var1, int var2) throws RemoteException;

    public void hideCurrentInputMethodForBubbles(int var1) throws RemoteException;

    public void grantInlineReplyUriPermission(String var1, Uri var2, UserHandle var3, String var4) throws RemoteException;

    public void clearInlineReplyUriPermissions(String var1) throws RemoteException;

    public void onNotificationFeedbackReceived(String var1, Bundle var2) throws RemoteException;

    public void onGlobalActionsShown() throws RemoteException;

    public void onGlobalActionsHidden() throws RemoteException;

    public void shutdown() throws RemoteException;

    public void reboot(boolean var1) throws RemoteException;

    public void restart() throws RemoteException;

    public void addTile(ComponentName var1) throws RemoteException;

    public void remTile(ComponentName var1) throws RemoteException;

    public void clickTile(ComponentName var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/statusbar/IStatusBarService.aidl:127:1:127:25")
    public void handleSystemKey(KeyEvent var1) throws RemoteException;

    public int getLastSystemKey() throws RemoteException;

    public void showPinningEnterExitToast(boolean var1) throws RemoteException;

    public void showPinningEscapeToast() throws RemoteException;

    public void showAuthenticationDialog(PromptInfo var1, IBiometricSysuiReceiver var2, int[] var3, boolean var4, boolean var5, int var6, long var7, String var9, long var10) throws RemoteException;

    public void onBiometricAuthenticated(int var1) throws RemoteException;

    public void onBiometricHelp(int var1, String var2) throws RemoteException;

    public void onBiometricError(int var1, int var2, int var3) throws RemoteException;

    public void hideAuthenticationDialog(long var1) throws RemoteException;

    public void setBiometicContextListener(IBiometricContextListener var1) throws RemoteException;

    public void setUdfpsRefreshRateCallback(IUdfpsRefreshRateRequestCallback var1) throws RemoteException;

    public void showInattentiveSleepWarning() throws RemoteException;

    public void dismissInattentiveSleepWarning(boolean var1) throws RemoteException;

    public void startTracing() throws RemoteException;

    public void stopTracing() throws RemoteException;

    public boolean isTracing() throws RemoteException;

    public void suppressAmbientDisplay(boolean var1) throws RemoteException;

    public void requestTileServiceListeningState(ComponentName var1, int var2) throws RemoteException;

    public void requestAddTile(ComponentName var1, CharSequence var2, Icon var3, int var4, IAddTileResultCallback var5) throws RemoteException;

    public void cancelRequestAddTile(String var1) throws RemoteException;

    public void setNavBarMode(int var1) throws RemoteException;

    public int getNavBarMode() throws RemoteException;

    public void registerSessionListener(int var1, ISessionListener var2) throws RemoteException;

    public void unregisterSessionListener(int var1, ISessionListener var2) throws RemoteException;

    public void onSessionStarted(int var1, InstanceId var2) throws RemoteException;

    public void onSessionEnded(int var1, InstanceId var2) throws RemoteException;

    public void updateMediaTapToTransferSenderDisplay(int var1, MediaRoute2Info var2, IUndoMediaTransferCallback var3) throws RemoteException;

    public void updateMediaTapToTransferReceiverDisplay(int var1, MediaRoute2Info var2, Icon var3, CharSequence var4) throws RemoteException;

    public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider var1) throws RemoteException;

    public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider var1) throws RemoteException;

    public void showRearDisplayDialog(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatusBarService {
        public static final String DESCRIPTOR = "com.android.internal.statusbar.IStatusBarService";
        static final int TRANSACTION_expandNotificationsPanel = 1;
        static final int TRANSACTION_collapsePanels = 2;
        static final int TRANSACTION_togglePanel = 3;
        static final int TRANSACTION_disable = 4;
        static final int TRANSACTION_disableForUser = 5;
        static final int TRANSACTION_disable2 = 6;
        static final int TRANSACTION_disable2ForUser = 7;
        static final int TRANSACTION_getDisableFlags = 8;
        static final int TRANSACTION_setIcon = 9;
        static final int TRANSACTION_setIconVisibility = 10;
        static final int TRANSACTION_removeIcon = 11;
        static final int TRANSACTION_setImeWindowStatus = 12;
        static final int TRANSACTION_expandSettingsPanel = 13;
        static final int TRANSACTION_registerStatusBar = 14;
        static final int TRANSACTION_registerStatusBarForAllDisplays = 15;
        static final int TRANSACTION_onPanelRevealed = 16;
        static final int TRANSACTION_onPanelHidden = 17;
        static final int TRANSACTION_clearNotificationEffects = 18;
        static final int TRANSACTION_onNotificationClick = 19;
        static final int TRANSACTION_onNotificationActionClick = 20;
        static final int TRANSACTION_onNotificationError = 21;
        static final int TRANSACTION_onClearAllNotifications = 22;
        static final int TRANSACTION_onNotificationClear = 23;
        static final int TRANSACTION_onNotificationVisibilityChanged = 24;
        static final int TRANSACTION_onNotificationExpansionChanged = 25;
        static final int TRANSACTION_onNotificationDirectReplied = 26;
        static final int TRANSACTION_onNotificationSmartSuggestionsAdded = 27;
        static final int TRANSACTION_onNotificationSmartReplySent = 28;
        static final int TRANSACTION_onNotificationSettingsViewed = 29;
        static final int TRANSACTION_onNotificationBubbleChanged = 30;
        static final int TRANSACTION_onBubbleMetadataFlagChanged = 31;
        static final int TRANSACTION_hideCurrentInputMethodForBubbles = 32;
        static final int TRANSACTION_grantInlineReplyUriPermission = 33;
        static final int TRANSACTION_clearInlineReplyUriPermissions = 34;
        static final int TRANSACTION_onNotificationFeedbackReceived = 35;
        static final int TRANSACTION_onGlobalActionsShown = 36;
        static final int TRANSACTION_onGlobalActionsHidden = 37;
        static final int TRANSACTION_shutdown = 38;
        static final int TRANSACTION_reboot = 39;
        static final int TRANSACTION_restart = 40;
        static final int TRANSACTION_addTile = 41;
        static final int TRANSACTION_remTile = 42;
        static final int TRANSACTION_clickTile = 43;
        static final int TRANSACTION_handleSystemKey = 44;
        static final int TRANSACTION_getLastSystemKey = 45;
        static final int TRANSACTION_showPinningEnterExitToast = 46;
        static final int TRANSACTION_showPinningEscapeToast = 47;
        static final int TRANSACTION_showAuthenticationDialog = 48;
        static final int TRANSACTION_onBiometricAuthenticated = 49;
        static final int TRANSACTION_onBiometricHelp = 50;
        static final int TRANSACTION_onBiometricError = 51;
        static final int TRANSACTION_hideAuthenticationDialog = 52;
        static final int TRANSACTION_setBiometicContextListener = 53;
        static final int TRANSACTION_setUdfpsRefreshRateCallback = 54;
        static final int TRANSACTION_showInattentiveSleepWarning = 55;
        static final int TRANSACTION_dismissInattentiveSleepWarning = 56;
        static final int TRANSACTION_startTracing = 57;
        static final int TRANSACTION_stopTracing = 58;
        static final int TRANSACTION_isTracing = 59;
        static final int TRANSACTION_suppressAmbientDisplay = 60;
        static final int TRANSACTION_requestTileServiceListeningState = 61;
        static final int TRANSACTION_requestAddTile = 62;
        static final int TRANSACTION_cancelRequestAddTile = 63;
        static final int TRANSACTION_setNavBarMode = 64;
        static final int TRANSACTION_getNavBarMode = 65;
        static final int TRANSACTION_registerSessionListener = 66;
        static final int TRANSACTION_unregisterSessionListener = 67;
        static final int TRANSACTION_onSessionStarted = 68;
        static final int TRANSACTION_onSessionEnded = 69;
        static final int TRANSACTION_updateMediaTapToTransferSenderDisplay = 70;
        static final int TRANSACTION_updateMediaTapToTransferReceiverDisplay = 71;
        static final int TRANSACTION_registerNearbyMediaDevicesProvider = 72;
        static final int TRANSACTION_unregisterNearbyMediaDevicesProvider = 73;
        static final int TRANSACTION_showRearDisplayDialog = 74;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatusBarService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatusBarService) {
                return (IStatusBarService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "expandNotificationsPanel";
                }
                case 2: {
                    return "collapsePanels";
                }
                case 3: {
                    return "togglePanel";
                }
                case 4: {
                    return "disable";
                }
                case 5: {
                    return "disableForUser";
                }
                case 6: {
                    return "disable2";
                }
                case 7: {
                    return "disable2ForUser";
                }
                case 8: {
                    return "getDisableFlags";
                }
                case 9: {
                    return "setIcon";
                }
                case 10: {
                    return "setIconVisibility";
                }
                case 11: {
                    return "removeIcon";
                }
                case 12: {
                    return "setImeWindowStatus";
                }
                case 13: {
                    return "expandSettingsPanel";
                }
                case 14: {
                    return "registerStatusBar";
                }
                case 15: {
                    return "registerStatusBarForAllDisplays";
                }
                case 16: {
                    return "onPanelRevealed";
                }
                case 17: {
                    return "onPanelHidden";
                }
                case 18: {
                    return "clearNotificationEffects";
                }
                case 19: {
                    return "onNotificationClick";
                }
                case 20: {
                    return "onNotificationActionClick";
                }
                case 21: {
                    return "onNotificationError";
                }
                case 22: {
                    return "onClearAllNotifications";
                }
                case 23: {
                    return "onNotificationClear";
                }
                case 24: {
                    return "onNotificationVisibilityChanged";
                }
                case 25: {
                    return "onNotificationExpansionChanged";
                }
                case 26: {
                    return "onNotificationDirectReplied";
                }
                case 27: {
                    return "onNotificationSmartSuggestionsAdded";
                }
                case 28: {
                    return "onNotificationSmartReplySent";
                }
                case 29: {
                    return "onNotificationSettingsViewed";
                }
                case 30: {
                    return "onNotificationBubbleChanged";
                }
                case 31: {
                    return "onBubbleMetadataFlagChanged";
                }
                case 32: {
                    return "hideCurrentInputMethodForBubbles";
                }
                case 33: {
                    return "grantInlineReplyUriPermission";
                }
                case 34: {
                    return "clearInlineReplyUriPermissions";
                }
                case 35: {
                    return "onNotificationFeedbackReceived";
                }
                case 36: {
                    return "onGlobalActionsShown";
                }
                case 37: {
                    return "onGlobalActionsHidden";
                }
                case 38: {
                    return "shutdown";
                }
                case 39: {
                    return "reboot";
                }
                case 40: {
                    return "restart";
                }
                case 41: {
                    return "addTile";
                }
                case 42: {
                    return "remTile";
                }
                case 43: {
                    return "clickTile";
                }
                case 44: {
                    return "handleSystemKey";
                }
                case 45: {
                    return "getLastSystemKey";
                }
                case 46: {
                    return "showPinningEnterExitToast";
                }
                case 47: {
                    return "showPinningEscapeToast";
                }
                case 48: {
                    return "showAuthenticationDialog";
                }
                case 49: {
                    return "onBiometricAuthenticated";
                }
                case 50: {
                    return "onBiometricHelp";
                }
                case 51: {
                    return "onBiometricError";
                }
                case 52: {
                    return "hideAuthenticationDialog";
                }
                case 53: {
                    return "setBiometicContextListener";
                }
                case 54: {
                    return "setUdfpsRefreshRateCallback";
                }
                case 55: {
                    return "showInattentiveSleepWarning";
                }
                case 56: {
                    return "dismissInattentiveSleepWarning";
                }
                case 57: {
                    return "startTracing";
                }
                case 58: {
                    return "stopTracing";
                }
                case 59: {
                    return "isTracing";
                }
                case 60: {
                    return "suppressAmbientDisplay";
                }
                case 61: {
                    return "requestTileServiceListeningState";
                }
                case 62: {
                    return "requestAddTile";
                }
                case 63: {
                    return "cancelRequestAddTile";
                }
                case 64: {
                    return "setNavBarMode";
                }
                case 65: {
                    return "getNavBarMode";
                }
                case 66: {
                    return "registerSessionListener";
                }
                case 67: {
                    return "unregisterSessionListener";
                }
                case 68: {
                    return "onSessionStarted";
                }
                case 69: {
                    return "onSessionEnded";
                }
                case 70: {
                    return "updateMediaTapToTransferSenderDisplay";
                }
                case 71: {
                    return "updateMediaTapToTransferReceiverDisplay";
                }
                case 72: {
                    return "registerNearbyMediaDevicesProvider";
                }
                case 73: {
                    return "unregisterNearbyMediaDevicesProvider";
                }
                case 74: {
                    return "showRearDisplayDialog";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.expandNotificationsPanel();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.collapsePanels();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    this.togglePanel();
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.disable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableForUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.disable2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disable2ForUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int[] _result = this.getDisableFlags(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setIcon(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setIconVisibility(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeIcon(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setImeWindowStatus(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.expandSettingsPanel(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IStatusBar _arg0 = IStatusBar.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    RegisterStatusBarResult _result = this.registerStatusBar(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 15: {
                    IStatusBar _arg0 = IStatusBar.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    Map<String, RegisterStatusBarResult> _result = this.registerStatusBarForAllDisplays(_arg0);
                    reply.writeNoException();
                    if (_result == null) {
                        reply.writeInt(-1);
                        break;
                    }
                    reply.writeInt(_result.size());
                    _result.forEach((k, v) -> {
                        reply.writeString((String)k);
                        reply.writeTypedObject(v, 1);
                    });
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPanelRevealed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    this.onPanelHidden();
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    this.clearNotificationEffects();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    NotificationVisibility _arg1 = data.readTypedObject(NotificationVisibility.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNotificationClick(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Notification.Action _arg2 = data.readTypedObject(Notification.Action.CREATOR);
                    NotificationVisibility _arg3 = data.readTypedObject(NotificationVisibility.CREATOR);
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onNotificationActionClick(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNotificationError(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onClearAllNotifications(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    NotificationVisibility _arg5 = data.readTypedObject(NotificationVisibility.CREATOR);
                    boolean _arg6 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onNotificationClear(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    NotificationVisibility[] _arg0 = data.createTypedArray(NotificationVisibility.CREATOR);
                    NotificationVisibility[] _arg1 = data.createTypedArray(NotificationVisibility.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNotificationVisibilityChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNotificationExpansionChanged(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onNotificationDirectReplied(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onNotificationSmartSuggestionsAdded(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    CharSequence _arg2 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onNotificationSmartReplySent(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onNotificationSettingsViewed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNotificationBubbleChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBubbleMetadataFlagChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.hideCurrentInputMethodForBubbles(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.grantInlineReplyUriPermission(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearInlineReplyUriPermissions(_arg0);
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNotificationFeedbackReceived(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    this.onGlobalActionsShown();
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    this.onGlobalActionsHidden();
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    this.shutdown();
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reboot(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    this.restart();
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.addTile(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.remTile(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.clickTile(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    KeyEvent _arg0 = data.readTypedObject(KeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.handleSystemKey(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    int _result = this.getLastSystemKey();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 46: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showPinningEnterExitToast(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    this.showPinningEscapeToast();
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    PromptInfo _arg0 = data.readTypedObject(PromptInfo.CREATOR);
                    IBiometricSysuiReceiver _arg1 = IBiometricSysuiReceiver.Stub.asInterface(data.readStrongBinder());
                    int[] _arg2 = data.createIntArray();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    int _arg5 = data.readInt();
                    long _arg6 = data.readLong();
                    String _arg7 = data.readString();
                    long _arg8 = data.readLong();
                    data.enforceNoDataAvail();
                    this.showAuthenticationDialog(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiometricAuthenticated(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onBiometricHelp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiometricError(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.hideAuthenticationDialog(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    IBiometricContextListener _arg0 = IBiometricContextListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setBiometicContextListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    IUdfpsRefreshRateRequestCallback _arg0 = IUdfpsRefreshRateRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setUdfpsRefreshRateCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    this.showInattentiveSleepWarning();
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dismissInattentiveSleepWarning(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    this.startTracing();
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    this.stopTracing();
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    boolean _result = this.isTracing();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 60: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.suppressAmbientDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestTileServiceListeningState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 62: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    Icon _arg2 = data.readTypedObject(Icon.CREATOR);
                    int _arg3 = data.readInt();
                    IAddTileResultCallback _arg4 = IAddTileResultCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestAddTile(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 63: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.cancelRequestAddTile(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setNavBarMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    int _result = this.getNavBarMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 66: {
                    int _arg0 = data.readInt();
                    ISessionListener _arg1 = ISessionListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSessionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    int _arg0 = data.readInt();
                    ISessionListener _arg1 = ISessionListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSessionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    int _arg0 = data.readInt();
                    InstanceId _arg1 = data.readTypedObject(InstanceId.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSessionStarted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    int _arg0 = data.readInt();
                    InstanceId _arg1 = data.readTypedObject(InstanceId.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSessionEnded(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 70: {
                    int _arg0 = data.readInt();
                    MediaRoute2Info _arg1 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    IUndoMediaTransferCallback _arg2 = IUndoMediaTransferCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updateMediaTapToTransferSenderDisplay(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 71: {
                    int _arg0 = data.readInt();
                    MediaRoute2Info _arg1 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    Icon _arg2 = data.readTypedObject(Icon.CREATOR);
                    CharSequence _arg3 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.updateMediaTapToTransferReceiverDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 72: {
                    INearbyMediaDevicesProvider _arg0 = INearbyMediaDevicesProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerNearbyMediaDevicesProvider(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    INearbyMediaDevicesProvider _arg0 = INearbyMediaDevicesProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterNearbyMediaDevicesProvider(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 74: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showRearDisplayDialog(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 73;
        }

        private static class Proxy
        implements IStatusBarService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void expandNotificationsPanel() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void collapsePanels() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void togglePanel() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable(int what, IBinder token, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(what);
                    _data.writeStrongBinder(token);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableForUser(int what, IBinder token, String pkg, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(what);
                    _data.writeStrongBinder(token);
                    _data.writeString(pkg);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable2(int what, IBinder token, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(what);
                    _data.writeStrongBinder(token);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable2ForUser(int what, IBinder token, String pkg, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(what);
                    _data.writeStrongBinder(token);
                    _data.writeString(pkg);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getDisableFlags(IBinder token, int userId) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIcon(String slot, String iconPackage, int iconId, int iconLevel, String contentDescription) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    _data.writeString(iconPackage);
                    _data.writeInt(iconId);
                    _data.writeInt(iconLevel);
                    _data.writeString(contentDescription);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIconVisibility(String slot, boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    _data.writeBoolean(visible);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeIcon(String slot) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeWindowStatus(int displayId, int vis, int backDisposition, boolean showImeSwitcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(vis);
                    _data.writeInt(backDisposition);
                    _data.writeBoolean(showImeSwitcher);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void expandSettingsPanel(String subPanel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subPanel);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RegisterStatusBarResult registerStatusBar(IStatusBar callbacks) throws RemoteException {
                RegisterStatusBarResult _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RegisterStatusBarResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, RegisterStatusBarResult> registerStatusBarForAllDisplays(IStatusBar callbacks) throws RemoteException {
                HashMap<String, RegisterStatusBarResult> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    int N2 = _reply.readInt();
                    _result = N2 < 0 ? null : new HashMap<String, RegisterStatusBarResult>();
                    IntStream.range(0, N2).forEach(i -> {
                        String k = _reply.readString();
                        RegisterStatusBarResult v = _reply.readTypedObject(RegisterStatusBarResult.CREATOR);
                        _result.put(k, v);
                    });
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPanelRevealed(boolean clearNotificationEffects, int numItems) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(clearNotificationEffects);
                    _data.writeInt(numItems);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPanelHidden() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void clearNotificationEffects() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationClick(String key, NotificationVisibility nv) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeTypedObject(nv, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationActionClick(String key, int actionIndex, Notification.Action action, NotificationVisibility nv, boolean generatedByAssistant) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeInt(actionIndex);
                    _data.writeTypedObject(action, 0);
                    _data.writeTypedObject(nv, 0);
                    _data.writeBoolean(generatedByAssistant);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationError(String pkg, String tag, int id2, int uid, int initialPid, String message, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(tag);
                    _data.writeInt(id2);
                    _data.writeInt(uid);
                    _data.writeInt(initialPid);
                    _data.writeString(message);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClearAllNotifications(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationClear(String pkg, int userId, String key, int dismissalSurface, int dismissalSentiment, NotificationVisibility nv, boolean fromBundle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(userId);
                    _data.writeString(key);
                    _data.writeInt(dismissalSurface);
                    _data.writeInt(dismissalSentiment);
                    _data.writeTypedObject(nv, 0);
                    _data.writeBoolean(fromBundle);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationVisibilityChanged(NotificationVisibility[] newlyVisibleKeys, NotificationVisibility[] noLongerVisibleKeys) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(newlyVisibleKeys, 0);
                    _data.writeTypedArray(noLongerVisibleKeys, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded, int notificationLocation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeBoolean(userAction);
                    _data.writeBoolean(expanded);
                    _data.writeInt(notificationLocation);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationDirectReplied(String key) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationSmartSuggestionsAdded(String key, int smartReplyCount, int smartActionCount, boolean generatedByAsssistant, boolean editBeforeSending) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeInt(smartReplyCount);
                    _data.writeInt(smartActionCount);
                    _data.writeBoolean(generatedByAsssistant);
                    _data.writeBoolean(editBeforeSending);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationSmartReplySent(String key, int replyIndex, CharSequence reply, int notificationLocation, boolean modifiedBeforeSending) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeInt(replyIndex);
                    if (reply != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(reply, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(notificationLocation);
                    _data.writeBoolean(modifiedBeforeSending);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationSettingsViewed(String key) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationBubbleChanged(String key, boolean isBubble, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeBoolean(isBubble);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBubbleMetadataFlagChanged(String key, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideCurrentInputMethodForBubbles(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantInlineReplyUriPermission(String key, Uri uri, UserHandle user, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeTypedObject(uri, 0);
                    _data.writeTypedObject(user, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearInlineReplyUriPermissions(String key) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationFeedbackReceived(String key, Bundle feedback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeTypedObject(feedback, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGlobalActionsShown() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGlobalActionsHidden() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reboot(boolean safeMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(safeMode);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restart() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clickTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleSystemKey(KeyEvent key) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(key, 0);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastSystemKey() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showPinningEnterExitToast(boolean entering) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(entering);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showPinningEscapeToast() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showAuthenticationDialog(PromptInfo promptInfo, IBiometricSysuiReceiver sysuiReceiver, int[] sensorIds, boolean credentialAllowed, boolean requireConfirmation, int userId, long operationId, String opPackageName, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(promptInfo, 0);
                    _data.writeStrongInterface(sysuiReceiver);
                    _data.writeIntArray(sensorIds);
                    _data.writeBoolean(credentialAllowed);
                    _data.writeBoolean(requireConfirmation);
                    _data.writeInt(userId);
                    _data.writeLong(operationId);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricAuthenticated(int modality) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricHelp(int modality, String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricError(int modality, int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideAuthenticationDialog(long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBiometicContextListener(IBiometricContextListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUdfpsRefreshRateCallback(IUdfpsRefreshRateRequestCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInattentiveSleepWarning() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissInattentiveSleepWarning(boolean animated) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(animated);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTracing() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopTracing() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTracing() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressAmbientDisplay(boolean suppress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(suppress);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestTileServiceListeningState(ComponentName componentName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAddTile(ComponentName componentName, CharSequence label, Icon icon, int userId, IAddTileResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    if (label != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(label, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedObject(icon, 0);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelRequestAddTile(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavBarMode(int navBarMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(navBarMode);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNavBarMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSessionListener(int sessionFlags, ISessionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionFlags);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSessionListener(int sessionFlags, ISessionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionFlags);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionStarted(int sessionType, InstanceId instanceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionType);
                    _data.writeTypedObject(instanceId, 0);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionEnded(int sessionType, InstanceId instanceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionType);
                    _data.writeTypedObject(instanceId, 0);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateMediaTapToTransferSenderDisplay(int displayState, MediaRoute2Info routeInfo, IUndoMediaTransferCallback undoCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayState);
                    _data.writeTypedObject(routeInfo, 0);
                    _data.writeStrongInterface(undoCallback);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateMediaTapToTransferReceiverDisplay(int displayState, MediaRoute2Info routeInfo, Icon appIcon, CharSequence appName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayState);
                    _data.writeTypedObject(routeInfo, 0);
                    _data.writeTypedObject(appIcon, 0);
                    if (appName != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(appName, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showRearDisplayDialog(int currentBaseState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(currentBaseState);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatusBarService {
        @Override
        public void expandNotificationsPanel() throws RemoteException {
        }

        @Override
        public void collapsePanels() throws RemoteException {
        }

        @Override
        public void togglePanel() throws RemoteException {
        }

        @Override
        public void disable(int what, IBinder token, String pkg) throws RemoteException {
        }

        @Override
        public void disableForUser(int what, IBinder token, String pkg, int userId) throws RemoteException {
        }

        @Override
        public void disable2(int what, IBinder token, String pkg) throws RemoteException {
        }

        @Override
        public void disable2ForUser(int what, IBinder token, String pkg, int userId) throws RemoteException {
        }

        @Override
        public int[] getDisableFlags(IBinder token, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setIcon(String slot, String iconPackage, int iconId, int iconLevel, String contentDescription) throws RemoteException {
        }

        @Override
        public void setIconVisibility(String slot, boolean visible) throws RemoteException {
        }

        @Override
        public void removeIcon(String slot) throws RemoteException {
        }

        @Override
        public void setImeWindowStatus(int displayId, int vis, int backDisposition, boolean showImeSwitcher) throws RemoteException {
        }

        @Override
        public void expandSettingsPanel(String subPanel) throws RemoteException {
        }

        @Override
        public RegisterStatusBarResult registerStatusBar(IStatusBar callbacks) throws RemoteException {
            return null;
        }

        @Override
        public Map<String, RegisterStatusBarResult> registerStatusBarForAllDisplays(IStatusBar callbacks) throws RemoteException {
            return null;
        }

        @Override
        public void onPanelRevealed(boolean clearNotificationEffects, int numItems) throws RemoteException {
        }

        @Override
        public void onPanelHidden() throws RemoteException {
        }

        @Override
        public void clearNotificationEffects() throws RemoteException {
        }

        @Override
        public void onNotificationClick(String key, NotificationVisibility nv) throws RemoteException {
        }

        @Override
        public void onNotificationActionClick(String key, int actionIndex, Notification.Action action, NotificationVisibility nv, boolean generatedByAssistant) throws RemoteException {
        }

        @Override
        public void onNotificationError(String pkg, String tag, int id2, int uid, int initialPid, String message, int userId) throws RemoteException {
        }

        @Override
        public void onClearAllNotifications(int userId) throws RemoteException {
        }

        @Override
        public void onNotificationClear(String pkg, int userId, String key, int dismissalSurface, int dismissalSentiment, NotificationVisibility nv, boolean fromBundle) throws RemoteException {
        }

        @Override
        public void onNotificationVisibilityChanged(NotificationVisibility[] newlyVisibleKeys, NotificationVisibility[] noLongerVisibleKeys) throws RemoteException {
        }

        @Override
        public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded, int notificationLocation) throws RemoteException {
        }

        @Override
        public void onNotificationDirectReplied(String key) throws RemoteException {
        }

        @Override
        public void onNotificationSmartSuggestionsAdded(String key, int smartReplyCount, int smartActionCount, boolean generatedByAsssistant, boolean editBeforeSending) throws RemoteException {
        }

        @Override
        public void onNotificationSmartReplySent(String key, int replyIndex, CharSequence reply, int notificationLocation, boolean modifiedBeforeSending) throws RemoteException {
        }

        @Override
        public void onNotificationSettingsViewed(String key) throws RemoteException {
        }

        @Override
        public void onNotificationBubbleChanged(String key, boolean isBubble, int flags) throws RemoteException {
        }

        @Override
        public void onBubbleMetadataFlagChanged(String key, int flags) throws RemoteException {
        }

        @Override
        public void hideCurrentInputMethodForBubbles(int displayId) throws RemoteException {
        }

        @Override
        public void grantInlineReplyUriPermission(String key, Uri uri, UserHandle user, String packageName) throws RemoteException {
        }

        @Override
        public void clearInlineReplyUriPermissions(String key) throws RemoteException {
        }

        @Override
        public void onNotificationFeedbackReceived(String key, Bundle feedback) throws RemoteException {
        }

        @Override
        public void onGlobalActionsShown() throws RemoteException {
        }

        @Override
        public void onGlobalActionsHidden() throws RemoteException {
        }

        @Override
        public void shutdown() throws RemoteException {
        }

        @Override
        public void reboot(boolean safeMode) throws RemoteException {
        }

        @Override
        public void restart() throws RemoteException {
        }

        @Override
        public void addTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void remTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void clickTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void handleSystemKey(KeyEvent key) throws RemoteException {
        }

        @Override
        public int getLastSystemKey() throws RemoteException {
            return 0;
        }

        @Override
        public void showPinningEnterExitToast(boolean entering) throws RemoteException {
        }

        @Override
        public void showPinningEscapeToast() throws RemoteException {
        }

        @Override
        public void showAuthenticationDialog(PromptInfo promptInfo, IBiometricSysuiReceiver sysuiReceiver, int[] sensorIds, boolean credentialAllowed, boolean requireConfirmation, int userId, long operationId, String opPackageName, long requestId) throws RemoteException {
        }

        @Override
        public void onBiometricAuthenticated(int modality) throws RemoteException {
        }

        @Override
        public void onBiometricHelp(int modality, String message) throws RemoteException {
        }

        @Override
        public void onBiometricError(int modality, int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void hideAuthenticationDialog(long requestId) throws RemoteException {
        }

        @Override
        public void setBiometicContextListener(IBiometricContextListener listener) throws RemoteException {
        }

        @Override
        public void setUdfpsRefreshRateCallback(IUdfpsRefreshRateRequestCallback callback) throws RemoteException {
        }

        @Override
        public void showInattentiveSleepWarning() throws RemoteException {
        }

        @Override
        public void dismissInattentiveSleepWarning(boolean animated) throws RemoteException {
        }

        @Override
        public void startTracing() throws RemoteException {
        }

        @Override
        public void stopTracing() throws RemoteException {
        }

        @Override
        public boolean isTracing() throws RemoteException {
            return false;
        }

        @Override
        public void suppressAmbientDisplay(boolean suppress) throws RemoteException {
        }

        @Override
        public void requestTileServiceListeningState(ComponentName componentName, int userId) throws RemoteException {
        }

        @Override
        public void requestAddTile(ComponentName componentName, CharSequence label, Icon icon, int userId, IAddTileResultCallback callback) throws RemoteException {
        }

        @Override
        public void cancelRequestAddTile(String packageName) throws RemoteException {
        }

        @Override
        public void setNavBarMode(int navBarMode) throws RemoteException {
        }

        @Override
        public int getNavBarMode() throws RemoteException {
            return 0;
        }

        @Override
        public void registerSessionListener(int sessionFlags, ISessionListener listener) throws RemoteException {
        }

        @Override
        public void unregisterSessionListener(int sessionFlags, ISessionListener listener) throws RemoteException {
        }

        @Override
        public void onSessionStarted(int sessionType, InstanceId instanceId) throws RemoteException {
        }

        @Override
        public void onSessionEnded(int sessionType, InstanceId instanceId) throws RemoteException {
        }

        @Override
        public void updateMediaTapToTransferSenderDisplay(int displayState, MediaRoute2Info routeInfo, IUndoMediaTransferCallback undoCallback) throws RemoteException {
        }

        @Override
        public void updateMediaTapToTransferReceiverDisplay(int displayState, MediaRoute2Info routeInfo, Icon appIcon, CharSequence appName) throws RemoteException {
        }

        @Override
        public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider) throws RemoteException {
        }

        @Override
        public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider) throws RemoteException {
        }

        @Override
        public void showRearDisplayDialog(int currentBaseState) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

