/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.IntentFilter;
import android.content.pm.PathPermission;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.PatternMatcher;
import android.util.Slog;
import com.android.internal.R;
import com.android.internal.hidden_from_bootclasspath.android.multiuser.Flags;
import com.android.internal.pm.pkg.component.ComponentParseUtils;
import com.android.internal.pm.pkg.component.ParsedComponentUtils;
import com.android.internal.pm.pkg.component.ParsedIntentInfoImpl;
import com.android.internal.pm.pkg.component.ParsedMainComponentUtils;
import com.android.internal.pm.pkg.component.ParsedProvider;
import com.android.internal.pm.pkg.component.ParsedProviderImpl;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedProviderUtils {
    private static final String TAG = "PackageParsing";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ParseResult<ParsedProvider> parseProvider(String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, boolean useRoundIcon, @Nullable String defaultSplitName, @NonNull ParseInput input) throws IOException, XmlPullParserException {
        boolean visibleToEphemeral;
        String authority;
        int targetSdkVersion = pkg.getTargetSdkVersion();
        String packageName = pkg.getPackageName();
        ParsedProviderImpl provider = new ParsedProviderImpl();
        String tag = parser.getName();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProvider);
        try {
            ParseResult<ParsedProviderImpl> result = ParsedMainComponentUtils.parseMainComponent(provider, tag, separateProcesses, pkg, sa, flags, useRoundIcon, defaultSplitName, input, 17, 14, 18, 6, 1, 0, 15, 2, 8, 19, 21, 23, 25);
            if (result.isError()) {
                ParseResult<ParsedProvider> parseResult = input.error(result);
                return parseResult;
            }
            authority = sa.getNonConfigurationString(10, 0);
            provider.setSyncable(sa.getBoolean(11, false)).setExported(sa.getBoolean(7, targetSdkVersion < 17));
            String permission2 = sa.getNonConfigurationString(3, 0);
            String readPermission = sa.getNonConfigurationString(4, 0);
            if (readPermission == null) {
                readPermission = permission2;
            }
            if (readPermission == null) {
                provider.setReadPermission(pkg.getPermission());
            } else {
                provider.setReadPermission(readPermission);
            }
            String writePermission = sa.getNonConfigurationString(5, 0);
            if (writePermission == null) {
                writePermission = permission2;
            }
            if (writePermission == null) {
                provider.setWritePermission(pkg.getPermission());
            } else {
                provider.setWritePermission(writePermission);
            }
            provider.setGrantUriPermissions(sa.getBoolean(13, false)).setForceUriPermissions(sa.getBoolean(22, false)).setMultiProcess(sa.getBoolean(9, false)).setInitOrder(sa.getInt(12, 0)).setFlags(provider.getFlags() | ComponentParseUtils.flag(0x40000000, 16, sa));
            if (Flags.enableSystemUserOnlyForServicesAndProviders()) {
                provider.setFlags(provider.getFlags() | ComponentParseUtils.flag(0x20000000, 24, sa));
            }
            if (visibleToEphemeral = sa.getBoolean(20, false)) {
                provider.setFlags(provider.getFlags() | 0x100000);
                pkg.setVisibleToInstantApps(true);
            }
        }
        finally {
            sa.recycle();
        }
        if (pkg.isSaveStateDisallowed() && Objects.equals(provider.getProcessName(), packageName)) {
            return input.error("Heavy-weight applications can not have providers in main process");
        }
        if (authority == null) {
            return input.error("<provider> does not include authorities attribute");
        }
        if (authority.length() <= 0) {
            return input.error("<provider> has empty authorities attribute");
        }
        provider.setAuthority(authority);
        return ParsedProviderUtils.parseProviderTags(pkg, tag, res, parser, visibleToEphemeral, provider, input);
    }

    @NonNull
    private static ParseResult<ParsedProvider> parseProviderTags(ParsingPackage pkg, String tag, Resources res, XmlResourceParser parser, boolean visibleToEphemeral, ParsedProviderImpl provider, ParseInput input) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Object> result;
            String name;
            if (type != 2) continue;
            if (ParsingPackageUtils.getAconfigFlags().skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            switch (name = parser.getName()) {
                case "intent-filter": {
                    ParseResult<ParsedIntentInfoImpl> intentResult = ParsedMainComponentUtils.parseIntentFilter(provider, pkg, res, parser, visibleToEphemeral, true, false, false, false, input);
                    result = intentResult;
                    if (!intentResult.isSuccess()) break;
                    ParsedIntentInfoImpl intent = intentResult.getResult();
                    IntentFilter intentFilter = intent.getIntentFilter();
                    provider.setOrder(Math.max(intentFilter.getOrder(), provider.getOrder()));
                    provider.addIntent(intent);
                    break;
                }
                case "meta-data": {
                    result = ParsedComponentUtils.addMetaData(provider, pkg, res, parser, input);
                    break;
                }
                case "property": {
                    result = ParsedComponentUtils.addProperty(provider, pkg, res, parser, input);
                    break;
                }
                case "grant-uri-permission": {
                    result = ParsedProviderUtils.parseGrantUriPermission(provider, pkg, res, parser, input);
                    break;
                }
                case "path-permission": {
                    result = ParsedProviderUtils.parsePathPermission(provider, pkg, res, parser, input);
                    break;
                }
                default: {
                    result = ParsingUtils.unknownTag(tag, pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        return input.success(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsedProvider> parseGrantUriPermission(ParsedProviderImpl provider, ParsingPackage pkg, Resources resources, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestGrantUriPermission);
        try {
            String name = parser.getName();
            PatternMatcher pa = null;
            String str = sa.getNonConfigurationString(4, 0);
            if (str != null) {
                pa = new PatternMatcher(str, 3);
            } else {
                str = sa.getNonConfigurationString(2, 0);
                if (str != null) {
                    pa = new PatternMatcher(str, 2);
                } else {
                    str = sa.getNonConfigurationString(1, 0);
                    if (str != null) {
                        pa = new PatternMatcher(str, 1);
                    } else {
                        str = sa.getNonConfigurationString(3, 0);
                        if (str != null) {
                            pa = new PatternMatcher(str, 4);
                        } else {
                            str = sa.getNonConfigurationString(0, 0);
                            if (str != null) {
                                pa = new PatternMatcher(str, 0);
                            }
                        }
                    }
                }
            }
            if (pa != null) {
                provider.addUriPermissionPattern(pa);
                provider.setGrantUriPermissions(true);
            } else {
                Slog.w(TAG, "Unknown element under <path-permission>: " + name + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
            }
            ParseResult<ParsedProvider> parseResult = input.success(provider);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsedProvider> parsePathPermission(ParsedProviderImpl provider, ParsingPackage pkg, Resources resources, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestPathPermission);
        try {
            String writePermission;
            String name = parser.getName();
            String permission2 = sa.getNonConfigurationString(0, 0);
            String readPermission = sa.getNonConfigurationString(1, 0);
            if (readPermission == null) {
                readPermission = permission2;
            }
            if ((writePermission = sa.getNonConfigurationString(2, 0)) == null) {
                writePermission = permission2;
            }
            boolean havePerm = false;
            if (readPermission != null) {
                readPermission = readPermission.intern();
                havePerm = true;
            }
            if (writePermission != null) {
                writePermission = writePermission.intern();
                havePerm = true;
            }
            if (!havePerm) {
                Slog.w(TAG, "No readPermission or writePermission for <path-permission>: " + name + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
                ParseResult<ParsedProvider> parseResult = input.success(provider);
                return parseResult;
            }
            PathPermission pa = null;
            String path = sa.getNonConfigurationString(7, 0);
            if (path != null) {
                pa = new PathPermission(path, 3, readPermission, writePermission);
            } else {
                path = sa.getNonConfigurationString(5, 0);
                if (path != null) {
                    pa = new PathPermission(path, 2, readPermission, writePermission);
                } else {
                    path = sa.getNonConfigurationString(4, 0);
                    if (path != null) {
                        pa = new PathPermission(path, 1, readPermission, writePermission);
                    } else {
                        path = sa.getNonConfigurationString(6, 0);
                        if (path != null) {
                            pa = new PathPermission(path, 4, readPermission, writePermission);
                        } else {
                            path = sa.getNonConfigurationString(3, 0);
                            if (path != null) {
                                pa = new PathPermission(path, 0, readPermission, writePermission);
                            }
                        }
                    }
                }
            }
            if (pa != null) {
                provider.addPathPermission(pa);
            } else {
                Slog.w(TAG, "No path, pathPrefix, or pathPattern for <path-permission>: " + name + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
            }
            ParseResult<ParsedProvider> parseResult = input.success(provider);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }
}

